unit DemoForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, Grids, DBGrids, StdCtrls, ExtCtrls, DBCtrls, DataFile;

type
  TFormFish = class(TForm)
    RGLoadMode: TRadioGroup;
    DBGrid2: TDBGrid;
    Table1: TTable;
    DataSource1: TDataSource;
    DBImage1: TDBImage;
    DBMemo1: TDBMemo;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    ButtonLoad: TButton;
    ButtonSave: TButton;
    DataFile1: TDataFile;
    ButtonAdd: TButton;
    ButtonSaveTable: TButton;
    procedure FormCreate(Sender: TObject);
    procedure RGLoadModeClick(Sender: TObject);
    procedure ButtonSaveClick(Sender: TObject);
    procedure ButtonLoadClick(Sender: TObject);
    procedure ButtonAddClick(Sender: TObject);
    procedure ButtonSaveTableClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormFish: TFormFish;

implementation

{$R *.DFM}

procedure TFormFish.FormCreate(Sender: TObject);
begin
  case DataFile1.LoadMode of
    lmAppend:       RGLoadMode.ItemIndex := 0;
    lmAppendUpdate: RGLoadMode.ItemIndex := 1;
    lmUpdate:       RGLoadMode.ItemIndex := 2;
    lmDelete:       RGLoadMode.ItemIndex := 3;
  end;
end;

procedure TFormFish.RGLoadModeClick(Sender: TObject);
begin
  Case RGLoadMode.ItemIndex of
    0: DataFile1.LoadMode := lmAppend;
    1: DataFile1.LoadMode := lmAppendUpdate;
    2: DataFile1.LoadMode := lmUpdate;
    3: DataFile1.LoadMode := lmDelete;
  end;
end;

procedure TFormFish.ButtonSaveClick(Sender: TObject);
begin
  if SaveDialog1.execute then
  begin
    if FileExists(SaveDialog1.FileName) then
    begin
       if (MessageDLG('File exists. Overwrite file?', mtConfirmation,
                   [mbOK, mbCancel], 0) = mrOK) then
         DeleteFile(SaveDialog1.FileName)
       else exit;
    end;

    DataFile1.AppendRecord(SaveDialog1.FileName);
  end;
end;

procedure TFormFish.ButtonLoadClick(Sender: TObject);
begin
  if OpenDialog1.execute then
  begin
    DataFile1.Load(OpenDialog1.FileName);

    // Update changes to tables
    Table1.Refresh;
  end;
end;

procedure TFormFish.ButtonAddClick(Sender: TObject);
begin
  if SaveDialog1.execute then DataFile1.AppendRecord(SaveDialog1.FileName);
end;

procedure TFormFish.ButtonSaveTableClick(Sender: TObject);
begin
  if SaveDialog1.execute then
  begin
    if FileExists(SaveDialog1.FileName) then DeleteFile(SaveDialog1.FileName);

    DataFile1.AppendTable(SaveDialog1.FileName);
  end;
end;

end.
