unit UDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, DBCtrls, ToolWin, ComCtrls, Grids, DBGrids, Db, DaoDS, StdCtrls;

type
  TDAODemo = class(TForm)
    DataSource: TDataSource;
    DAODataSet: TDAODataSet;
    DBGrid: TDBGrid;
    StatusBar: TStatusBar;
    ToolBar1: TToolBar;
    DBNavigator1: TDBNavigator;
    Button1: TButton;
    DAODatabase: TDAODatabase;
    procedure DataSourceDataChange(Sender: TObject; Field: TField);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DAODemo: TDAODemo;

implementation

uses DAO;

{$R *.DFM}

procedure TDAODemo.DataSourceDataChange(Sender: TObject; Field: TField);
begin
  with DAODataSet do
    StatusBar.SimpleText := 'Record: ' + IntToStr(RecNo) + '/' + IntToStr(RecordCount);
end;

procedure TDAODemo.Button1Click(Sender: TObject);
var TableDef: DAO.TableDef;
    Index: DAO.Index;
begin

  // create database
  GetDBEngine.CreateDatabase('Dyndemo.mdb', dbLangGeneral, NotUsed);
  DAODatabase.Open;

  with DAODatabase.Handle do
  begin
    // create table
    TableDef := CreateTableDef('COUNTRY', NotUsed, NotUsed, NotUsed);

    with TableDef do
    begin
      // create fields
      Fields.Append(CreateField('Name', DAO.dbText, 24));
      Fields.Append(CreateField('Capital', DAO.dbText, 24));
      Fields.Append(CreateField('Area', DAO.dbDouble, NotUsed));
      Fields.Append(CreateField('Population', DAO.dbDouble, NotUsed));

      // create index
      Index := CreateIndex('Index Name, Capital');
      with Index do
      begin
        Fields.Append(CreateField('Name', NotUsed, NotUsed));
        Fields.Append(CreateField('Capital', NotUsed, NotUsed));
      end;
      Indexes.Append(Index);
    end;

    // add table to table defs
    TableDefs.Append(TableDef);
  end;

  DAODataSet.Open;
end;

end.
