unit UShop;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, HttpEng, GenEng, HUtils, HDBUtils, DaoDS;

type
  TFormShopping = class(TForm)
    GeneralHttpEngine1: TGeneralHttpEngine;
    HttpDBGrid1: THttpDBGrid;
    HtmlShopping: THttpMemoFilter;
    HtmlPlaceOrder: THttpMemoFilter;
    HtmlConfirmation: THttpMemoFilter;
    DAODatasetProducts: TDAODataset;
    DAODatasetProductsId: TIntegerField;
    DAODatasetProductsName: TStringField;
    DAODatasetProductsCategory: TStringField;
    DAODatasetProductsPrice: TFloatField;
    DAODatasetProductsUnit: TStringField;
    DAODatasetCategory: TDAODataset;
    DAODatasetProductsAmount: TIntegerField;
    procedure GeneralHttpEngine1ExecRequest(Sender: TObject);
    procedure HttpDBGrid1CustomiseField(Sender: TObject; Field: TField;
      var FieldString, Link, Image: String;
      var FieldWidthType: TFieldWidthType; var TextColor, BGColor: TColor;
      var FontSize: TFontSize; var Bold, Italic, NoFlow, NoWrap: Boolean);
    procedure HtmlShoppingHttpEntry(EntryName: String;
      var Handled: Boolean);
  private
    { Private declarations }
    procedure ProcessOrder;
  public
    { Public declarations }
  end;

var
  FormShopping: TFormShopping;

threadvar
  Category : String;

implementation

{$R *.DFM}

procedure TFormShopping.ProcessOrder;
begin
  // In this procedure you must take care of the order
  // All ordered data is present in the session variables named "PRODUCT_x"
  // Where "x" is the product id found in products table and the value of the
  // session varibale is the quantity.
end;

procedure TFormShopping.GeneralHttpEngine1ExecRequest(Sender: TObject);
var
  Variables: TStringList;
  Amount: Double;
  i: Integer;
begin
  StartSession(Now + 1 / 24); // Start the session and let it last 1 hour ahead

  DAODataSetCategory.DatabaseName := ExtractFileDir(ExeOrDllPath) + '\shopping.mdb';
  DAODataSetProducts.DatabaseName := ExtractFileDir(ExeOrDllPath) + '\shopping.mdb';
  try
    DAODataSetCategory.Open;
    DAODataSetProducts.Open;
    Variables := FormVarNames;

    // Retrieve the last category used
    Category := FormVar('Category', SessionVar('Category', DAODataSetCategory.FieldbyName('Category').AsString));

    // Set the last category
    SetSessionVar('Category', Category);

    if FormVar('ClearOrder', '') > '' then
      RemoveSessionVars
    else
    begin
      // Update Quantities for Form Variables
      for i := 0 to Variables.Count - 1 do
        if Pos('PRODUCT_', Variables.Strings[i]) > 0 then
        begin
          try
            Amount := StrToFloat(Trim(Formvar(Variables.Strings[i], '0')));
          except
            Amount := 0;
          end;
          if Amount > 0 then
            SetSessionVar(Variables.Strings[i], FloatToStr(Amount))
          else
            RemoveSessionVar(Variables.Strings[i]);
        end;
    end;

    if FormVar('PlaceOrder', '') > '' then
      HtmlPlaceOrder.Put
    else if FormVar('DoOrder','') > '' then
    begin
      ProcessOrder;
      HtmlConfirmation.Put;
      StopSession;
    end
    else
      HtmlShopping.Put;

    Variables.Free;

    DAODataSetCategory.Close;
    DAODataSetProducts.Close;
  except
    PutLine('<HTML><BODY>To run this application you have to copy the products table files, found in the Examples/Database directory, into the same directory where this application is located.</BODY></HTML>');
  end;
end;

procedure TFormShopping.HtmlShoppingHttpEntry(EntryName: String;
  var Handled: Boolean);
var
  Variables : TStringList;
  i, ProductId: Integer;
  Amount, Total: Double;
begin
  if EntryName = 'SHOP_CATEGORIES' then
    with DAODataSetCategory do
    begin
      First;
      while not Eof do
      begin
        Put(' [<A HREF="' + ExecutablePath + '?Category=' +
            UrlEncode(FieldbyName('Category').AsString) + '">' +
            FieldbyName('Category').AsString +  '</A>] ');
        Next;
      end;
    end
  else if EntryName = 'SHOP_CATEGORY' then
    Put(Category)
  else if EntryName = 'SHOP_PRODUCTS' then
    with DAODataSetProducts do
    begin
      Filter := 'Category = ''' + Category + '''';
      Filtered := True;
      HttpDbGrid1.Put;
      Filtered := False;
    end
  else if EntryName = 'SHOP_BAG' then
  begin
    Variables := SessionVarNames;
    Total := 0;

    for i := 0 to Variables.Count - 1 do
      if Pos('PRODUCT_', Variables.Strings[i]) = 1 then
      begin
        ProductId := StrToInt(Copy(Variables.Strings[i], 9, 100));
        Amount := StrToInt(SessionVar(Variables.Strings[i], '0'));
        DAODataSetProducts.Locate('Id', ProductId, []);
        Put('<TR>');
        Put('<TD>' + FloatToStr(Amount) + ' ' + DAODataSetProductsUnit.AsString + '</TD>');
        Put('<TD>' + DAODataSetProductsName.AsString + '</TD>');
        Put('<TD ALIGN="RIGHT">' + Format('%.2f',[Amount * DAODataSetProductsPrice.Value]) + ' USD</TD>');
        Put('<TR>');
        Total := Total + Amount * DAODataSetProductsPrice.Value;
      end;

    Put('<TR><TD ALIGN=RIGHT COLSPAN=3><B>Total cost is ' + Format('%.2f', [Total]) + ' USD </B></TD></TR>');
    Variables.Free;
  end
  else
    Handled := False;  // Set false to indicate use of corresponding Form or Server Variables
end;

procedure TFormShopping.HttpDBGrid1CustomiseField(Sender: TObject; Field: TField;
  var FieldString, Link, Image: String;
  var FieldWidthType: TFieldWidthType; var TextColor, BGColor: TColor;
  var FontSize: TFontSize; var Bold, Italic, NoFlow, NoWrap: Boolean);
begin
  // Add an input field for the amount column
  // Set input name to "PRODUCT_x", where "x" is the product id found in products
  // and the value is the value of the corresponding session variable if exist else "0"of the session varibale is the quantity.

  if Field.FieldName = 'Amount' then
    FieldString := '<INPUT NAME="PRODUCT_' + DAODataSetProductsId.AsString+'" VALUE="' +SessionVar('PRODUCT_' + DAODataSetProductsId.AsString, '0') + '" SIZE=6>';
end;

end.
