unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, HQCreditCheck;

type
  TMainForm = class(TForm)
    CheckBtn: TButton;
    HQCreditCheck1: THQCreditCheck;
    Label1: TLabel;
    CCMaskEdit: TMaskEdit;
    Label2: TLabel;
    CardComboBox: TComboBox;
    Label3: TLabel;
    MComboBox: TComboBox;
    Label4: TLabel;
    YComboBox: TComboBox;
    procedure CheckBtnClick(Sender: TObject);
    procedure CardComboBoxChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure HQCreditCheck1Expired(Sender: TObject);
    procedure HQCreditCheck1InvalidDate(Sender: TObject);
    procedure HQCreditCheck1InvalidNumber(Sender: TObject);
    procedure HQCreditCheck1InvalidType(Sender: TObject);
    procedure HQCreditCheck1Valid(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.CheckBtnClick(Sender: TObject);
begin

HQCreditCheck1.CardNumber := CCMaskEdit.Text;
HQCreditCheck1.ExprDate := MComboBox.Text + '/' + YComboBox.Text;
If (HQCreditCheck1.CheckCreditCard) then
    ShowMessage('Credit Card Passed')
else
    ShowMessage('Credit Card Failed');
end;

procedure TMainForm.CardComboBoxChange(Sender: TObject);
begin

Case CardComboBox.ItemIndex of
0: HQCreditCheck1.CardType := cctVisa;
1: HQCreditCheck1.CardType := cctMastercard;
2: HQCreditCheck1.CardType := cctAmex;
3: HQCreditCheck1.CardType := cctDiscover;
4: HQCreditCheck1.CardType := cctDiners;
end;

end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
MComboBox.ItemIndex := 0;
YComboBox.ItemIndex := 0;
end;

procedure TMainForm.HQCreditCheck1Expired(Sender: TObject);
begin
ShowMessage('Card Expired');
end;

procedure TMainForm.HQCreditCheck1InvalidDate(Sender: TObject);
begin
ShowMessage('Invalid Date');
end;

procedure TMainForm.HQCreditCheck1InvalidNumber(Sender: TObject);
begin
ShowMessage('Invalid Card Number');
end;

procedure TMainForm.HQCreditCheck1InvalidType(Sender: TObject);
begin
ShowMessage('Invalid Card Type vs Card Number');
end;

procedure TMainForm.HQCreditCheck1Valid(Sender: TObject);
begin
ShowMessage('Card Valid');
end;

end.
