unit Settings;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, ExtCtrls, PortTest, TComm_32;

type
  TFormSettings = class(TForm)
    RGSize: TRadioGroup;
    RGStop: TRadioGroup;
    RGParity: TRadioGroup;
    RGIsParity: TRadioGroup;
    bOK: TButton;
    bCancel: TButton;
    Label1: TLabel;
    Edit1: TEdit;
    cbComPort: TComboBox;
    cbBaud: TComboBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Edit2: TEdit;
    procedure RGStopClick(Sender: TObject);
    procedure RGSpeedClick(Sender: TObject);
    procedure RGSizeClick(Sender: TObject);
    procedure RGParityClick(Sender: TObject);
    procedure RGIsParityClick(Sender: TObject);
    procedure bOKClick(Sender: TObject);
    procedure bCancelClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure cbComPortChange(Sender: TObject);
    procedure cbBaudChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormSettings: TFormSettings;

implementation

{$R *.DFM}

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TFormSettings.RGStopClick(Sender: TObject);
begin
{ Set the Number of Stop Bits from the Radio Group}
with sender as TRadioGroup do
  begin
     if ItemIndex= 0 then Stop_Bits:=_1;
     if ItemIndex= 1 then Stop_Bits:=_1_5;
     if ItemIndex= 2 then Stop_Bits:=_2;
  end;
end;

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TFormSettings.RGSpeedClick(Sender: TObject);
begin
{ Set the Com Port Speed from the Radio Group}
(*
with sender as TRadioGroup do
  begin
       if ItemIndex= 0 then Speed:=B110;
       if ItemIndex= 1 then Speed:=B300;
       if ItemIndex= 2 then Speed:=B1200;
       if ItemIndex= 3 then Speed:=B2400;
       if ItemIndex= 4 then Speed:=B4800;
       if ItemIndex= 5 then Speed:=B9600;
       if ItemIndex= 6 then Speed:=B14400;
       if ItemIndex= 7 then Speed:=B19200;
       if ItemIndex= 8 then Speed:=B38400;
       if ItemIndex= 9 then Speed:=NotSet;
  end;
05.05.97 D.V.B.*)

end;

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TFormSettings.RGSizeClick(Sender: TObject);
begin
{ Set the Byte Size from the Radio Group}

with sender as TRadioGroup do
  begin
       if ItemIndex= 0 then   Byte_Size:= _6;
       if ItemIndex= 1 then   Byte_Size:= _7;
       if ItemIndex= 2 then   Byte_Size:= _8;
  end;
end;

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TFormSettings.RGParityClick(Sender: TObject);
begin
{ Set the Parity from the Radio Group}

with sender as TRadioGroup do
  begin
     if ItemIndex= 0 then   _Parity:= None;
     if ItemIndex= 1 then   _Parity:= Odd;
     if ItemIndex= 2 then   _Parity:= Even;
     if ItemIndex= 3 then   _Parity:= Mark;
     if ItemIndex= 4 then   _Parity:= Space;
  end;
end;

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TFormSettings.RGIsParityClick(Sender: TObject);
begin
{ Enable Parity Checking from the Radio Group}

with sender as TRadioGroup do
  begin
   if ItemIndex= 0 then   IsParity:=True ;
   if ItemIndex= 1 then   IsParity:=False ;
  end;
end;

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TFormSettings.bOKClick(Sender: TObject);
begin
{ Modify Com Port Component Settings - it will then update through the Win32 API}
  with testForm.Commport1 do
    begin
      if WComID <1 then { WComID is >0 if ComPort is Opened}
      begin            { These settings can actually be changed while the port is open}
        comport  := ComName;
        application.processmessages;
        Baud     := Speed;
        application.processmessages;
        Parity   := _Parity;
        application.processmessages;
        StopBits := Stop_Bits;
        application.processmessages;
        BYteSize := Byte_Size;
        application.processmessages;
        ParityEnable := IsParity;
        application.processmessages;
        ReadTotalTimeOut := StrToInt(trim(Edit1.Text));
        application.processmessages;
        BytesToRecieve := StrToInt(edit2.text);
      end  {if }
      else
        showmessage('Can not perform this operation on opened com port!');
  end; { With Clause}
  close;
end;

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TFormSettings.bCancelClick(Sender: TObject);
begin
  close;
end;

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TFormSettings.FormShow(Sender: TObject);
begin
{Make Settings form show the current ComPort Component Settings}

with testForm.Commport1 do
Begin
  Case StopBits of
    _1:  begin
           Stop_Bits:=_1;
           RGStop.ItemIndex:=0;
          end;
    _1_5: begin
            RGStop.ItemIndex:=1;
            Stop_Bits:=_1_5;
          end;
    _2:   begin
            RGStop.ItemIndex:=2;
            Stop_Bits:=_2;
          end
  end; { End Stop Bits Case}
///////////////////////////////////////////
//following code is added 05.05.97 D.V.B.
  if length(trim(ComName)) <> 0 then
    cbComPort.Text := ComPort
  else
    begin
      cbComPort.Text := 'COM1';
      ComName        := 'COM1';
    end; // else if length(trim(ComPort)) <> 0 then
  if length(trim(Speed)) <> 0 then
    cbBaud.Text := Speed
  else
    begin
      cbBaud.Text := '9600';
      Speed       := '9600';
    end;// if length(trim(Speed)) <> 0 then
//end of the code added 05.05.97 D.V.B.
/////////////////////////////////////////////

 (*
  Case ComPort of
    Com1: begin
            rgCommPort.ItemIndex:=0;
            ComName:= com1;
          end;

    Com2: begin
            rgCommPort.ItemIndex:=1;
            ComName:= Com2;
          end;
    Com3: begin
            rgCommPort.ItemIndex:=2;
            ComName:=Com3;
          end;
    Com4: begin
            rgCommPort.ItemIndex:=3;
            ComName:= com4;
          end
    end; { Comm Port Case}
  05.05.97 D.V.B. *)
   (*         05.05.97 D.V.B.
  Case BAUD of
    B110:   Begin
              RGSpeed.Itemindex:=0;
              Speed:=B110;
            end;
    B300:   Begin
              RGSpeed.Itemindex:=0;
              Speed:=B300;
            end;
    B1200:  begin
              RGSpeed.Itemindex:=2;
              Speed:=B1200;
            end;
    B2400:  begin
              RGSpeed.Itemindex:=3;
              Speed:= B2400;
            end;
    B4800:  begin
              RGSpeed.Itemindex:=4;
              Speed:=B4800;
            end;
    B9600:  begin
              RGSpeed.Itemindex:=5;
              Speed:=B9600;
            end;
    B14400: begin
              RGSpeed.Itemindex:=6;
              Speed:=b14400;
            end;
    B19200: begin
              RGSpeed.Itemindex:=7;
              Speed:=B19200;
            end;
    B38400: begin
              RGSpeed.Itemindex:=8;
              Speed:=B38400;
            end
  end; { End BAUD Case}
     *)
  Case ByteSize of
    _6: begin
          RGSize.Itemindex:=0;
          Byte_Size:=_6;
        end;
    _7: begin
          RGSize.Itemindex:=1;
          Byte_Size:=_7;
        end;
    _8: begin
          RGSize.Itemindex:=2;
          Byte_Size:=_8;
        end
  end; { ByteSize Case}

  Case Parity of
    None: begin
            RGParity.Itemindex:=0;
            _Parity:=None;
          end;
    Odd:  begin
            RGParity.Itemindex:=1;
            _Parity:=Odd;
          end;
    Even: begin
            RGParity.Itemindex:=2;
            _Parity:=Even;
          end;
    Mark: begin
            RGParity.Itemindex:=3;
            _Parity:=Mark;
          end;
    Space:begin
            RGParity.Itemindex:=4;
            _Parity:=Space;
           end
  end; {Parity Case}

  if ParityEnable=True then
        begin
          RGIsParity.ItemIndex:=0;
          IsParity:= True;
        end;
  if ParityEnable=False then
        begin
          RGIsParity.ItemIndex:=1;
          IsParity:=False;
        end;

  Edit1.Text:= intToStr(ReadTotalTimeOut);
  edit2.text:= inttoStr(BytesToRecieve);
end; { End With CommPort1 Clause}

end; { Procedure}



procedure TFormSettings.cbComPortChange(Sender: TObject);
begin
ComName := cbComPort.Text;
end;

procedure TFormSettings.cbBaudChange(Sender: TObject);
begin
Speed := cbBaud.Text;
end;

end.  { Unit}
