unit CGreport;
{$DEFINE DELPHI2}
{$DEFINE DELPHI3}

interface

uses
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  CGrid,WinProcs,WinTypes, Extctrls,
{$IFDEF DELPHI2}
{$IFDEF DELPHI3}
  QuickRpt,
  Qrprntr,
{$ELSE}
  QuickRep,
{$ENDIF}
{$ENDIF}

  Printers;

Const
  PAGEBUFSZ = 70;
  DEFAULTHEIGHT=24;
  PAGERATIO = 6.25;
  XCELLMARGIN = 2;
  YCELLMARGIN = 2;
type
  TPrintXCellEvent = procedure (Sender: TObject; Col, Row: Longint;
    var Xcell : string) of object;
  TLogoPosition = (lpBeforeText,lpAfterText);
  PLongint = ^Longint;

  TCGridReport = class(TComponent)
  private
    FDBCrossGrid : TDBCrossGrid;
    FLeftMargin: integer;
    FRightMargin: integer;
    FTopMargin : integer;
    FBottomMargin : integer;
    FHeaderHeight : integer;
{
    FHeaderColor : TColor;
}
    FHeaderFont : TFont;
    FHeaderText : String;
    FHeaderAlign : TAlignment;
    FHeaderLogo : TImage;
    FHeaderLogoPos : TLogoPosition;
    FHeaderLogoWidth : integer;
    FFooterHeight : integer;
{
    FFooterColor : TColor;
}
    FFooterFont : TFont;
    FFooterText : String;
    FFooterAlign : TAlignment;
    FFooterLogo : TImage;
    FFooterLogoPos : TLogoPosition;
    FFooterLogoWidth : integer;
    FLineStyle : TPenStyle;
    FOnPrintXCell : TPrintXCellEvent;
    Fpratiox : double;
    Fpratioy : double;
    FOriginalPrint : TQRGenerateToPrinterEvent;
    procedure DrawOutline(
       torgx,torgy,twidth,theight : integer;
       startrow,endrow,startcol,endcol : integer);
    procedure DrawPicture(descanvas : TCanvas;simage : TImage;ARect : TRect);
    procedure SetDBCrossGrid(Const Value : TDBCrossGrid);
    procedure SetHeaderFont(Const Value : TFont);
    procedure SetHeaderHeight(Const Value : Integer);
    procedure SetFooterFont(Const Value : TFont);
    procedure SetFooterHeight(Const Value : Integer);
    function  GetCell(ACol,ARow : Longint) : String;
  protected
    { Protected declarations }
  public
    constructor Create(AOwner: TComponent); override;
    destructor destroy; override;
    procedure Print;
{$IFDEF DELPHI2}
    procedure Preset;
    procedure Preview;
{$ENDIF}
    procedure CreateHTML(filename:String);
    procedure CreateASCII(filename:String; sep : string);
  published
    property DBCrossGrid : TDBCrossGrid read FDBCrossGrid write SetDBCrossGrid;
    property LeftMargin: integer read FLeftMargin write FLeftMargin;
    property RightMargin: integer read FRightMargin write FRightMargin;
    property TopMargin : integer read FTopMargin write FTopMargin;
    property BottomMargin : integer read FBottomMargin write FBottomMargin;
    property HeaderHeight : integer read FHeaderHeight write SetHeaderHeight;
{
    property HeaderColor : TColor read FHeaderColor write FHeaderColor;
}
    property HeaderFont : TFont read FHeaderFont write SetHeaderFont;
    property HeaderText : String read FHeaderText write FHeaderText;
    property HeaderAlign : TAlignment read FHeaderAlign write FHeaderAlign;
    property HeaderLogo : TImage read FHeaderLogo write FHeaderLogo;
    property HeaderLogoPos : TLogoPosition read FHeaderLogoPos write FHeaderLogoPos;
    property HeaderLogoWidth : integer read FHeaderLogoWidth
    	write FHeaderLogoWidth;
    property FooterHeight : integer read FFooterHeight write SetFooterHeight;
{
    property FooterColor : TColor read FFooterColor write FFooterColor;
}
    property FooterFont : TFont read FFooterFont write SetFooterFont;
    property FooterText : String read FFooterText Write FFooterText;
    property FooterAlign : TAlignment read FFooterAlign write FFooterAlign;
    property FooterLogo : TImage read FFooterLogo write FFooterLogo;
    property FooterLogoPos : TLogoPosition read FFooterLogoPos write FFooterLogoPos;
    property FooterLogoWidth : integer read FFooterLogoWidth 
    	write FFooterLogoWidth;
    property LineStyle : TPenStyle read FLineStyle write FLineStyle; 
    property OnPrintXCell: TPrintXCellEvent read FOnPrintXCell write FOnPrintXCell;
  end;

implementation
procedure xxx(Index : Integer; arrayp : PLongint;
  var count : Integer);
begin
end;

procedure TCGridReport.DrawOutline(
   torgx,torgy,twidth,theight : integer;
   startrow,endrow,startcol,endcol : integer
   );
  function GetTotalWidth(scol,ecol: integer) : Integer;
  var
    twidth : integer;
    i : integer;
  begin
    twidth := 0;
    for i := scol to ecol do
      twidth := twidth + FDBCrossGrid.ColWidths[i];
    Result := twidth;
  end;

  function GetTotalHeight(srow,erow: integer) : Integer;
  var
    theight : integer;
    i : integer;
  begin
    theight := 0;
    for i := srow to erow do
      theight := theight + FDBCrossGrid.RowHeights[i];
    Result := theight;
  end;

var
  i,j : integer;
  x1,y1,x2,y2 : integer;
  x3,y3,x4,y4 : integer;
  ntheight,ntwidth : integer;
  fixedh,fixedw : integer;
  ncrow, nccol : integer;
  norgx,norgy : integer;
  nstartrow,nstartcol : integer;
  cnt,cnt1 : Integer;
  arrayp,arrayi : PLongint;
  colcnt : Longint;
begin
{$IFDEF DELPHI2 }
  QRPrinter.Canvas.Pen.Style := psSolid;
{$ELSE}
  Printer.Canvas.Pen.Style := psSolid;
{$ENDIF}
  nstartrow := startrow;
  nstartcol := startcol;
  With FDBCrossGrid do
    begin
      ncrow := FixedRows;
      nccol := GetNumCrossCols;
    end;
  fixedw := GetTotalWidth(startcol,nccol-1);
  fixedh := GetTotalHeight(startrow,ncrow-1);

  ntwidth := GetTotalWidth(startcol,endcol);
  ntheight := GetTotalHeight(startrow,endrow);

{$IFDEF DELPHI2 }
  QRPrinter.Canvas.Rectangle(
  	Trunc(torgx * Fpratiox),
	Trunc(torgy * Fpratioy),
	Trunc((torgx+ntwidth) * Fpratiox),
	Trunc((torgy+ntheight) * Fpratioy));
{$ELSE}
  Printer.Canvas.Rectangle(
  	Trunc(torgx * Fpratiox),
	Trunc(torgy * Fpratioy),
	Trunc((torgx+ntwidth) * Fpratiox),
	Trunc((torgy+ntheight) * Fpratioy));
{$ENDIF}
{
** draw fixed fixed area
}
  if((startrow < ncrow) and (startcol < nccol)) then
    begin
      x1 := torgx;
      x2 := torgx + fixedw;
      y1 := torgy + fixedh;
      y2 := torgy + fixedh;
{$IFDEF DELPHI2 }
      QRPrinter.Canvas.PolyLine([
      	point(Trunc(x1*Fpratiox),Trunc(y1*Fpratioy)),
	point(Trunc(x2*Fpratiox),Trunc(y2*Fpratioy))]);
{$ELSE}
      Printer.Canvas.PolyLine([
      	point(Trunc(x1*Fpratiox),Trunc(y1*Fpratioy)),
	point(Trunc(x2*Fpratiox),Trunc(y2*Fpratioy))]);
{$ENDIF}
      x1 := torgx + fixedw;
      x2 := torgx + fixedw;
      y1 := torgy ;
      y2 := torgy + fixedh;
{$IFDEF DELPHI2 }
      QRPrinter.Canvas.PolyLine([
      	point(Trunc(x1*Fpratiox),Trunc(y1*Fpratioy)),
	point(Trunc(x2*Fpratiox),Trunc(y2*Fpratioy))]);
{$ELSE}
      Printer.Canvas.PolyLine([
      	point(Trunc(x1*Fpratiox),Trunc(y1*Fpratioy)),
	point(Trunc(x2*Fpratiox),Trunc(y2*Fpratioy))]);
{$ENDIF}
    end;
{
** draw fixed rows
}
  colcnt := FDBCrossGrid.GetColCount;
  if(startrow < ncrow) then
    begin
      x1 := torgx + fixedw;
      y1 := torgy;
      x2 := torgx + ntwidth;
      y2 := torgy;
      arrayp := AllocMem(colcnt*(sizeof(Longint)));
      if(arrayp = nil) then
        begin
          messagedlg('Not enough memory for draw fixed rows',mtError,[mbAbort],0);
          exit;
        end;
      for i := startrow to ncrow - 1 do
        begin
	  x3 := x1;
	  x4 := x1;
	  y3 := y1;
          y4 := y3;
          for j := i to ncrow - 1 do
            y4 := y4 + FDBCrossGrid.RowHeights[j];
          FDBCrossGrid.GetFixedRowDataes(i,Pointer(arrayp),cnt);
          arrayi := arrayp;
		  cnt1 := 0;
          while((arrayi^ < startcol) and (cnt1 < cnt)) do
	    begin
              Inc(arrayi);
              Inc(cnt1);
	    end;
	  for j := startcol to endcol - 1 do
	    begin
              if(j < nccol ) then
                continue;
              x3 := x3 + FDBCrossGrid.ColWidths[j];
              x4 := x3;
	      if(j < arrayi^) then
	        continue;
	      if(cnt1 < cnt) then
		begin
                  Inc(arrayi);
		  Inc(cnt1);
		end;
{$IFDEF DELPHI2}
              QRPrinter.Canvas.PolyLine([
             	point(Trunc(x3*Fpratiox),Trunc(y3*Fpratioy)), 
	        point(Trunc(x4*Fpratiox),Trunc(y4*Fpratioy))]);
{$ELSE}
              Printer.Canvas.PolyLine([
             	point(Trunc(x3*Fpratiox),Trunc(y3*Fpratioy)), 
	        point(Trunc(x4*Fpratiox),Trunc(y4*Fpratioy))]);
{$ENDIF}
	    end;
          y1 := y1 + FDBCrossGrid.RowHeights[i];
          y2 := y2 + FDBCrossGrid.RowHeights[i];
{$IFDEF DELPHI2}
          QRPrinter.Canvas.PolyLine([
        	point(Trunc(x1*Fpratiox),Trunc(y1*Fpratioy)), 
        	point(Trunc(x2*Fpratiox),Trunc(y2*Fpratioy))]);
{$ELSE}
          Printer.Canvas.PolyLine([
        	point(Trunc(x1*Fpratiox),Trunc(y1*Fpratioy)), 
        	point(Trunc(x2*Fpratiox),Trunc(y2*Fpratioy))]);
{$ENDIF}
        end;
      FreeMem(arrayp,colcnt*(sizeof(Longint)));
      arrayp := nil;
      nstartrow := ncrow;
    end;
{
** draw fixed cols
}
  if(startcol < nccol) then
    begin
      x1 := torgx;
      y1 := torgy + fixedh;
      x2 := torgx;
      y2 := torgy + ntheight;
      arrayp := AllocMem(FDBCrossGrid.GetRowCount*(sizeof(Longint)));
      if(arrayp = nil) then
        begin
          messagedlg('Not enough memory for draw fixed cols',mtError,[mbAbort],0);
          exit;
        end;
      for i := startcol to nccol - 1 do
        begin
	  x3 := x1;
	  x4 := x1;
	  y3 := y1;
	  y4 := y3;
          for j := i to nccol - 1 do
	        x4 := x4 + FDBCrossGrid.ColWidths[j];
	      FDBCrossGrid.GetFixedColDataes(i,Pointer(arrayp),cnt,1);
	      arrayi := arrayp;
		  cnt1 := 0;
          while((arrayi^ < startrow) and (cnt1 < cnt)) do
		    begin
              Inc(arrayi);
			  Inc(cnt1);
			end;
	  for j := startrow to endrow - 1 do
	    begin
              if(j < ncrow ) then
                continue;
              y3 := y3 + FDBCrossGrid.RowHeights[j];
              y4 := y3;
	          if(j < arrayi^) then
	            continue;
			  if(cnt1 < cnt) then
			    begin
                  Inc(arrayi);
                  Inc(cnt1);
			    end;
{$IFDEF DELPHI2}
              QRPrinter.Canvas.PolyLine([
             	point(Trunc(x3*Fpratiox),Trunc(y3*Fpratioy)), 
	        point(Trunc(x4*Fpratiox),Trunc(y4*Fpratioy))]);
{$ELSE}
              Printer.Canvas.PolyLine([
             	point(Trunc(x3*Fpratiox),Trunc(y3*Fpratioy)), 
	        point(Trunc(x4*Fpratiox),Trunc(y4*Fpratioy))]);
{$ENDIF}
	    end;
          x1 := x1 + FDBCrossGrid.ColWidths[i];
          x2 := x2 + FDBCrossGrid.ColWidths[i];
{$IFDEF DELPHI2}
          QRPrinter.Canvas.PolyLine([
        	point(Trunc(x1*Fpratiox),Trunc(y1*Fpratioy)), 
        	point(Trunc(x2*Fpratiox),Trunc(y2*Fpratioy))]);
{$ELSE}
          Printer.Canvas.PolyLine([
        	point(Trunc(x1*Fpratiox),Trunc(y1*Fpratioy)), 
        	point(Trunc(x2*Fpratiox),Trunc(y2*Fpratioy))]);
{$ENDIF}
        end;
      FreeMem(arrayp,FDBCrossGrid.GetRowCount*(sizeof(Longint)));
      arrayp := nil;
      nstartcol := nccol;
    end;

{$IFDEF DELPHI2}
  QRPrinter.Canvas.Pen.Style := FLineStyle;
{$ELSE}
  Printer.Canvas.Pen.Style := FLineStyle;
{$ENDIF}
  if(goCGVertLine in FDBCrossGrid.CGOptions) then
    begin
      x1 := torgx + fixedw + FDBCrossGrid.ColWidths[nstartcol];
      y1 := torgy + fixedh;
      x2 := torgx + fixedw + FDBCrossGrid.ColWidths[nstartcol];
      y2 := torgy + ntheight;
      for i := nstartcol + 1 to endcol do
        begin
{$IFDEF DELPHI2 }
         QRPrinter.Canvas.PolyLine([
        	point(Trunc(x1*Fpratiox),Trunc(y1*Fpratioy)), 
        	point(Trunc(x2*Fpratiox),Trunc(y2*Fpratioy))]);
{$ELSE}
         Printer.Canvas.PolyLine([
        	point(Trunc(x1*Fpratiox),Trunc(y1*Fpratioy)), 
        	point(Trunc(x2*Fpratiox),Trunc(y2*Fpratioy))]);
{$ENDIF}
	  x1 := x1 + FDBCrossGrid.ColWidths[i];
	  x2 := x2 + FDBCrossGrid.ColWidths[i];
	end
    end;
  if(goCGHorzLine in FDBCrossGrid.CGOptions) then
    begin
      x1 := torgx + fixedw;
      y1 := torgy + fixedh + FDBCrossGrid.RowHeights[nstartrow];
      x2 := torgx + ntwidth;
      y2 := torgy + fixedh + FDBCrossGrid.RowHeights[nstartrow];
      for i := nstartrow+1 to endrow do
        begin
{$IFDEF DELPHI2}
          QRPrinter.Canvas.PolyLine([
        	point(Trunc(x1*Fpratiox),Trunc(y1*Fpratioy)), 
	        point(Trunc(x2*Fpratiox),Trunc(y2*Fpratioy))]);
{$ELSE}
          Printer.Canvas.PolyLine([
        	point(Trunc(x1*Fpratiox),Trunc(y1*Fpratioy)), 
	        point(Trunc(x2*Fpratiox),Trunc(y2*Fpratioy))]);
{$ENDIF}
	  y1 := y1 + FDBCrossGrid.RowHeights[i];
	  y2 := y2 + FDBCrossGrid.RowHeights[i];
	end
    end;      
end;

procedure TCGridReport.DrawPicture(descanvas : TCanvas;simage : TImage;ARect : TRect);
var
  cwidth,cheight : integer;
  desrect : TRect;
  srcrect : TRect;
begin
    cwidth := ARect.right - ARect.left;
    cheight := ARect.bottom - ARect.top;
    with simage.picture do
      begin
      srcrect.left := 0;
      srcrect.top  := 0;
      srcrect.right  := Width;
      srcrect.bottom  := Height;

      if Width > cwidth then
	begin
	  desrect.left := ARect.left;
	  desrect.right := ARect.right;
	end
	else
	begin
	  desrect.left := ARect.left + (cwidth - Width) div 2;
	  desrect.right := ARect.right - (cwidth - Width) div 2;
	end;

      if Height > cheight then
	begin
	  desrect.top := ARect.top;
	  desrect.bottom := ARect.bottom;
	end
	else
	begin
	  desrect.top := ARect.top + (cheight - Height) div 2;
	  desrect.bottom := ARect.bottom - (cheight - Height) div 2;
	end;
      end;
 descanvas.draw(desrect.left,desrect.top,simage.picture.graphic);
end;

constructor TCGridReport.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FHeaderHeight := DEFAULTHEIGHT;
  FFooterHeight := DEFAULTHEIGHT;
  FHeaderFont := TFont.Create;
  FFooterFont := TFont.Create;
  FOriginalPrint := QRPrinter.OnGenerateToPrinter;
  QRPrinter.OnGenerateToPrinter := Print;
end;

destructor TCGridReport.destroy;
begin
  FHeaderFont.Free;
  FFooterFont.Free;
  QRPrinter.OnGenerateToPrinter := FOriginalPrint;
  inherited Destroy;
end;

function TCGridReport.GetCell(ACol,ARow : Longint) : String;
var 
  data : string;
begin
  if(Assigned(FOnPrintXCell)) then
    FOnPrintXCell(Self,ACol,ARow,data)
  else
    data := FDBCrossGrid.GetXCell(ACol,ARow);
  Result := data;
end;

procedure TCGridReport.SetDBCrossGrid(Const Value : TDBCrossGrid);
begin
  FDBCrossGrid := Value;
end;

procedure TCGridReport.SetHeaderFont(Const Value : TFont);
begin
  FHeaderFont.Assign(Value);
end;

procedure TCGridReport.SetHeaderHeight(Const Value : Integer);
begin
  if(Value < DEFAULTHEIGHT) then
    begin
      messagedlg('Minimum HeaderHeight should be larger then ' + 
        inttostr(DEFAULTHEIGHT), mtinformation,[mbOK],0);
      exit;
    end;
  FHeaderHeight := Value;
end;

procedure TCGridReport.SetFooterFont(Const Value : TFont);
begin
  FFooterFont.Assign(Value);
end;

procedure TCGridReport.SetFooterHeight(Const Value : Integer);
begin
  if(Value < DEFAULTHEIGHT) then
    begin
      messagedlg('Minimum FooterHeight should be larger then ' + 
        inttostr(DEFAULTHEIGHT), mtinformation,[mbOK],0);
      exit;
    end;
  FFooterHeight := Value;
end;

{$IFDEF DELPHI2}
procedure TCGridReport.Preset;
{$ELSE}
procedure TCGridReport.Print;
{$ENDIF}
var
   x,y,x1: integer;
   idx,idy,idw,idz : Longint;
   data : string;
   rowcnt , colcnt : Longint;
   colarray : TDoubles;
   rowarray : TDoubles;
   tablew : integer;
   tableh : integer;
   tablex : integer;
   tabley : integer;
   workf: double;
   worki,workj : integer;
   startrow,endrow,startcol,endcol : integer;
   firstpage : Boolean;
   headerx, headery : integer;
   footerx, footery : integer;
   pwidth, pheight : integer;
   ccols,crows : integer;
   tlen : integer;
   LeftMH, RightMH : integer;
   LeftMF, RightMF : integer;
   drect : TRect;
begin
  if (FDBCrossGrid = nil) then
    begin
      messagedlg('DBCrossGrid property is empty',mtinformation,[mbOK],0);
      exit;
    end;
{$IFDEF DELPHI2}
  Fpratiox := 1;
  Fpratioy := 1;
{$ELSE}
  Fpratiox := GetDeviceCaps(Printer.Handle,LOGPIXELSX) / Screen.pixelsperinch;
  Fpratioy := GetDeviceCaps(Printer.Handle,LOGPIXELSY) / Screen.pixelsperinch;
{$ENDIF}
  firstpage := True;
  colarray := TDoubles.Create;
  rowarray := TDoubles.Create;
  x := 0;
  y := 0;
{$IFDEF DELPHI2}
  QRPrinter.Cleanup;
  QRPrinter.BeginDoc;
{$IFDEF DELPHI3}
  pwidth := Trunc(QRPrinter.PaperWidth * QRPrinter.XFactor);
  pheight := Trunc(QRPrinter.PaperLength * QRPrinter.YFactor);
  QRPrinter.PaperWidth := QRPrinter.PaperWidth * 2;
  QRPrinter.PaperLength := QRPrinter.PaperLength * 2;
{$ELSE}
  pwidth := Trunc(QRPrinter.PageWidth / Fpratiox);
  pheight := Trunc(QRPrinter.PageHeight / Fpratioy);
{$ENDIF}
{$ENDIF}

{$IFDEF DELPHI1}
  Printer.BeginDoc;
  pwidth := Trunc(Printer.PageWidth /Fpratiox);
  pheight := Trunc(Printer.PageHeight / Fpratioy);
{$ENDIF}
  rowcnt := FDBCrossGrid.GetRowCount;
  colcnt := FDBCrossGrid.GetColCount;
  ccols := FDBCrossGrid.GetNumCrossCols;
  crows := FDBCrossGrid.GetNumCrossRows;
{
// calculate table width and tableheigth
}
  tablex := LeftMargin;
  tabley := TopMargin + HeaderHeight;
  tablew := pwidth - tablex - RightMargin;
  tableh := pheight - tabley - FooterHeight - BottomMargin;
{
// calculate headerx and headery
}
{$IFDEF DELPHI2}
  QRPrinter.NewPage;
  QRPrinter.canvas.Font := HeaderFont;
  worki := Trunc(QRPrinter.Canvas.TextWidth(HeaderText) / Fpratiox);
  workj := Trunc(QRPrinter.Canvas.TextHeight(HeaderText) / Fpratioy);
{$ELSE}
  Printer.NewPage;
  Printer.canvas.Font := HeaderFont;
  worki := Trunc(Printer.Canvas.TextWidth(HeaderText) / Fpratiox);
  workj := Trunc(Printer.Canvas.TextHeight(HeaderText) / Fpratioy);
{$ENDIF}
  if(workj > FHeaderHeight) then
    headery := TopMargin
  else
    headery := TopMargin + Trunc((FHeaderHeight - workj) / 2);
  if FHeaderLogoPos = lpBeforeText then
    begin
      LeftMH := LeftMargin + FHeaderLogoWidth;
      RightMH := RightMargin;
    end
  else
    begin
      LeftMH := LeftMargin;
      RightMH := RightMargin + FHeaderLogoWidth;
    end;
  case HeaderAlign of
    taLeftJustify:
      headerx := LeftMH;
    taRightJustify:
      headerx := tablew - RightMH - worki;
    taCenter:
      headerx := LeftMH + Trunc((tablew - LeftMH - RightMH)/2) - Trunc(worki/2);
  end;
  if(headerx < LeftMH) then
    headerx := LeftMH;
{
// calculate footerx and footery
}
{$IFDEF DELPHI2}
  QRPrinter.canvas.Font := FFooterFont;
  worki := Trunc(QRPrinter.Canvas.TextWidth(FFooterText) / Fpratiox);
  workj := Trunc(QRPrinter.Canvas.TextHeight(FFooterText) / Fpratioy);
{$ELSE}
  Printer.canvas.Font := FFooterFont;
  worki := Trunc(Printer.Canvas.TextWidth(FFooterText) / Fpratiox);
  workj := Trunc(Printer.Canvas.TextHeight(FFooterText) / Fpratioy);
{$ENDIF}
  if(workj > FFooterHeight) then
    footery := pheight - BottomMargin - FFooterHeight
  else
    footery := pheight - BottomMargin - FFooterHeight + 
    	Trunc((FFooterHeight - workj) / 2);
  if FFooterLogoPos = lpBeforeText then
    begin
      LeftMF := LeftMargin + FFooterLogoWidth;
      RightMF := RightMargin;
    end
  else
    begin
      LeftMF := LeftMargin;
      RightMF := RightMargin + FFooterLogoWidth + PAGEBUFSZ;
    end;
  case FooterAlign of
    taLeftJustify:
      footerx := LeftMF;
    taRightJustify:
      footerx := tablew - RightMF - 4 - worki;
    taCenter:
      footerx := LeftMF + Trunc((tablew - PAGEBUFSZ - FFooterLogoWidth - LeftMF)/2) 
      	- Trunc(worki/2);
  end;
  if(footerx < LeftMF) then
    footerx := LeftMF;
{
// calculte the colarray and rowarray
}
  worki := 0;
  for idx := 0 to colcnt - 1 do
    begin
      worki := worki + FDBCrossGrid.ColWidths[idx];
      if(worki > tablew) then
        begin
          workf := idx - 1;
          colarray.add(workf);
          worki := FDBCrossGrid.ColWidths[idx];
        end;
    end;
  workf := colcnt - 1;
  colarray.add(workf);
  worki := 0;
  for idy := 0 to rowcnt - 1 do
    begin
      worki := worki + FDBCrossGrid.RowHeights[idy];
      if(worki > tableh) then
        begin
          workf := idy - 1;
          rowarray.add(workf);
          worki := FDBCrossGrid.RowHeights[idy];
        end;
    end;
  workf := rowcnt - 1;
  rowarray.add(workf);
  for idw := 0 to rowarray.count - 1 do
    begin
      if idw = 0 then
        startrow := 0
      else
        startrow := trunc(rowarray.Get(idw-1) + 1) ;
      endrow := trunc(rowarray.Get(idw));
{
** start print all pages
}
      for idz := 0 to colarray.count - 1 do
        begin
          if(idz = 0) then
            startcol := 0
          else
            startcol := trunc(colarray.Get(idz-1) + 1);
          endcol := trunc(colarray.Get(idz));
          y := tabley;
	  if(not firstpage) then
{$IFDEF DELPHI2}
            QRPrinter.NewPage
{$ELSE}
            Printer.NewPage
{$ENDIF}
          else
            firstpage := False;

{
** print the line
}
          DrawOutline(tablex,tabley,tablew,tableh,
	  	startrow,endrow,startcol,endcol);
{
** printer the header and footer
}
{
  	  QRPrinter.Canvas.Pen.Color := HeaderColor;
}
{$IFDEF DELPHI2}
  	  QRPrinter.Canvas.Font := HeaderFont;
          QRPrinter.Canvas.TextOut(
	  	Trunc(headerx * Fpratiox),
		Trunc(headery * Fpratioy),
	  	HeaderText);
{$ELSE}
  	  Printer.Canvas.Font := HeaderFont;
          Printer.Canvas.TextOut(
	  	Trunc(headerx * Fpratiox),
		Trunc(headery * Fpratioy),
	  	HeaderText);
{$ENDIF}
{ ** print Header Logo ** }
          if(FHeaderLogo <> nil) then
	    begin
	      drect.Top := TopMargin;
	      drect.Bottom := TopMargin + FHeaderHeight;
	      if FHeaderLogoPos = lpBeforeText then
	        begin
	          drect.Left := LeftMargin;
	          drect.Right := LeftMargin + FHeaderLogoWidth;
		end
	      else
	        begin
                  drect.Right := pwidth - RightMargin;
	          drect.Left := drect.Right - FHeaderLogoWidth;
		end;
               drect.Top := Trunc(drect.Top * Fpratioy);
               drect.Bottom := Trunc(drect.Bottom * Fpratioy);
               drect.Left := Trunc(drect.Left * Fpratiox);
               drect.Right := Trunc(drect.Right * Fpratiox);
{$IFDEF DELPHI2}
	      DrawPicture(QRPrinter.Canvas,FHeaderLogo,drect);
{$ELSE}
	      DrawPicture(Printer.Canvas,FHeaderLogo,drect);
{$ENDIF}
	    end;
{
  	  QRPrinter.Canvas.Pen.Color := FooterColor;
}
{$IFDEF DELPHI2}
  	  QRPrinter.Canvas.Font := FooterFont;
          QRPrinter.Canvas.TextOut(
	  	Trunc(footerx * Fpratiox),
		Trunc(footery * Fpratioy),
	  	FooterText);
          QRPrinter.Canvas.TextOut(
	  	Trunc((pwidth - RightMargin - PAGEBUFSZ) *  Fpratiox),
		Trunc(footery * Fpratioy),
		'Page:' + inttostr(idw+1) + '-' + inttostr(idz+1) );
{$ELSE}
  	  Printer.Canvas.Font := FooterFont;
          Printer.Canvas.TextOut(
	  	Trunc(footerx * Fpratiox),
		Trunc(footery * Fpratioy),
	  	FooterText);
          Printer.Canvas.TextOut(
	  	Trunc((pwidth - RightMargin - PAGEBUFSZ) *  Fpratiox),
		Trunc(footery * Fpratioy),
		'Page:' + inttostr(idw+1) + '-' + inttostr(idz+1) );
{$ENDIF}
{ ** print Footer Logo ** }
          if(FFooterLogo <> nil) then
	    begin
              drect.Top := pheight - BottomMargin - FFooterHeight;
	      drect.Bottom := drect.Top + FFooterHeight;
	      if FFooterLogoPos = lpBeforeText then
	        begin
	          drect.Left := LeftMargin;
	          drect.Right := LeftMargin + FFooterLogoWidth;
		end
	      else
	        begin
	          drect.Left := pwidth - RightMF;
                  drect.Right := drect.left + FFooterLogoWidth;
		end;
               drect.Top := Trunc(drect.Top * Fpratioy);
               drect.Bottom := Trunc(drect.Bottom * Fpratioy);
               drect.Left := Trunc(drect.Left * Fpratiox);
               drect.Right := Trunc(drect.Right * Fpratiox);
{$IFDEF DELPHI2}
	      DrawPicture(QRPrinter.Canvas,FFooterLogo,drect);
{$ELSE}
	      DrawPicture(Printer.Canvas,FFooterLogo,drect);
{$ENDIF}
	    end;
{
** print the cell data
}
{$IFDEF DELPHI2}
	  QRPrinter.Canvas.Font := FDBCrossGrid.Font;
{$ELSE}
	  Printer.Canvas.Font := FDBCrossGrid.Font;
{$ENDIF}
{
	  QRPrinter.Canvas.Pen.Color := FDBCrossGrid.Color;
}
          for idx := startrow to endrow do
            begin
              x := tablex;
              for idy := startcol to endcol do
                begin
		  if(Assigned(FOnPrintXCell)) then
		    FOnPrintXCell(Self,idy,idx,data)
		  else
                    data := FDBCrossGrid.GetVXCell(idy,idx);
{$IFDEF DELPHI2}
		  tlen := Trunc((QRPrinter.Canvas.TextWidth(data) + 2 * XCELLMARGIN)/ Fpratiox);
{$ELSE}
		  tlen := Trunc((Printer.Canvas.TextWidth(data) + 2 * XCELLMARGIN)/ Fpratiox);
{$ENDIF}
                  if(((idx < crows) or (idy < ccols)) and
		     ((idx >= crows) or (idy >= ccols))) then
		    begin { alien center }
		      x1 := x + trunc(FDBCrossGrid.ColWidths[idy] / 2) - 
		                trunc(tlen / 2) + XCELLMARGIN;
		    end
		  else
		    begin { alieng right }
		      x1 := x + (FDBCrossGrid.ColWidths[idy] - tlen);
		    end ;
		  if(x1 < x) then
		    x1 := x;
{$IFDEF DELPHI2}
                  QRPrinter.Canvas.TextOut(
		  	Trunc(x1 * Fpratiox),
			Trunc((y + YCELLMARGIN) * Fpratioy),
			data);
{$ELSE}
                  Printer.Canvas.TextOut(
		  	Trunc(x1 * Fpratiox),
			Trunc((y  + YCELLMARGIN)* Fpratioy),
			data);
{$ENDIF}
                  x := x + FDBCrossGrid.ColWidths[idy];
                end;
              y := y + FDBCrossGrid.RowHeights[idx];
            end;
        end;
    end;
{$IFDEF DELPHI2}
  QRPrinter.Enddoc;
{$ELSE}
  Printer.Enddoc;
{$ENDIF}
  colarray.free;
  rowarray.free;
end;

{$IFDEF DELPHI2}
{$IFDEF DELPHI3}
procedure TCGridReport.Print;
var
  I : integer;
begin
  Printer.BeginDoc;
  for I := 1 to QRPrinter.PageCount do
    begin
      Application.ProcessMessages;
      Printer.Canvas.StretchDraw(Rect(0, 0, Printer.PageWidth, Printer.PageHeight),
        QRPrinter.GetPage(I));
      Printer.NewPage;
    end;
  Printer.EndDoc;
end;

{$ELSE}
procedure TCGridReport.Print;
begin
  QRPrinter.Print;
end;
{$ENDIF}

procedure TCGridReport.Preview;
begin
  QRPrinter.Preview;
end;
{$ENDIF}

procedure TCGridReport.CreateHTML(filename : String);
var
  ff : TextFile ;
  nccol, ncrow : integer;
  ss,sval : string;
  ii,jj,kk : integer;
  ident : integer;
  rowcnt,colcnt : Longint;
  cnt,cnt1 : Integer;
  arrayp,arrayi,arrayj : PLongint;
  skip : Boolean;
begin
  if (FDBCrossGrid = nil) then
    begin
      messagedlg('DBCrossGrid property is empty',mtinformation,[mbOK],0);
      exit;
    end;
  rowcnt := FDBCrossGrid.GetRowCount;
  colcnt := FDBCrossGrid.GetColCount;
  With FDBCrossGrid do
    begin
      ncrow := FixedRows;
      nccol := GetNumCrossCols;
    end;
  AssignFile(ff,filename);
  Rewrite(ff);
  writeln(ff,'<html>');
  writeln(ff,'<body>');
  writeln(ff,'<table border=1>');
  ss := '<caption><h1 align=center>' + HeaderText + '</h1></caption>';
  writeln(ff,ss);
{
** output the fixed rows
}
  arrayp := AllocMem(colcnt*(sizeof(Longint)));
  if(arrayp = nil) then
    begin
      messagedlg('Not enough memory for draw fixed rows',mtError,[mbAbort],0);
      exit;
    end;
  for ii := 0 to ncrow - 1 do
    begin
      writeln(ff,'<tr>');
      FDBCrossGrid.GetFixedRowDataes(ii,Pointer(arrayp),cnt);
      arrayi := arrayp;
      jj := 0;
      cnt1 := 0;
      while (jj < colcnt) do
        begin
       	  if(Assigned(FOnPrintXCell)) then
	    FOnPrintXCell(Self,jj,ii,ss)
	  else
            sval := FDBCrossGrid.GetXCell(jj,ii);
	  if((jj < nccol) or (cnt1 >= cnt)) then
            begin
	      ss := '<th>';
              jj := jj + 1;
            end
	  else
	    begin
	      ident := arrayi^ - jj + 1;
	      Inc(arrayi);
              Inc(cnt1);
              jj := jj + ident;
	      ss := '<th colspan=' + inttostr(ident) + '>';
	    end;
	  writeln(ff,ss);
	  writeln(ff,sval);
	  writeln(ff,'</th>');
	end;
      writeln(ff,'</tr>');
    end;
  FreeMem(arrayp,colcnt*(sizeof(Longint)));
  arrayp := nil;
{
** output the fixed cols and cell data
}
  arrayp := AllocMem(rowcnt*(sizeof(Longint)));
  if(arrayp = nil) then
    begin
      messagedlg('Not enough memory for draw fixed cols',mtError,[mbAbort],0);
      exit;
    end;
  for jj := ncrow to rowcnt - 1 do
    begin
      writeln(ff,'<tr>');
      for ii := 0 to colcnt - 1 do
        begin
	  sval := GetCell(ii,jj);
          if(ii < nccol) then
	    begin
	      FDBCrossGrid.GetFixedColDataes(ii,Pointer(arrayp),cnt,2);
	      arrayi := arrayp;
	      {
	      ** for Fixed Columns, default Skip
	      }
	      skip := True;
	      ident := 1;
	      for kk := 0 to cnt - 1 do
	        begin
		  if(arrayi^ >= jj) then
		    begin
		      if(arrayi^ = jj) then
		        begin
			  if kk = (cnt - 1) then
			    ident := rowcnt - jj
			  else
                            begin
                              arrayj := arrayi;
                              Inc(arrayj);
			      ident := arrayj^ - arrayi^;
                            end;
			  skip := False;
			end
		      else
			skip := True;
		      break;
		    end;
                  Inc(arrayi);
		end;

	      if(skip) then
	        continue;
              ss := '<th rowspan=' + inttostr(ident) + '>';
	    end
	  else
	    begin
              ss := '<td>';
	    end;
	  writeln(ff,ss);
	  writeln(ff,sval);
          if(ii < nccol) then
            writeln(ff,'</th>')
	  else
            writeln(ff,'</td>');
        end;
      writeln(ff,'</tr>');
    end;
  FreeMem(arrayp,rowcnt*(sizeof(Longint)));
  arrayp := nil;
  writeln(ff,'</table>');
  writeln(ff,'</body>');
  writeln(ff,'</html>');
  Closefile(ff);
end;

procedure TCGridReport.CreateASCII(filename : String; sep : String);
var
  ff : TextFile ;
  irow, icol : Longint;
  arow, acol : Longint;
  srow, scol : Longint;
  ii, jj : Longint;
  ncrow : Longint;
  rowcnt, colcnt : Longint;
  ss : string;
begin
  if (FDBCrossGrid = nil) then
    begin
      messagedlg('DBCrossGrid property is empty',mtinformation,[mbOK],0);
      exit;
    end;
  With FDBCrossGrid do
    begin
      srow := FixedRows;
      ncrow := GetNumCrossRows;
      scol := GetNumCrossCols;
      rowcnt := GetRowCount;
      colcnt := GetColCount;
    end;
  AssignFile(ff,filename);
  Rewrite(ff);
  for irow := srow to rowcnt - 1 do
    for icol := scol to colcnt - 1 do
      begin
        ss := '';
	for ii := 0 to scol - 1 do
	  ss := ss + GetCell(ii,irow) + sep;
	for ii := 0 to ncrow - 1 do
	  ss := ss + GetCell(icol,ii) + sep;
        ss := ss + GetCell(icol,irow);
        writeln(ff,ss);
      end;
  Closefile(ff);
end;

end.
