unit CSFPMain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, CSFrmPnl, CSNoteBk,
  CSFPPat, CSFPHist, CSFPProc, CSFPCode, CSFPComp;

type
  TMainForm = class(TForm)
    csNotebook1: TcsNotebook;
    csFormPanel1: TcsFormPanel;
    csFormPanel2: TcsFormPanel;
    csFormPanel3: TcsFormPanel;
    csFormPanel4: TcsFormPanel;
    csFormPanel5: TcsFormPanel;
    procedure csNotebook1PageChanged(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure csNotebook1PageChanging(Sender: TObject; NewIndex: Integer;
      var AllowChange: Boolean);
  private
    { Private declarations }
    FPrevPage: Integer;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.csNotebook1PageChanged(Sender: TObject);
var Form: TForm;
    FPanel: TcsFormPanel;
begin
  { Create form for current page }
  with TcsPage(csNotebook1.Pages.Objects[csNotebook1.PageIndex]) do
    if (ControlCount > 0) and (Controls[0] is TcsFormPanel) then
      FPanel := TcsFormPanel(Controls[0])
    else
      FPanel := nil;

  if (FPanel <> nil) and (FPanel.Form = nil) then
  begin
    case csNotebook1.PageIndex of
      0:  Form := TPatForm.Create(Self);
      1:  Form := THistForm.Create(Self);
      2:  Form := TProcForm.Create(Self);
      3:  Form := TCodeForm.Create(Self);
      4:  Form := TCompForm.Create(Self);
    else
      Form := nil;
    end;
    if Form <> nil then
      FPanel.Form := Form;
  end;

  { Release form for previous page }
  if FPrevPage >= 0 then
  begin
    with TcsPage(csNotebook1.Pages.Objects[FPrevPage]) do
      if (ControlCount > 0) and (Controls[0] is TcsFormPanel) then
        FPanel := TcsFormPanel(Controls[0])
      else
        FPanel := nil;
    if (FPanel <> nil) and (FPanel.Form <> nil) then
    begin
      { destroy the form and release it's memory }
      FPanel.Form.Close;
      FPanel.Form.Release;
      FPanel.Form := nil; { necessary to force re-create when reselected }
    end;
  end;
  FPrevPage := csNotebook1.PageIndex;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  FPrevPage := -1;
  csNotebook1PageChanged(Sender);
end;

{ This code is not essential but is needed if you want to prevent
  changes to another page when the form's CloseQuery function
  returns False.
}
procedure TMainForm.csNotebook1PageChanging(Sender: TObject;
  NewIndex: Integer; var AllowChange: Boolean);
var FPanel: TcsFormPanel;
begin
  { Check that current page's form can be closed before allowing change }
  with TcsPage(csNotebook1.Pages.Objects[csNotebook1.PageIndex]) do
    if (ControlCount > 0) and (Controls[0] is TcsFormPanel) then
      FPanel := TcsFormPanel(Controls[0])
    else
      FPanel := nil;
  if (FPanel <> nil) and (FPanel.Form <> nil) then
    AllowChange := FPanel.Form.CloseQuery;
end;

end.
