{********************************************************************}
{ TCABFile component                                                 }
{ for Delphi 2.0, 3.0, 4.0, 5.0,6.0 & C++Builder 1.0, 3.0, 4.0, 5.0  }
{ version 1.3                                                        }
{                                                                    }
{ written by TMS Software                                            }
{            copyright  1999-2001                                   }
{            Email : info@tmssoftware.com                            }
{            Web : http://www.tmssoftware.com                        }
{********************************************************************}

unit cabr;

interface

uses
  CabFiles,Classes,
{$IFDEF VER140}
  DesignIntf, DesignEditors
{$ELSE}
  DsgnIntf
{$ENDIF}
  ;

type 
 {---------------------------------------------------}
 { Section property editor class : not used yet      }
 {---------------------------------------------------}
  TCABFileEditor = class(TDefaultEditor)
                      protected
                        {$IFNDEF VER140}
                        procedure EditProperty(PropertyEditor: TPropertyEditor;
                                               var Continue, FreeEditor: Boolean); override;
                        {$ELSE}
                        procedure EditProperty(const PropertyEditor: IProperty; var Continue: Boolean); override;
                        {$ENDIF}
                      public
                        function GetVerb(index:integer):string; override;
                        function GetVerbCount:integer; override;
                        procedure ExecuteVerb(Index:integer); override;
                      end;



procedure Register;

implementation

uses
  SysUtils, Dialogs;

procedure Register;
begin
  RegisterComponents('TMS', [TCABFile]);
  RegisterComponentEditor(TCABFile, TCABFileEditor);  
end;

procedure TCABFileEditor.ExecuteVerb(Index: integer);
begin
  case Index of
  0: Edit;
  end;
end;

{$IFDEF VER140}
procedure TCABFileEditor.EditProperty(const PropertyEditor: IProperty; var Continue: Boolean);
{$ELSE}
procedure TCABFileEditor.EditProperty(PropertyEditor: TPropertyEditor;
  var Continue, FreeEditor: Boolean);
{$ENDIF}
var
  PropName: string;
begin

  PropName := PropertyEditor.GetName;

   
  if (CompareText(PropName, 'CABFILECONTENTS') = 0) then
    begin
      PropertyEditor.Edit;
      Continue := False;
    end;
end;


function TCABFileEditor.GetVerb(Index: Integer): string;
begin
  Result := '';
  case Index of
  0:Result := 'Items';
  end;
end;

function TCABFileEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;




end.

