// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'cabfiles.pas' rev: 4.00

#ifndef cabfilesHPP
#define cabfilesHPP

#pragma delphiheader begin
#pragma option push -w-
#include <SysUtils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Cabfiles
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS ECABFileError;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION ECABFileError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall ECABFileError(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall ECABFileError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall ECABFileError(int Ident, Extended Dummy) : Sysutils::Exception(
		Ident, Dummy) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall ECABFileError(int Ident, const System::TVarRec * Args
		, const int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall ECABFileError(const AnsiString Msg, int AHelpContext) : 
		Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall ECABFileError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall ECABFileError(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall ECABFileError(int Ident, const System::TVarRec * 
		Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~ECABFileError(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

struct terf;
typedef terf *perf;

#pragma pack(push, 4)
struct terf
{
	int erfOper;
	int erfType;
	BOOL fError;
} ;
#pragma pack(pop)

struct TFDICABINETINFO;
typedef TFDICABINETINFO *PFDICABINETINFO;

#pragma pack(push, 4)
struct TFDICABINETINFO
{
	int cbCabinet;
	short cFolders;
	short cFiles;
	short setID;
	short iCabinet;
	int fReserve;
	int hasprev;
	int hasnext;
} ;
#pragma pack(pop)

struct TFDINOTIFICATION;
typedef TFDINOTIFICATION *PFDINOTIFICATION;

#pragma pack(push, 4)
struct TFDINOTIFICATION
{
	int cb;
	char *psz1;
	char *psz2;
	char *psz3;
	void *pv;
	int hf;
	short date;
	short time;
	short attribs;
	short setID;
	short iCabinet;
	short iFolder;
	int FDIERROR;
} ;
#pragma pack(pop)

struct TCCAB;
typedef TCCAB *PCCAB;

#pragma pack(push, 4)
struct TCCAB
{
	int cb;
	int cbFolderThresh;
	int cbReserveCFHeader;
	int cbReserveCFFolder;
	int cbReserveCFData;
	int iCab;
	int iDisk;
	BOOL fFailOnIncompressible;
	short setID;
	char szDisk[256];
	char szCab[256];
	char szCabPath[256];
} ;
#pragma pack(pop)

#pragma option push -b-
enum TProcessMode { pmContents, pmExtractAll, pmExtractFile, pmExtractSelected };
#pragma option pop

class DELPHICLASS TCABFileEntry;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TCABFileEntry : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	AnsiString fName;
	int fSize;
	System::TDateTime fDate;
	bool fSelected;
	AnsiString fRelPath;
	
public:
	__fastcall virtual TCABFileEntry(Classes::TCollection* Collection);
	__fastcall virtual ~TCABFileEntry(void);
	__property int Size = {read=fSize, write=fSize, nodefault};
	__property System::TDateTime Date = {read=fDate, write=fDate};
	__property bool Selected = {read=fSelected, write=fSelected, nodefault};
	
__published:
	__property AnsiString Name = {read=fName, write=fName};
	__property AnsiString RelPath = {read=fRelPath, write=fRelPath};
};

#pragma pack(pop)

class DELPHICLASS TCABFileContents;
class DELPHICLASS TCABFile;
#pragma option push -b-
enum TCompressionType { typNone, typMSZIP, typLZX };
#pragma option pop

#pragma option push -b-
enum TLZXMemory { lzxLowest, lzxLower, lzxLow, lzxMedium, lzxHigh, lzxHigher, lzxHighest };
#pragma option pop

typedef void __fastcall (__closure *TCompressProgress)(System::TObject* Sender, int pos, int tot);

typedef void __fastcall (__closure *TDeCompressProgress)(System::TObject* Sender, AnsiString FileName
	, int pos, int tot);

typedef void __fastcall (__closure *TOverWriteFile)(System::TObject* Sender, AnsiString FileName, bool 
	&Allow);

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TCABFile : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TCABFileContents* FCABFileContents;
	AnsiString FCABFile;
	AnsiString FExtractFile;
	AnsiString FTargetPath;
	int FTotSizeFiles;
	int FTotSizeCompress;
	int FTotSizeProgress;
	int FTotFileSizeDecompress;
	int FCurFileSizeDecompress;
	AnsiString FCurFileNameDecompress;
	TProcessMode FProcessMode;
	TCompressionType FCompressionType;
	TLZXMemory FLZXMemory;
	TCompressProgress FOnCompressProgress;
	TDeCompressProgress FOnDeCompressProgress;
	TOverWriteFile FOnOverWriteFile;
	double __fastcall GetCompressionRatio(void);
	int __fastcall DecompressCABFile(void);
	int __fastcall CompressCABFile(void);
	void __fastcall Error(int err, int errt);
	
protected:
	void __fastcall CompressProgress(int pos, int tot);
	
public:
	__fastcall virtual TCABFile(Classes::TComponent* AOwner);
	__fastcall virtual ~TCABFile(void);
	void __fastcall GetContents(void);
	bool __fastcall ExtractAll(void);
	bool __fastcall ExtractSelected(void);
	bool __fastcall ExtractFile(const AnsiString FName);
	bool __fastcall Compress(void);
	bool __fastcall MakeSFX(void);
	__property double CompressionRatio = {read=GetCompressionRatio};
	__property int CompressedSize = {read=FTotSizeCompress, nodefault};
	__property int OriginalSize = {read=FTotSizeFiles, nodefault};
	
__published:
	__property TCABFileContents* CABFileContents = {read=FCABFileContents, write=FCABFileContents};
	__property AnsiString CABFile = {read=FCABFile, write=FCABFile};
	__property TCompressionType CompressionType = {read=FCompressionType, write=FCompressionType, nodefault
		};
	__property TLZXMemory LZXMemory = {read=FLZXMemory, write=FLZXMemory, nodefault};
	__property AnsiString TargetPath = {read=FTargetPath, write=FTargetPath};
	__property TCompressProgress OnCompressProgress = {read=FOnCompressProgress, write=FOnCompressProgress
		};
	__property TDeCompressProgress OnDecompressProgress = {read=FOnDeCompressProgress, write=FOnDeCompressProgress
		};
	__property TOverWriteFile OnOverWriteFile = {read=FOnOverWriteFile, write=FOnOverWriteFile};
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TCABFileContents : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	TCABFile* FOwner;
	HIDESBASE TCABFileEntry* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TCABFileEntry* Value);
	
public:
	__fastcall TCABFileContents(TCABFile* AOwner);
	HIDESBASE TCABFileEntry* __fastcall Add(void);
	HIDESBASE TCABFileEntry* __fastcall Insert(int index);
	__property TCABFileEntry* Items[int Index] = {read=GetItem, write=SetItem};
	bool __fastcall IsInList(AnsiString s);
	bool __fastcall IsSelected(AnsiString s);
	void __fastcall SelectAll(void);
	void __fastcall SelectNone(void);
	
protected:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TCABFileContents(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
#define cabdll "cabinet.dll"
static const Shortint FDIERROR_NONE = 0x0;
static const Shortint FDIERROR_CABINET_NOT_FOUND = 0x1;
static const Shortint FDIERROR_NOT_A_CABINET = 0x2;
static const Shortint FDIERROR_UNKNOWN_CABINET_VERSION = 0x3;
static const Shortint FDIERROR_CORRUPT_CABINET = 0x4;
static const Shortint FDIERROR_ALLOC_FAIL = 0x5;
static const Shortint FDIERROR_BAD_COMPR_TYPE = 0x6;
static const Shortint FDIERROR_MDI_FAIL = 0x7;
static const Shortint FDIERROR_TARGET_FILE = 0x8;
static const Shortint FDIERROR_RESERVE_MISMATCH = 0x9;
static const Shortint FDIERROR_WRONG_CABINET = 0xa;
static const Shortint FDIERROR_USER_ABORT = 0xb;
static const Shortint FCIERR_NONE = 0x0;
static const Shortint FCIERR_OPEN_SRC = 0x1;
static const Shortint FCIERR_READ_SRC = 0x2;
static const Shortint FCIERR_ALLOC_FAIL = 0x3;
static const Shortint FCIERR_TEMP_FILE = 0x4;
static const Shortint FCIERR_BAD_COMPR_TYPE = 0x5;
static const Shortint FCIERR_CAB_FILE = 0x6;
static const Shortint FCIERR_USER_ABORT = 0x7;
static const Shortint FCIERR_MCI_FAIL = 0x8;
static const Shortint fdintCABINET_INFO = 0x0;
static const Shortint fdintPARTIAL_FILE = 0x1;
static const Shortint fdintCOPY_FILE = 0x2;
static const Shortint fdintCLOSE_FILE_INFO = 0x3;
static const Shortint fdintNEXT_CABINET = 0x4;
static const Shortint fdintENUMERATE = 0x5;
static const Word CB_MAX_CHUNK = 0x8000;
static const int CB_MAX_DISK = 0x7fffffff;
static const Word CB_MAX_FILENAME = 0x100;
static const Word CB_MAX_CABINET_NAME = 0x100;
static const Word CB_MAX_CAB_PATH = 0x100;
static const Word CB_MAX_DISK_NAME = 0x100;
static const int FOLDER_THRESHOLD = 0xdbba0;
static const Shortint statusFile = 0x0;
static const Shortint statusFolder = 0x1;
static const Shortint statusCabinet = 0x2;
static const Word O_CREAT = 0x100;
static const Word O_TRUNC = 0x200;
static const Word O_EXCL = 0x400;

}	/* namespace Cabfiles */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Cabfiles;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// cabfiles
