// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'cabfiles.pas' rev: 3.00

#ifndef cabfilesHPP
#define cabfilesHPP
#include <SysUtils.hpp>
#include <Classes.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Cabfiles
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS ECABFileError;
class PASCALIMPLEMENTATION ECABFileError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ __fastcall ECABFileError(const System::AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	/* Exception.CreateFmt */ __fastcall ECABFileError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	/* Exception.CreateRes */ __fastcall ECABFileError(int Ident, Extended Dummy) : Sysutils::Exception(
		Ident, Dummy) { }
	/* Exception.CreateResFmt */ __fastcall ECABFileError(int Ident, const System::TVarRec * Args, const 
		int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	/* Exception.CreateHelp */ __fastcall ECABFileError(const System::AnsiString Msg, int AHelpContext)
		 : Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ __fastcall ECABFileError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	/* Exception.CreateResHelp */ __fastcall ECABFileError(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ __fastcall ECABFileError(int Ident, const System::TVarRec * Args, 
		const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext)
		 { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~ECABFileError(void) { }
	
};

struct terf;
typedef terf *perf;

struct terf
{
	int erfOper;
	int erfType;
	BOOL fError;
} ;

struct TFDICABINETINFO;
typedef TFDICABINETINFO *PFDICABINETINFO;

struct TFDICABINETINFO
{
	int cbCabinet;
	short cFolders;
	short cFiles;
	short setID;
	short iCabinet;
	int fReserve;
	int hasprev;
	int hasnext;
} ;

struct TFDINOTIFICATION;
typedef TFDINOTIFICATION *PFDINOTIFICATION;

struct TFDINOTIFICATION
{
	int cb;
	char *psz1;
	char *psz2;
	char *psz3;
	void *pv;
	int hf;
	short date;
	short time;
	short attribs;
	short setID;
	short iCabinet;
	short iFolder;
	int FDIERROR;
} ;

struct TCCAB;
typedef TCCAB *PCCAB;

struct TCCAB
{
	int cb;
	int cbFolderThresh;
	int cbReserveCFHeader;
	int cbReserveCFFolder;
	int cbReserveCFData;
	int iCab;
	int iDisk;
	BOOL fFailOnIncompressible;
	short setID;
	char szDisk[256];
	char szCab[256];
	char szCabPath[256];
} ;

enum TProcessMode { pmContents, pmExtractAll, pmExtractFile, pmExtractSelected };

class DELPHICLASS TCABFileEntry;
class PASCALIMPLEMENTATION TCABFileEntry : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	System::AnsiString fName;
	int fSize;
	System::TDateTime fDate;
	bool fSelected;
	System::AnsiString fRelPath;
	
public:
	__fastcall virtual TCABFileEntry(Classes::TCollection* Collection);
	__fastcall virtual ~TCABFileEntry(void);
	__property int Size = {read=fSize, write=fSize, nodefault};
	__property System::TDateTime Date = {read=fDate, write=fDate};
	__property bool Selected = {read=fSelected, write=fSelected, nodefault};
	
__published:
	__property System::AnsiString Name = {read=fName, write=fName};
	__property System::AnsiString RelPath = {read=fRelPath, write=fRelPath};
};

class DELPHICLASS TCABFileContents;
class DELPHICLASS TCABFile;
enum TCompressionType { typNone, typMSZIP, typLZX };

enum TLZXMemory { lzxLowest, lzxLower, lzxLow, lzxMedium, lzxHigh, lzxHigher, lzxHighest };

typedef void __fastcall (__closure *TCompressProgress)(System::TObject* Sender, int pos, int tot);

typedef void __fastcall (__closure *TDeCompressProgress)(System::TObject* Sender, System::AnsiString 
	FileName, int pos, int tot);

typedef void __fastcall (__closure *TOverWriteFile)(System::TObject* Sender, System::AnsiString FileName
	, bool &Allow);

class PASCALIMPLEMENTATION TCABFile : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TCABFileContents* FCABFileContents;
	System::AnsiString FCABFile;
	System::AnsiString FExtractFile;
	System::AnsiString FTargetPath;
	int FTotSizeFiles;
	int FTotSizeCompress;
	int FTotSizeProgress;
	int FTotFileSizeDecompress;
	int FCurFileSizeDecompress;
	System::AnsiString FCurFileNameDecompress;
	TProcessMode FProcessMode;
	TCompressionType FCompressionType;
	TLZXMemory FLZXMemory;
	TCompressProgress FOnCompressProgress;
	TDeCompressProgress FOnDeCompressProgress;
	TOverWriteFile FOnOverWriteFile;
	double __fastcall GetCompressionRatio(void);
	int __fastcall DecompressCABFile(void);
	int __fastcall CompressCABFile(void);
	void __fastcall Error(int err, int errt);
	
protected:
	void __fastcall CompressProgress(int pos, int tot);
	
public:
	__fastcall virtual TCABFile(Classes::TComponent* AOwner);
	__fastcall virtual ~TCABFile(void);
	void __fastcall GetContents(void);
	bool __fastcall ExtractAll(void);
	bool __fastcall ExtractSelected(void);
	bool __fastcall ExtractFile(const System::AnsiString FName);
	bool __fastcall Compress(void);
	bool __fastcall MakeSFX(void);
	__property double CompressionRatio = {read=GetCompressionRatio};
	__property int CompressedSize = {read=FTotSizeCompress, nodefault};
	__property int OriginalSize = {read=FTotSizeFiles, nodefault};
	
__published:
	__property TCABFileContents* CABFileContents = {read=FCABFileContents, write=FCABFileContents};
	__property System::AnsiString CABFile = {read=FCABFile, write=FCABFile};
	__property TCompressionType CompressionType = {read=FCompressionType, write=FCompressionType, nodefault
		};
	__property TLZXMemory LZXMemory = {read=FLZXMemory, write=FLZXMemory, nodefault};
	__property System::AnsiString TargetPath = {read=FTargetPath, write=FTargetPath};
	__property TCompressProgress OnCompressProgress = {read=FOnCompressProgress, write=FOnCompressProgress
		};
	__property TDeCompressProgress OnDecompressProgress = {read=FOnDeCompressProgress, write=FOnDeCompressProgress
		};
	__property TOverWriteFile OnOverWriteFile = {read=FOnOverWriteFile, write=FOnOverWriteFile};
};

class PASCALIMPLEMENTATION TCABFileContents : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	TCABFile* FOwner;
	HIDESBASE TCABFileEntry* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TCABFileEntry* Value);
	
public:
	__fastcall TCABFileContents(TCABFile* AOwner);
	HIDESBASE TCABFileEntry* __fastcall Add(void);
	HIDESBASE TCABFileEntry* __fastcall Insert(int index);
	__property TCABFileEntry* Items[int Index] = {read=GetItem, write=SetItem};
	bool __fastcall IsInList(System::AnsiString s);
	bool __fastcall IsSelected(System::AnsiString s);
	void __fastcall SelectAll(void);
	void __fastcall SelectNone(void);
	
protected:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
public:
	/* TCollection.Destroy */ __fastcall virtual ~TCABFileContents(void) { }
	
};

//-- var, const, procedure ---------------------------------------------------
#define cabdll "cabinet.dll"
#define FDIERROR_NONE (Byte)(0)
#define FDIERROR_CABINET_NOT_FOUND (Byte)(1)
#define FDIERROR_NOT_A_CABINET (Byte)(2)
#define FDIERROR_UNKNOWN_CABINET_VERSION (Byte)(3)
#define FDIERROR_CORRUPT_CABINET (Byte)(4)
#define FDIERROR_ALLOC_FAIL (Byte)(5)
#define FDIERROR_BAD_COMPR_TYPE (Byte)(6)
#define FDIERROR_MDI_FAIL (Byte)(7)
#define FDIERROR_TARGET_FILE (Byte)(8)
#define FDIERROR_RESERVE_MISMATCH (Byte)(9)
#define FDIERROR_WRONG_CABINET (Byte)(10)
#define FDIERROR_USER_ABORT (Byte)(11)
#define FCIERR_NONE (Byte)(0)
#define FCIERR_OPEN_SRC (Byte)(1)
#define FCIERR_READ_SRC (Byte)(2)
#define FCIERR_ALLOC_FAIL (Byte)(3)
#define FCIERR_TEMP_FILE (Byte)(4)
#define FCIERR_BAD_COMPR_TYPE (Byte)(5)
#define FCIERR_CAB_FILE (Byte)(6)
#define FCIERR_USER_ABORT (Byte)(7)
#define FCIERR_MCI_FAIL (Byte)(8)
#define fdintCABINET_INFO (Byte)(0)
#define fdintPARTIAL_FILE (Byte)(1)
#define fdintCOPY_FILE (Byte)(2)
#define fdintCLOSE_FILE_INFO (Byte)(3)
#define fdintNEXT_CABINET (Byte)(4)
#define fdintENUMERATE (Byte)(5)
#define CB_MAX_CHUNK (int)(32768)
#define CB_MAX_DISK (int)(2147483647)
#define CB_MAX_FILENAME (Word)(256)
#define CB_MAX_CABINET_NAME (Word)(256)
#define CB_MAX_CAB_PATH (Word)(256)
#define CB_MAX_DISK_NAME (Word)(256)
#define FOLDER_THRESHOLD (int)(900000)
#define statusFile (Byte)(0)
#define statusFolder (Byte)(1)
#define statusCabinet (Byte)(2)
#define O_CREAT (Word)(256)
#define O_TRUNC (Word)(512)
#define O_EXCL (Word)(1024)

}	/* namespace Cabfiles */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Cabfiles;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// cabfiles
