unit BzBackground;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  BzAniBackground, BzConvGIF2Bmp;

type
  TBzBackground = class(TBzAniBackground)
  private
    { Private declarations }
    fFileName : String;
    function GetFileName : String;
    procedure SetFileName( FN : String );
  protected
    { Protected declarations }
  public
    { Public declarations }
  published
    { Published declarations }
    property FileName : String read GetFileName write SetFileName;
  end;

procedure Register;

implementation

{$R BzBackground.DCR}

procedure Register;
begin
  RegisterComponents('Custom', [TBzBackground]);
end;

function TBzBackground.GetFileName : String;
begin
   Result := '';
   if ImgIndex < 0 then Exit;
   Result := fFileName;
end;

procedure TBzBackground.SetFileName( FN : String );
var G : TBzConvGIF2Bmp;
begin
   if ImgCache = nil then Exit;
   if (ImgIndex >= 0) and (FN = fFileName) then Exit;
   if not FileExists( FN ) then Exit;
   if LowerCase( ExtractFileExt( FN ) ) = '.gif' then
   begin
      G := TBzConvGIF2Bmp.Create( Self );
      if boAnimate in Options then
      begin
         G.Animate := True;
         G.AutoDestruct := True;
         G.DecodeAll := False;
         G.Background := Self;
         G.FileName := FN;
      end
         else
      begin
         G.Only1stFrame := True;
         G.AutoDestruct := False;
         G.DecodeAll := True;
         G.Background := Self;
         try
            G.FileName := FN;
         finally
            G.Free;
         end;
         if ImgIndex < 0 then Exit;
      end;
   end
      else
   begin
      ImgIndex := ImgCache.GetImage( FN, True, nil );
      if ImgIndex < 0 then Exit;
      ImgCache.UnlockImg( ImgIndex );
   end;
   fFileName := FN;
end;

end.
