unit UDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Grids, DBGrids, BDBGrid, Db, DBTables, StdCtrls;

type
  TForm1 = class(TForm)
    DS: TDataSource;
    Query: TQuery;
    Grid: TBitDBGrid;
    Panel1: TPanel;
    TitleGroup: TRadioGroup;
    IncBox: TCheckBox;
    EnterGroup: TRadioGroup;
    Footers: TRadioGroup;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    ImageList: TImageList;
    procedure TitleGroupClick(Sender: TObject);
    procedure IncBoxClick(Sender: TObject);
    procedure EnterGroupClick(Sender: TObject);
    procedure GridDblClick(Sender: TObject);
    procedure FootersClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure GridDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure GridGetIconIndex(Sender: TObject; Column: TColumn;
      var Index: Integer);
    procedure GridShowEditor(Sender: TObject; Field: TField;
      var AllowShowEditor: Boolean);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses TypInfo;

procedure StringToEnum(Instance : TPersistent; PropName, PropValue : string);
var PropInfo : PPropInfo;
    I : integer;
    EnumType: PTypeInfo;
begin
  PropInfo := GetPropInfo(Instance.ClassInfo, PropName);
  EnumType := GetTypeData(PropInfo^.PropType^)^.BaseType^;
  I := GetEnumValue(EnumType, PropValue);
  SetOrdProp(Instance, PropInfo, I);
end;

procedure TForm1.TitleGroupClick(Sender: TObject);
begin
 StringToEnum(Grid, 'TitleBtn', TitleGroup.Items[TitleGroup.ItemIndex]);
end;

procedure TForm1.IncBoxClick(Sender: TObject);
begin
 Grid.AllowIncSearch := (Sender as TCheckBox).Checked;
end;

procedure TForm1.EnterGroupClick(Sender: TObject);
begin
 StringToEnum(Grid, 'EnterKey', EnterGroup.Items[EnterGroup.ItemIndex]);
end;

procedure TForm1.GridDblClick(Sender: TObject);
begin
 ShowMessage('Double click!');
end;

procedure TForm1.FootersClick(Sender: TObject);
begin
 StringToEnum(Grid, 'FooterType', Footers.Items[Footers.ItemIndex]);
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
 Grid.DrawingEllipse := (Sender as TCheckBox).Checked;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
 Grid.Fillfields := (Sender as TCheckBox).Checked;
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
 Grid.InternalDrag := (Sender as TCheckBox).Checked;
end;

procedure TForm1.GridDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
 Accept := True;
end;

procedure TForm1.GridGetIconIndex(Sender: TObject; Column: TColumn;
  var Index: Integer);
begin
 if Column.FieldName = 'ACCT_NBR' then
  if Query['OBJECTIVES']  = 'Growth'
    then Index := 0
    else if Query['OBJECTIVES']  = 'Income'
           then Index := 1
           else Index := 2
end;

procedure TForm1.GridShowEditor(Sender: TObject; Field: TField;
  var AllowShowEditor: Boolean);
begin
  AllowShowEditor := AllowShowEditor and (Field <> nil);
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
 if Key=#13 then begin Key:=#0; Close; end;
end;

end.
