{*******************************************************}
{                                                       }
{      TBitDBGrid  - Extended of standart TDBGrid       }
{    (Multiline columns titles, auto-resize columns,    }
{ inplace incremental search, title buttons and more :) }
{                                                       }
{      Copyright (c) 1997 by Ilya Andreev AKA Andre     }
{                                                       }
{                     SPb, Russia.                      }
{                                                       }
{                      Shareware.                       }
{                                                       }
{         e-mail: ilya_andreev@geocities.com            }
{       FIDONet: 2:5030/55.28 AKA 2:5030/402.17         }
{                                                       }
{           Please, send me bag reports :)              }
{                                                       }
{*******************************************************}

unit BDBGrid;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, Math, DB, StdCtrls, ClipBrd;

const
  WM_GridEnter = WM_USER + 105;

type
  TOnDrawTitleEvent = procedure(ACol : integer; ARect : TRect; var TitleText : string)
    of object;

  TOnScrollEvent = procedure(Sender : TObject; Code : Integer; Pos : smallint)
    of object;

  TOnPasteEvent = procedure(Sender : TObject;
    Field : TField; var FieldValue : string) of object;

  TIncSearchEvevt = procedure(Sender:TObject;Field:TField;
    const Text:string;var MoveCaretBack:Boolean) of object;

  TEnterKeyDown = (ekNone, ekDouble, ekTab);

  TTitleBtnStyle = (tbNone, tbFix, tbDownUp);

  TIncEdit = class;

  TBitDBGrid = class(TDBGrid)
  private
   FRealTitleFont : TFont;
   FOnDrawTitle : TOnDrawTitleEvent;
   FResizeFlag : boolean;
   FUpdateLock: Byte;
   FOnHScroll : TOnScrollEvent;
   FOnResizeCol : TNotifyEvent;
   FOnTitleMouseDown : TMouseEvent;
   FTitleBtn : TTitleBtnStyle;
   FMinWidth : Variant;
   FFillFields : boolean;
   FIncEdit : TIncEdit;
   FAllowIncSearch : Boolean;
   FOnIncSearch : TIncSearchEvevt;
   FMultiCaption : boolean;
   FMC : boolean;
   FIntDrag : boolean;
   FLongCaption : boolean;
   FDoFocus : boolean;
   FEnterKey : TEnterKeyDown;
   FStartBookMark : TBookmark;
   FOnPasteEvent : TOnPasteEvent;
   function IncSearch(C:Char;CheckEdit:Boolean):Boolean;
   function FindRecord(const Text:string):Boolean;
   function IsValidChar(C:Char):Boolean;
   procedure PlaseIncEdit;
   function GetIncSearchText:string;
   procedure SetIncSearchText(const Text:string);
   procedure WMChar(var Message:TWMChar); message WM_CHAR;
   procedure CMDialogChar(var Message:TCMDialogChar); message CM_DIALOGCHAR;
   procedure WMSize(var Msg: TWMSize); message WM_SIZE;
   procedure WMKey(var Msg : TWMKey); message WM_KeyDown;
   procedure WMCaptureChanged(var Msg : TMessage); message WM_CaptureChanged;
   procedure ResizeCols;
   procedure FillMinWidths;
   procedure ReCreateVar;
   procedure SetRealTitleFont(Value : TFont);
   procedure SetMultiCaption(Value : boolean);
   procedure SetLongCaption(Value : boolean);
  protected
   procedure DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState);
        override;
   procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
   procedure UpdateTitlesHeight;
   procedure Loaded; override;
   procedure DoEnter; override;
   procedure Paint; override;
  public
    TitleFix : Variant;
    constructor Create(AOwner : TComponent);override;
    destructor Destroy; override;
    function CellRect(ACol, ARow: Longint): TRect;
    function SelectCell(ACol, ARow: Longint): Boolean; override;
    function MouseCoord(X, Y: Integer): TGridCoord;
    procedure MouseToCell(X, Y: Integer; var ACol, ARow: Longint);
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
       X, Y: Integer); override;
    procedure WMHScroll(var Msg: TWMHScroll); message WM_HSCROLL;
    procedure CopyToClipboard; // Only selected rows
    procedure PasteFromClipboard;
    property RowHeights;
    property DataLink;
    property IncSearchText:string read GetIncSearchText write SetIncSearchText;
  published
    property AllowIncSearch:Boolean
      read FAllowIncSearch write FAllowIncSearch;
     // switch on for search (search start when you press alt+key
     // or key only if you grid non-editable)
    property TitleBtn : TTitleBtnStyle read FTitleBtn write FTitleBtn;
    property MultiCaption : boolean read FMultiCaption write SetMultiCaption;
    property FillFields : boolean read FFillFields write FFillFields;
    // Fill fields client area. Don't work correctly! :)
    property LongCaption : boolean read FLongCaption write SetLongCaption;
    property RealTitleFont : TFont read FRealTitleFont write SetRealTitleFont;
    property EnterKey : TEnterKeyDown read FEnterKey write FEnterKey;
    // How interpretare Enter key - as Tab, as Mouse DblClick, or none
    property InternalDrag : boolean read FIntDrag write FIntDrag;
    // Starting drag (with multiselect)
    property DoChangeFocus : boolean read FDoFocus write FDoFocus default true;
    // special for me :) send message WM_Enter to owner form when focused
{...}
    property OnDrawTitle : TOnDrawTitleEvent read FOnDrawTitle write FOnDrawTitle;
    property OnHScroll : TOnScrollEvent read FOnHScroll write FOnHScroll;
    property OnMouseDown;
    property OnMouseUp;
    property OnResizeCol : TNotifyEvent read FOnResizeCol write FOnResizeCol;
    property OnTitleMouseDown: TMouseEvent read FOnTitleMouseDown write FOnTitleMouseDown;
    property OnIncSearch: TIncSearchEvevt read FOnIncSearch write FOnIncSearch;
    property OnPaste : TOnPasteEvent read FOnPasteEvent write FOnPasteEvent;
  end;

procedure Register;

implementation
