unit EanReg;

interface

uses dsgnintf;

type
   TEanEditor =class(TDefaultEditor)
   public
   	procedure ExecuteVerb(Index: Integer); override;
   	function GetVerb(Index: Integer): string; override;
   	function GetVerbCount: Integer; override;
   end;

procedure Register;


implementation

uses EanKod,EanDB,EanQR,EanDBQr,Classes;


procedure TEanEditor.ExecuteVerb(Index: Integer);
begin
   if Component is TCustomEAN then
	case Index of
		0 : TCustomEAN(Component).Copyright;
                1 : TCustomEAN(Component).ActiveSetupWindow;
	end;
   if Component is TQRCustomEAN then
	case Index of
		0 : TQRCustomEAN(Component).Copyright;
                1 : TQRCustomEAN(Component).ActiveSetupWindow;
	end;
end;

function TEanEditor.GetVerb(Index: Integer): String;
begin
	case Index of
		0 : Result := 'EAN library - PSOFT company 98';
                1 : Result := 'EAN editor';
	end;
end;

function TEanEditor.GetVerbCount: Integer;
begin
	Result:= 2;
end;





procedure Register;
begin
     RegisterComponentEditor(TCustomEAN,   TEanEditor);
     RegisterComponentEditor(TQRCustomEAN, TEanEditor);
     RegisterComponents('EAN components',[TEan,TEanMemo,TDBEan,TDBEanMemo,
                                          TQREan,TQREanMemo,TQRDBEan,TQRDBEanMemo]);
end;

end.
