unit MainForm;

interface
{------------------------------------------------------------------------------}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Menus,

  UpdWizardComp,
  UpdRxLib;

type
  TfrmDemoApp = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    StatusBar1: TStatusBar;
    UpdateWizard1: TAppUpdateWizard;
    Update1: TMenuItem;
    N1: TMenuItem;
    Updatewizardlanguage1: TMenuItem;
    English1: TMenuItem;
    Russian1: TMenuItem;
    German1: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure Update1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Russian1Click(Sender: TObject);
  private

  public
    { Public declarations }
  end;

var
  frmDemoApp: TfrmDemoApp;

implementation
{------------------------------------------------------------------------------}

{$R *.DFM}


procedure TfrmDemoApp.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TfrmDemoApp.Update1Click(Sender: TObject);
begin
  UpdateWizard1.Execute;

  if UpdateWizard1.RestartNow
   then Exit1Click(NIL);
end;

procedure TfrmDemoApp.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose := true;

  with UpdateWizard1 do
   if NeedRestart and (not RestartNow)
    then
     if Application.MessageBox('To finish update process you need to restart application, do this now?', 'Confirm', mb_YesNo) = IDYES
      then UpdateWizard1.SpawnUpdater;
end;

procedure TfrmDemoApp.Russian1Click(Sender: TObject);
begin
  (Sender as TMenuItem).Checked := true;
  UpdateWizard1.ApplyLanguageFile(ExtractFilePath(ParamStr(0))+ReplaceStr((Sender as TMenuItem).Caption, '&', '')+'.lng');
end;

end.
