unit aniform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Anigrp10;

type
  TForm1 = class(TForm)
    imgTile: TImage;
    imgFigure: TImage;
    imgGhost1: TImage;
    Timer2: TTimer;
    Figure: TAniFigure;
    Tree: TAniFigure;
    Ghost1: TAniFigure;
    AniMap1: TAniMap;
    Label1: TLabel;
    imgGhost2: TImage;
    imgGhost3: TImage;
    imgTile2: TImage;
    imgWall: TImage;
    imgTree: TImage;
    Ghost2: TAniFigure;
    pnlView: TPanel;
    AniView1: TAniView;
    chkShadow: TCheckBox;
    chkFlight: TCheckBox;
    chkTransparent: TCheckBox;
    chkAutoHighlight: TCheckBox;
    chkLargeShadow: TCheckBox;
    chkFaster: TCheckBox;
    chkFocus: TCheckBox;
    chkHighlight: TCheckBox;
    chkStep: TCheckBox;
    cmdStep: TButton;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure AniView1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer; GridX, GridY: Single);
    procedure AniView1AfterUpdate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure chkFocusClick(Sender: TObject);
    procedure chkShadowClick(Sender: TObject);
    procedure chkHighlightClick(Sender: TObject);
    procedure chkFlightClick(Sender: TObject);
    procedure chkLargeShadowClick(Sender: TObject);
    procedure chkFasterClick(Sender: TObject);
    procedure chkTransparentClick(Sender: TObject);
    procedure chkAutoHighlightClick(Sender: TObject);
    procedure chkStepClick(Sender: TObject);
    procedure cmdStepClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Count: integer;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  Colors: integer;
begin

  Colors:=GetDeviceCaps(AniView1.Canvas.handle,NUMCOLORS);
  chkTransparent.enabled:=(Colors <= 0);

  AniView1.Palette:=imgTile.Picture.Bitmap.Palette;

  with AniMap1 do begin
    Tile[1]:=imgTile.Picture.Bitmap;
    Tile[2]:=imgTile2.Picture.Bitmap;
    Tile[3]:=imgWall.Picture.Bitmap;
    SetGridRange(0,0,AniMap1.Width-1,AniMap1.Height-1,1,True);
    SetGridRange(0,0,6,0,3,False);
    GridTile[5,4]:=3; AniMap1.GridPassable[5,4]:=False;
    GridTile[0,5]:=3; AniMap1.GridPassable[0,5]:=False;
    GridTile[12,3]:=2;
    GridTile[12,5]:=2;
    GridTile[13,2]:=2;
    GridTile[13,4]:=2;
    GridTile[13,6]:=2;
    GridTile[14,3]:=2;
    GridTile[14,5]:=2;
    GridTile[15,2]:=2;
    GridTile[15,4]:=2;
    GridTile[15,6]:=2;
    GridTile[16,3]:=2;
    GridTile[16,5]:=2;
  end;

  AniView1.Map:=AniMap1;

  Figure.Picture[1]:=imgFigure.Picture.Bitmap;
  AniView1.AddFigure(Figure);
  AniView1.SetKeyFigure(Figure);

  Tree.Picture[1]:=imgTree.Picture.Bitmap;
  AniView1.AddFigure(Tree);

  Ghost1.Picture[1]:=imgGhost1.Picture.Bitmap;
  Ghost1.Picture[2]:=imgGhost2.Picture.Bitmap;
  Ghost1.Picture[3]:=imgGhost3.Picture.Bitmap;
  Ghost1.SetScript(1,[1,1,1,2,2,2,1,1,1,3,3,3]);
  AniView1.AddFigure(Ghost1);
  Ghost1.PlayScript(1,True);

  Ghost2.Picture[1]:=imgGhost1.Picture.Bitmap;
  Ghost2.Picture[2]:=imgGhost2.Picture.Bitmap;
  Ghost2.Picture[3]:=imgGhost3.Picture.Bitmap;
  Ghost2.SetScript(1,[1,1,1,1,2,2,2,2,1,1,1,1,3,3,3,3]);
  AniView1.AddFigure(Ghost2);
  Ghost2.PlayScript(1,True);

  AniView1.Active:=True;

end;

procedure TForm1.Timer2Timer(Sender: TObject);
var
  X,Y     :single;
begin
  X:=Random(18);
  Y:=Random(8);
  AniView1.MoveFigure(Ghost1,X,Y,Ghost1.Z);
  X:=Random(18);
  Y:=Random(8);
  AniView1.MoveFigure(Ghost2,X,Y,Ghost2.Z);
  Label1.caption:=IntToStr(Count);
  Count:=0;
end;

procedure TForm1.AniView1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer; GridX, GridY: Single);
begin
  AniView1.MoveFigure(Figure,GridX,GridY,Figure.Z);
end;

procedure TForm1.AniView1AfterUpdate(Sender: TObject);
begin
  inc(Count);
  Application.ProcessMessages;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  pnlView.setbounds(pnlView.Left,pnlView.top,ClientWidth-pnlView.left-pnlView.top,ClientHeight-pnlView.top*2);
end;

procedure TForm1.chkFocusClick(Sender: TObject);
begin
  with Sender as TCheckBox do begin
    if (State = cbChecked) then
      AniView1.SetKeyFigure(Figure)
    else
      AniView1.ClearKeyFigure;
  end;
end;

procedure TForm1.chkShadowClick(Sender: TObject);
begin
  with Sender as TCheckBox do begin
    Figure.Shadow:=(State = cbChecked);
  end;
end;

procedure TForm1.chkHighlightClick(Sender: TObject);
begin
  with Sender as TCheckBox do begin
    Figure.Highlighted:=(State = cbChecked)
  end;
end;

procedure TForm1.chkFlightClick(Sender: TObject);
begin
  with Sender as TCheckBox do begin
    if (State = cbChecked) then
      AniView1.MoveFigure(Figure,Figure.X,Figure.Y,4)
    else
      AniView1.MoveFigure(Figure,Figure.X,Figure.Y,0);
  end;
end;

procedure TForm1.chkLargeShadowClick(Sender: TObject);
begin
  with Sender as TCheckBox do begin
    if (State = cbChecked) then
      Figure.ShadowRadius:=1
    else
      Figure.ShadowRadius:=0.375;
  end;
end;

procedure TForm1.chkFasterClick(Sender: TObject);
begin
  with Sender as TCheckBox do begin
    if (State = cbChecked) then
      Figure.Speed:=1
    else
      Figure.Speed:=0.25;
  end;
end;

procedure TForm1.chkTransparentClick(Sender: TObject);
begin
  with Sender as TCheckBox do begin
    Ghost1.Transparent:=(State = cbChecked);
    Ghost2.Transparent:=(State = cbChecked);
  end;
end;

procedure TForm1.chkAutoHighlightClick(Sender: TObject);
begin
  with Sender as TCheckBox do begin
    Ghost1.AutoHighlight:=(State = cbChecked);
    Ghost2.AutoHighlight:=(State = cbChecked);
  end;
end;


procedure TForm1.chkStepClick(Sender: TObject);
begin
  with Sender as TCheckBox do begin
    AniView1.Active:=(State <> cbChecked);
    cmdStep.enabled:=(State = cbChecked);
  end;
end;

procedure TForm1.cmdStepClick(Sender: TObject);
begin
  AniView1.DrawFrame;
end;

end.
