(************************************************************************
 * Copyright  1999 by
 *
 * IVS GbR
 * Annaberger Str. 240
 * D-09125 Chemnitz
 *
 * Tel. +49-371-5347 380
 * Fax +49-371-5347 428
 *
 * http://www.ivs-solutions.de
 *
 * $Header: /Projects/Components/Componenten Source/IVS Tool Library/LangControl Shareware/DemoMain.pas 4     16.09.99 11:57 Sl $
 *
 * Description: LangControl demo application
 *
 ************************************************************************)

unit DemoMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ComCtrls, ExtCtrls, Menus, StdCtrls, LangControl, DemoLang;

{ TMainForm }

type
  TMainForm = class(TForm)
    LangControl: TLangControl;
    MainMenu: TMainMenu;
    MenuFile: TMenuItem;
    ItemOpen: TMenuItem;
    ItemSave: TMenuItem;
    ItemSaveAs: TMenuItem;
    ItemN1: TMenuItem;
    ItemExit: TMenuItem;
    MenuEdit: TMenuItem;
    ItemCut: TMenuItem;
    ItemCopy: TMenuItem;
    ItemPaste: TMenuItem;
    MenuOptions: TMenuItem;
    ItemLang: TMenuItem;
    MenuHelp: TMenuItem;
    ItemHelp: TMenuItem;
    ItemN2: TMenuItem;
    ItemAbout: TMenuItem;
    StatusBar: TStatusBar;
    Memo: TRichEdit;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    PanelToolbar: TPanel;
    SpeedBtnLang: TSpeedButton;
    LangComboBox: TLangComboBox;
    LabelFont: TLabel;
    ImageGermany: TImage;
    ImageUSA: TImage;
    PanelDummy: TPanel;

    // Form events
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);

    // LangControl events
    procedure LangControlChange(Sender: TObject);

    // File menu events
    procedure ItemOpenClick(Sender: TObject);
    procedure ItemSaveClick(Sender: TObject);
    procedure ItemSaveAsClick(Sender: TObject);
    procedure ItemExitClick(Sender: TObject);

    // Edit menu events
    procedure ItemPasteClick(Sender: TObject);
    procedure ItemCutClick(Sender: TObject);
    procedure ItemCopyClick(Sender: TObject);

    // Option menu events
    procedure ItemLangClick(Sender: TObject);

    // Help menu events
    procedure ItemHelpClick(Sender: TObject);
    procedure ItemAboutClick(Sender: TObject);
  private
    FFileName:string;
    procedure CheckStatus;
    procedure ApplicationHint(Sender:TObject);
  public
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{ TMainForm }

procedure TMainForm.CheckStatus;
var
  S:string;
begin
  // Check document state
  if FFileName=''then
    StatusBar.Panels[1].Text:=LangControl.GetString('NoFileName')
  else
  begin
    S:=LangControl.GetString('FileName');
    StatusBar.Panels[1].Text:=Format(S,[FFileName]);
  end;

  // Refresh font label
  LabelFont.Caption:=LangControl.GetString('CurrentFont')+Font.Name;
end;

procedure TMainForm.ApplicationHint(Sender:TObject);
begin
  if Application.Hint=''
  then CheckStatus
  else StatusBar.Panels[1].Text:=Application.Hint;
end;

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if Memo.Modified then
    ItemSaveAsClick(Self);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint:=ApplicationHint;
  CheckStatus;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Application.OnHint:=nil;
end;

procedure TMainForm.LangControlChange(Sender: TObject);
begin
  CheckStatus;
end;

procedure TMainForm.ItemOpenClick(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    Memo.Lines.BeginUpdate;
    try
      Memo.Lines.Clear;
      Memo.Lines.LoadFromFile(OpenDialog.FileName);
    finally
      Memo.Lines.EndUpdate;
    end;
    FFileName:=OpenDialog.FileName;
    Memo.Modified:=False;
    CheckStatus;
  end;
end;

procedure TMainForm.ItemSaveClick(Sender: TObject);
begin
  if FFileName=''then
    ItemSaveAsClick(Self)
  else
  begin
    Memo.Lines.SaveToFile(FFileName);
    Memo.Modified:=False;
  end;
end;

procedure TMainForm.ItemSaveAsClick(Sender: TObject);
begin
  if SaveDialog.Execute then
  begin
    Memo.Lines.SaveToFile(SaveDialog.FileName);
    FFileName:=SaveDialog.FileName;
    Memo.Modified:=False;
    CheckStatus;
  end;
end;

procedure TMainForm.ItemExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.ItemPasteClick(Sender: TObject);
begin
  Memo.PasteFromClipboard;
end;

procedure TMainForm.ItemCutClick(Sender: TObject);
begin
  Memo.CutToClipboard;
end;

procedure TMainForm.ItemCopyClick(Sender: TObject);
begin
  Memo.CopyToClipboard;
end;

procedure TMainForm.ItemLangClick(Sender: TObject);
var
  F:TLangForm;
begin
  F:=TLangForm.Create(Application);
  try
    F.ShowModal;
  finally
    F.Free;
  end;
end;

procedure TMainForm.ItemHelpClick(Sender: TObject);
begin
  ShowMessage(LangControl.GetString('EHelpError'));
end;

procedure TMainForm.ItemAboutClick(Sender: TObject);
begin
  ShowMessage(
    'Copyright  1999 IVS GbR'#13#10#13#10+
    'IVS GbR - Software Engineering'#13#10+
    'http://www.ivs-solutions.de');
end;

end.
