// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'AdvPicture.pas' rev: 3.00

#ifndef AdvPictureHPP
#define AdvPictureHPP
#include <SysUtils.hpp>
#include <ActiveX.hpp>
#include <ComObj.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <Messages.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Advpicture
{
//-- type declarations -------------------------------------------------------
enum TPicturePosition { bpTopLeft, bpTopRight, bpBottomLeft, bpBottomRight, bpCenter, bpTiled, bpStretched, 
	bpStretchedWithAspect };

enum TStretchMode { smNever, smShrink };

class DELPHICLASS TIPicture;
class PASCALIMPLEMENTATION TIPicture : public Graphics::TGraphic 
{
	typedef Graphics::TGraphic inherited;
	
private:
	_di_IPicture gpPicture;
	Classes::TMemoryStream* FDatastream;
	bool FIsEmpty;
	bool FStretched;
	int FLogPixX;
	int FLogPixY;
	System::AnsiString FID;
	int FFrame;
	Classes::TNotifyEvent FOnFrameChange;
	Word FFrameXPos;
	Word FFrameYPos;
	Word FFrameXSize;
	Word FFrameYSize;
	bool FFrameTransp;
	Word FFrameDisposal;
	Word FAnimMaxX;
	Word FAnimMaxY;
	void __fastcall LoadPicture(void);
	int __fastcall GetFrameCount(void);
	bool __fastcall IsGIFFile(void);
	int __fastcall GetFrameTime(int i);
	
protected:
	virtual bool __fastcall GetEmpty(void);
	virtual int __fastcall GetHeight(void);
	virtual int __fastcall GetWidth(void);
	virtual void __fastcall SetHeight(int Value);
	virtual void __fastcall SetWidth(int Value);
	virtual void __fastcall ReadData(Classes::TStream* Stream);
	virtual void __fastcall WriteData(Classes::TStream* Stream);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas, const Windows::TRect &Rect);
	void __fastcall SetFrame(const int Value);
	
public:
	__fastcall virtual TIPicture(void);
	__fastcall virtual ~TIPicture(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual void __fastcall LoadFromFile(const System::AnsiString FileName);
	virtual void __fastcall LoadFromStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToStream(Classes::TStream* Stream);
	void __fastcall LoadFromResourceName(int Instance, const System::AnsiString ResName);
	void __fastcall LoadFromResourceID(int Instance, int ResID);
	void __fastcall LoadFromURL(System::AnsiString url);
	virtual void __fastcall LoadFromClipboardFormat(Word AFormat, int AData, HPALETTE APalette);
	virtual void __fastcall SaveToClipboardFormat(Word &AFormat, int &AData, HPALETTE &APalette);
	__property System::AnsiString ID = {read=FID, write=FID};
	__property bool IsGIF = {read=IsGIFFile, nodefault};
	__property int FrameCount = {read=GetFrameCount, nodefault};
	__property int FrameTime[int i] = {read=GetFrameTime};
	int __fastcall GetMaxHeight(void);
	int __fastcall GetMaxWidth(void);
	
__published:
	__property bool Stretch = {read=FStretched, write=FStretched, nodefault};
	__property int Frame = {read=FFrame, write=SetFrame, nodefault};
	__property Classes::TNotifyEvent OnFrameChange = {read=FOnFrameChange, write=FOnFrameChange};
};

class DELPHICLASS THelperWnd;
class PASCALIMPLEMENTATION THelperWnd : public Controls::TWinControl 
{
	typedef Controls::TWinControl inherited;
	
private:
	Classes::TNotifyEvent FOnTimer;
	MESSAGE void __fastcall WMTimer(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall WMDestroy(Messages::TMessage &Msg);
	
public:
	__fastcall virtual THelperWnd(Classes::TComponent* AOwner);
	__fastcall virtual ~THelperWnd(void);
	virtual void __fastcall CreateWnd(void);
	
__published:
	__property Classes::TNotifyEvent OnTimer = {read=FOnTimer, write=FOnTimer};
public:
	/* TWinControl.CreateParented */ __fastcall THelperWnd(HWND ParentWindow) : Controls::TWinControl(ParentWindow
		) { }
	
};

class DELPHICLASS TAdvPicture;
class PASCALIMPLEMENTATION TAdvPicture : public Controls::TGraphicControl 
{
	typedef Controls::TGraphicControl inherited;
	
private:
	bool FAnimate;
	bool FAutoSize;
	TIPicture* FIPicture;
	TPicturePosition FPicturePosition;
	THelperWnd* FHelperWnd;
	int FTimerCount;
	int FNextCount;
	bool FAnimatedGif;
	Classes::TNotifyEvent FOnFrameChange;
	TStretchMode FStretchMode;
	void __fastcall SetAutoSize(const bool Value);
	void __fastcall SetIPicture(const TIPicture* Value);
	void __fastcall PictureChanged(System::TObject* sender);
	void __fastcall FrameChanged(System::TObject* sender);
	void __fastcall Timer(System::TObject* sender);
	void __fastcall SetPicturePosition(const TPicturePosition Value);
	void __fastcall SetAnimate(const bool Value);
	void __fastcall SetStretchMode(const TStretchMode Value);
	
protected:
	virtual void __fastcall Paint(void);
	
public:
	__fastcall virtual TAdvPicture(Classes::TComponent* aOwner);
	__fastcall virtual ~TAdvPicture(void);
	virtual void __fastcall Loaded(void);
	
__published:
	__property bool Animate = {read=FAnimate, write=SetAnimate, nodefault};
	__property bool AutoSize = {read=FAutoSize, write=SetAutoSize, default=0};
	__property TIPicture* Picture = {read=FIPicture, write=SetIPicture};
	__property TPicturePosition PicturePosition = {read=FPicturePosition, write=SetPicturePosition, nodefault
		};
	__property Align ;
	__property DragCursor ;
	__property DragMode ;
	__property Hint ;
	__property ParentShowHint ;
	__property ShowHint ;
	__property TStretchMode StretchMode = {read=FStretchMode, write=SetStretchMode, default=0};
	__property Visible ;
	__property OnClick ;
	__property OnDblClick ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDrag ;
	__property OnMouseDown ;
	__property OnMouseUp ;
	__property OnMouseMove ;
	__property OnStartDrag ;
	__property Classes::TNotifyEvent OnFrameChange = {read=FOnFrameChange, write=FOnFrameChange};
};

//-- var, const, procedure ---------------------------------------------------

}	/* namespace Advpicture */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Advpicture;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// AdvPicture
