// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'AdvEdit.pas' rev: 3.00

#ifndef AdvEditHPP
#define AdvEditHPP
#include <Menus.hpp>
#include <IniFiles.hpp>
#include <Consts.hpp>
#include <Mask.hpp>
#include <Clipbrd.hpp>
#include <StdCtrls.hpp>
#include <Dialogs.hpp>
#include <Forms.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Messages.hpp>
#include <Registry.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Advedit
{
//-- type declarations -------------------------------------------------------
enum TLabelPosition { lpLeftTop, lpLeftCenter, lpLeftBottom, lpTopLeft, lpBottomLeft, lpLeftTopLeft, 
	lpLeftCenterLeft, lpLeftBottomLeft };

enum TAdvEditType { etString, etNumeric, etFloat, etUppercase, etMixedCase, etLowerCase, etPassword, 
	etMoney, etRange, etHex };

enum TAutoType { atNumeric, atFloat, atString, atDate, atTime, atHex };

typedef void __fastcall (__closure *TValueValidateEvent)(System::TObject* Sender, System::AnsiString 
	value, bool &IsValid);

typedef void __fastcall (__closure *TClipboardEvent)(System::TObject* Sender, System::AnsiString value
	, bool &allow);

typedef void __fastcall (__closure *TMaskCompleteEvent)(System::TObject* Sender, System::AnsiString 
	value, bool &accept);

class DELPHICLASS TRangeList;
class PASCALIMPLEMENTATION TRangeList : public Classes::TList 
{
	typedef Classes::TList inherited;
	
private:
	void __fastcall SetInteger(int Index, int Value);
	int __fastcall GetInteger(int Index);
	
public:
	__fastcall TRangeList(void);
	__property int Items[int index] = {read=GetInteger, write=SetInteger/*, default*/};
	HIDESBASE void __fastcall Add(int Value);
	void __fastcall AddMultiple(int Value, int Count);
	HIDESBASE void __fastcall Delete(int Index);
	void __fastcall Show(void);
	bool __fastcall InList(int Value);
	bool __fastcall StrToList(System::AnsiString s);
public:
	/* TList.Destroy */ __fastcall virtual ~TRangeList(void) { }
	
};

enum TPersistenceLocation { plInifile, plRegistry };

class DELPHICLASS TPersistence;
class PASCALIMPLEMENTATION TPersistence : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool fEnable;
	System::AnsiString fKey;
	System::AnsiString fSection;
	TPersistenceLocation fLocation;
	
__published:
	__property bool Enable = {read=fEnable, write=fEnable, nodefault};
	__property System::AnsiString Key = {read=fKey, write=fKey};
	__property System::AnsiString Section = {read=fSection, write=fSection};
	__property TPersistenceLocation Location = {read=fLocation, write=fLocation, nodefault};
public:
	/* TPersistent.Destroy */ __fastcall virtual ~TPersistence(void) { }
	
public:
	/* TObject.Create */ __fastcall TPersistence(void) : Classes::TPersistent() { }
	
};

class DELPHICLASS TAdvEdit;
class PASCALIMPLEMENTATION TAdvEdit : public Stdctrls::TCustomEdit 
{
	typedef Stdctrls::TCustomEdit inherited;
	
private:
	Stdctrls::TLabel* fLabel;
	TLabelPosition fLabelPosition;
	int fLabelMargin;
	bool fLabelTransparent;
	bool fAutoFocus;
	Graphics::TColor fNormalColor;
	TAdvEditType fEditType;
	bool fExcelStyleDecimalSeparator;
	bool fTabOnFullLength;
	Graphics::TColor fFocusColor;
	bool fFocusLabel;
	Graphics::TColor fFontColor;
	Graphics::TColor fModifiedColor;
	bool fReturnIsTab;
	bool fShowModified;
	bool fIsModified;
	bool fShowURL;
	Graphics::TColor fURLColor;
	short fLengthLimit;
	short fPrecision;
	System::AnsiString fPrefix;
	System::AnsiString fSuffix;
	System::AnsiString fOldString;
	bool fSigned;
	bool fIsUrl;
	bool fFlat;
	TPersistence* fPersistence;
	TValueValidateEvent fOnValueValidate;
	TClipboardEvent fOnClipboardCut;
	TClipboardEvent fOnClipboardPaste;
	TClipboardEvent fOnClipboardCopy;
	HIDESBASE MESSAGE void __fastcall CNCommand(Messages::TWMCommand &Message);
	HIDESBASE MESSAGE void __fastcall CMFontChanged(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMKillFocus(Messages::TWMKillFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &Msg);
	MESSAGE void __fastcall WMPaste(Messages::TMessage &Msg);
	MESSAGE void __fastcall WMCut(Messages::TWMNoParams &Message);
	MESSAGE void __fastcall WMCopy(Messages::TWMNoParams &Message);
	HIDESBASE MESSAGE void __fastcall WMKeyDown(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMLButtonUp(Messages::TWMMouse &Msg);
	HIDESBASE MESSAGE void __fastcall WMLButtonDown(Messages::TWMMouse &Msg);
	HIDESBASE MESSAGE void __fastcall WMPaint(Messages::TWMPaint &Msg);
	HIDESBASE MESSAGE void __fastcall WMDestroy(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall CMMouseEnter(Messages::TMessage &Msg);
	void __fastcall SetEditType(TAdvEditType value);
	HIDESBASE System::AnsiString __fastcall GetText();
	HIDESBASE void __fastcall SetText(System::AnsiString value);
	double __fastcall GetFloat(void);
	int __fastcall GetInt(void);
	int __fastcall FixedLength(System::AnsiString s);
	int __fastcall DecimalPos(void);
	void __fastcall SetFloat(const double Value);
	void __fastcall SetInt(const int Value);
	void __fastcall SetPrefix(const System::AnsiString Value);
	void __fastcall SetSuffix(const System::AnsiString Value);
	void __fastcall SetLabelCaption(const System::AnsiString value);
	System::AnsiString __fastcall GetLabelCaption();
	void __fastcall SetLabelPosition(const TLabelPosition value);
	void __fastcall SetLabelMargin(const int value);
	void __fastcall SetLabelTransparent(const bool value);
	void __fastcall SetFlat(const bool value);
	void __fastcall SetPrecision(const short value);
	void __fastcall UpdateLabel(void);
	void __fastcall AutoSeparators(void);
	HIDESBASE bool __fastcall GetModified(void);
	HIDESBASE void __fastcall SetModified(const bool Value);
	bool __fastcall GetVisible(void);
	HIDESBASE void __fastcall SetVisible(const bool Value);
	
protected:
	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);
	Stdctrls::TLabel* __fastcall CreateLabel(void);
	virtual void __fastcall Loaded(void);
	
public:
	__fastcall virtual TAdvEdit(Classes::TComponent* aOwner);
	__fastcall virtual ~TAdvEdit(void);
	virtual void __fastcall SetBounds(int ALeft, int ATop, int AWidth, int AHeight);
	HIDESBASE void __fastcall SelectAll(void);
	void __fastcall SelectBeforeDecimal(void);
	void __fastcall SelectAfterDecimal(void);
	__property double FloatValue = {read=GetFloat, write=SetFloat};
	__property int IntValue = {read=GetInt, write=SetInt, nodefault};
	__property bool Modified = {read=GetModified, write=SetModified, nodefault};
	bool __fastcall RangeStrToList(TRangeList* rangelist);
	void __fastcall ListToRangeStr(TRangeList* rangelist);
	void __fastcall LoadPersist(void);
	void __fastcall SavePersist(void);
	
__published:
	__property TValueValidateEvent OnValueValidate = {read=fOnValueValidate, write=fOnValueValidate};
	__property TClipboardEvent OnClipboardCopy = {read=fOnClipboardCopy, write=fOnClipboardCopy};
	__property TClipboardEvent OnClipboardCut = {read=fOnClipboardCut, write=fOnClipboardCut};
	__property TClipboardEvent OnClipboardPaste = {read=fOnClipboardPaste, write=fOnClipboardPaste};
	__property bool AutoFocus = {read=fAutoFocus, write=fAutoFocus, nodefault};
	__property TAdvEditType EditType = {read=fEditType, write=SetEditType, nodefault};
	__property bool ExcelStyleDecimalSeparator = {read=fExcelStyleDecimalSeparator, write=fExcelStyleDecimalSeparator
		, nodefault};
	__property bool Flat = {read=fFlat, write=SetFlat, nodefault};
	__property Graphics::TColor FocusColor = {read=fFocusColor, write=fFocusColor, nodefault};
	__property bool FocusLabel = {read=fFocusLabel, write=fFocusLabel, nodefault};
	__property Graphics::TColor ModifiedColor = {read=fModifiedColor, write=fModifiedColor, nodefault};
		
	__property bool ShowModified = {read=fShowModified, write=fShowModified, nodefault};
	__property bool ShowURL = {read=fShowURL, write=fShowURL, nodefault};
	__property Graphics::TColor URLColor = {read=fURLColor, write=fURLColor, nodefault};
	__property bool ReturnIsTab = {read=fReturnIsTab, write=fReturnIsTab, nodefault};
	__property short LengthLimit = {read=fLengthLimit, write=fLengthLimit, nodefault};
	__property bool TabOnFullLength = {read=fTabOnFullLength, write=fTabOnFullLength, nodefault};
	__property short Precision = {read=fPrecision, write=SetPrecision, nodefault};
	__property System::AnsiString Prefix = {read=fPrefix, write=SetPrefix};
	__property System::AnsiString Suffix = {read=fSuffix, write=SetSuffix};
	__property System::AnsiString LabelCaption = {read=GetLabelCaption, write=SetLabelCaption};
	__property TLabelPosition LabelPosition = {read=fLabelPosition, write=SetLabelPosition, nodefault};
		
	__property int LabelMargin = {read=fLabelMargin, write=SetLabelMargin, nodefault};
	__property bool LabelTransparent = {read=fLabelTransparent, write=SetLabelTransparent, nodefault};
	__property TPersistence* Persistence = {read=fPersistence, write=fPersistence};
	__property AutoSelect ;
	__property AutoSize ;
	__property BorderStyle ;
	__property Color ;
	__property Ctl3D ;
	__property DragCursor ;
	__property DragMode ;
	__property Enabled ;
	__property Font ;
	__property HideSelection ;
	__property ImeMode ;
	__property ImeName ;
	__property MaxLength ;
	__property OEMConvert ;
	__property ParentColor ;
	__property ParentCtl3D ;
	__property ParentFont ;
	__property ParentShowHint ;
	__property PopupMenu ;
	__property ReadOnly ;
	__property ShowHint ;
	__property bool Signed = {read=fSigned, write=fSigned, nodefault};
	__property TabOrder ;
	__property TabStop ;
	__property System::AnsiString Text = {read=GetText, write=SetText};
	__property bool Visible = {read=GetVisible, write=SetVisible, nodefault};
	__property OnChange ;
	__property OnClick ;
	__property OnDblClick ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDrag ;
	__property OnStartDrag ;
	__property OnEnter ;
	__property OnExit ;
	__property OnKeyDown ;
	__property OnKeyPress ;
	__property OnKeyUp ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
public:
	/* TWinControl.CreateParented */ __fastcall TAdvEdit(HWND ParentWindow) : Stdctrls::TCustomEdit(ParentWindow
		) { }
	
};

class DELPHICLASS TAdvMaskEdit;
class PASCALIMPLEMENTATION TAdvMaskEdit : public Mask::TMaskEdit 
{
	typedef Mask::TMaskEdit inherited;
	
private:
	Stdctrls::TLabel* fLabel;
	bool fAutoFocus;
	bool fAutoTab;
	bool fReturnIsTab;
	TAlignment fAlignment;
	Graphics::TColor fFocusColor;
	Graphics::TColor fNormalColor;
	Graphics::TColor fFontColor;
	Graphics::TColor fModifiedColor;
	bool fShowModified;
	int fLabelMargin;
	TLabelPosition fLabelPosition;
	bool fFlat;
	TMaskCompleteEvent fOnMaskComplete;
	void __fastcall SetAlignment(Classes::TAlignment value);
	HIDESBASE MESSAGE void __fastcall CMFontChanged(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMKillFocus(Messages::TWMKillFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall CMMouseEnter(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall WMPaint(Messages::TWMPaint &Msg);
	HIDESBASE MESSAGE void __fastcall WMKeyDown(Messages::TWMKey &Msg);
	System::AnsiString __fastcall GetLabelCaption();
	void __fastcall SetLabelCaption(const System::AnsiString Value);
	void __fastcall SetLabelMargin(const int Value);
	void __fastcall SetLabelPosition(const TLabelPosition Value);
	void __fastcall UpdateLabel(void);
	void __fastcall SetFlat(const bool Value);
	HIDESBASE bool __fastcall GetModified(void);
	HIDESBASE void __fastcall SetModified(const bool Value);
	
protected:
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall DoEnter(void);
	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);
	Stdctrls::TLabel* __fastcall CreateLabel(void);
	
public:
	__fastcall virtual TAdvMaskEdit(Classes::TComponent* AOwner);
	virtual void __fastcall SetBounds(int ALeft, int ATop, int AWidth, int AHeight);
	__fastcall virtual ~TAdvMaskEdit(void);
	__property bool Modified = {read=GetModified, write=SetModified, nodefault};
	
__published:
	__property bool AutoFocus = {read=fAutoFocus, write=fAutoFocus, nodefault};
	__property bool AutoTab = {read=fAutoTab, write=fAutoTab, default=1};
	__property bool Flat = {read=fFlat, write=SetFlat, nodefault};
	__property bool ShowModified = {read=fShowModified, write=fShowModified, nodefault};
	__property Graphics::TColor FocusColor = {read=fFocusColor, write=fFocusColor, nodefault};
	__property System::AnsiString LabelCaption = {read=GetLabelCaption, write=SetLabelCaption};
	__property TLabelPosition LabelPosition = {read=fLabelPosition, write=SetLabelPosition, nodefault};
		
	__property int LabelMargin = {read=fLabelMargin, write=SetLabelMargin, nodefault};
	__property Graphics::TColor ModifiedColor = {read=fModifiedColor, write=fModifiedColor, nodefault};
		
	__property bool ReturnIsTab = {read=fReturnIsTab, write=fReturnIsTab, default=1};
	__property Classes::TAlignment Alignement = {read=fAlignment, write=SetAlignment, default=0};
	__property TMaskCompleteEvent OnMaskComplete = {read=fOnMaskComplete, write=fOnMaskComplete};
public:
		
	/* TWinControl.CreateParented */ __fastcall TAdvMaskEdit(HWND ParentWindow) : Mask::TMaskEdit(ParentWindow
		) { }
	
};

struct TQueryParams;
typedef TQueryParams *PQueryParams;

struct TQueryParams
{
	int Precision;
	bool Flat;
	int Lengthlimit;
	System::AnsiString Prefix;
	System::AnsiString Suffix;
} ;

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE bool __fastcall AdvInputQuery(const TAdvEditType QueryType, PQueryParams QueryParams, 
	const System::AnsiString ACaption, const System::AnsiString APrompt, System::AnsiString &Value);

}	/* namespace Advedit */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Advedit;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// AdvEdit
