// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'AdvEdit.pas' rev: 3.00

#ifndef AdvEditHPP
#define AdvEditHPP
#include <Menus.hpp>
#include <ActiveX.hpp>
#include <AdvEddd.hpp>
#include <IniFiles.hpp>
#include <Consts.hpp>
#include <Mask.hpp>
#include <Clipbrd.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Messages.hpp>
#include <Dialogs.hpp>
#include <Registry.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Advedit
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TWinCtrl;
class PASCALIMPLEMENTATION TWinCtrl : public Controls::TWinControl 
{
	typedef Controls::TWinControl inherited;
	
public:
	/* TWinControl.Create */ __fastcall virtual TWinCtrl(Classes::TComponent* AOwner) : Controls::TWinControl(
		AOwner) { }
	/* TWinControl.CreateParented */ __fastcall TWinCtrl(HWND ParentWindow) : Controls::TWinControl(ParentWindow
		) { }
	/* TWinControl.Destroy */ __fastcall virtual ~TWinCtrl(void) { }
	
};

enum TLabelPosition { lpLeftTop, lpLeftCenter, lpLeftBottom, lpTopLeft, lpBottomLeft, lpLeftTopLeft, 
	lpLeftCenterLeft, lpLeftBottomLeft, lpTopCenter, lpBottomCenter };

enum TAdvEditType { etString, etNumeric, etFloat, etUppercase, etMixedCase, etLowerCase, etPassword, 
	etMoney, etRange, etHex };

enum TAutoType { atNumeric, atFloat, atString, atDate, atTime, atHex };

typedef void __fastcall (__closure *TValueValidateEvent)(System::TObject* Sender, System::AnsiString 
	value, bool &IsValid);

typedef void __fastcall (__closure *TClipboardEvent)(System::TObject* Sender, System::AnsiString value
	, bool &allow);

typedef void __fastcall (__closure *TMaskCompleteEvent)(System::TObject* Sender, System::AnsiString 
	value, bool &accept);

class DELPHICLASS TRangeList;
class PASCALIMPLEMENTATION TRangeList : public Classes::TList 
{
	typedef Classes::TList inherited;
	
private:
	void __fastcall SetInteger(int Index, int Value);
	int __fastcall GetInteger(int Index);
	
public:
	__fastcall TRangeList(void);
	__property int Items[int index] = {read=GetInteger, write=SetInteger/*, default*/};
	HIDESBASE void __fastcall Add(int Value);
	void __fastcall AddMultiple(int Value, int Count);
	HIDESBASE void __fastcall Delete(int Index);
	void __fastcall Show(void);
	bool __fastcall InList(int Value);
	bool __fastcall StrToList(System::AnsiString s);
public:
	/* TList.Destroy */ __fastcall virtual ~TRangeList(void) { }
	
};

enum TPersistenceLocation { plInifile, plRegistry };

class DELPHICLASS TPersistence;
class PASCALIMPLEMENTATION TPersistence : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FEnable;
	System::AnsiString FKey;
	System::AnsiString FSection;
	TPersistenceLocation FLocation;
	
__published:
	__property bool Enable = {read=FEnable, write=FEnable, nodefault};
	__property System::AnsiString Key = {read=FKey, write=FKey};
	__property System::AnsiString Section = {read=FSection, write=FSection};
	__property TPersistenceLocation Location = {read=FLocation, write=FLocation, nodefault};
public:
	/* TPersistent.Destroy */ __fastcall virtual ~TPersistence(void) { }
	
public:
	/* TObject.Create */ __fastcall TPersistence(void) : Classes::TPersistent() { }
	
};

enum TEditAlign { eaLeft, eaRight, eaDefault, eaCenter };

class DELPHICLASS TAdvEdit;
class PASCALIMPLEMENTATION TAdvEdit : public Stdctrls::TCustomEdit 
{
	typedef Stdctrls::TCustomEdit inherited;
	
private:
	bool FAlignChanging;
	Stdctrls::TLabel* FLabel;
	Graphics::TFont* FLabelFont;
	TLabelPosition FLabelPosition;
	int FLabelMargin;
	bool FLabelTransparent;
	bool FAutoFocus;
	bool FCanUndo;
	TAdvEditType FEditType;
	TEditAlign FEditAlign;
	TEditAlign FOldEditAlign;
	TFormBorderStyle FOldBorder;
	bool FExcelStyleDecimalSeparator;
	bool FTabOnFullLength;
	Graphics::TColor FDisabledColor;
	Graphics::TColor FNormalColor;
	Graphics::TColor FFocusColor;
	Graphics::TColor FFocusFontColor;
	Graphics::TColor FErrorColor;
	Graphics::TColor FErrorFontColor;
	bool FError;
	bool FFocusLabel;
	Graphics::TColor FFontColor;
	Graphics::TColor FModifiedColor;
	bool FReturnIsTab;
	bool FShowModified;
	bool FIsModified;
	bool FShowURL;
	Graphics::TColor FURLColor;
	int FFocusWidthInc;
	TEditAlign FFocusAlign;
	short FLengthLimit;
	short FPrecision;
	System::AnsiString FPrefix;
	System::AnsiString FSuffix;
	System::AnsiString FOldString;
	bool FSigned;
	bool FIsUrl;
	bool FFlat;
	bool FMouseInControl;
	Graphics::TColor FFlatLineColor;
	TPersistence* FPersistence;
	TValueValidateEvent FOnValueValidate;
	TClipboardEvent FOnClipboardCut;
	TClipboardEvent FOnClipboardPaste;
	TClipboardEvent FOnClipboardCopy;
	bool FFlatParentColor;
	bool FTransparent;
	tagPOINT FCaretPos;
	bool FOleDropSource;
	bool FOleDropTarget;
	bool FOleDropTargetAssigned;
	bool FIsDragSource;
	bool FButtonDown;
	bool FFocusBorder;
	bool FHintShowLargeText;
	bool FShowError;
	bool FAutoThousandSeparator;
	System::AnsiString FEmptyText;
	bool FSoftBorder;
	HIDESBASE MESSAGE void __fastcall CNCommand(Messages::TWMCommand &Message);
	MESSAGE void __fastcall CNCtlColorEdit(Messages::TWMCtlColor &Message);
	MESSAGE void __fastcall CNCtlColorStatic(Messages::TWMCtlColor &Message);
	HIDESBASE MESSAGE void __fastcall CMFontChanged(Messages::TMessage &Message);
	MESSAGE void __fastcall CMHintShow(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMKillFocus(Messages::TWMKillFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &Msg);
	MESSAGE void __fastcall WMPaste(Messages::TMessage &Msg);
	MESSAGE void __fastcall WMCut(Messages::TWMNoParams &Message);
	MESSAGE void __fastcall WMCopy(Messages::TWMNoParams &Message);
	HIDESBASE MESSAGE void __fastcall WMKeyDown(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMLButtonUp(Messages::TWMMouse &Msg);
	HIDESBASE MESSAGE void __fastcall WMLButtonDown(Messages::TWMMouse &Msg);
	HIDESBASE MESSAGE void __fastcall WMPaint(Messages::TWMPaint &Msg);
	MESSAGE void __fastcall WMNCPaint(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall WMEraseBkGnd(Messages::TWMEraseBkgnd &Message);
	HIDESBASE MESSAGE void __fastcall WMDestroy(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall WMMouseMove(Messages::TWMMouse &Msg);
	HIDESBASE MESSAGE void __fastcall CMMouseEnter(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall CMMouseLeave(Messages::TMessage &Message);
	MESSAGE void __fastcall CMWantSpecialKey(Messages::TWMKey &Msg);
	void __fastcall SetEditType(TAdvEditType value);
	HIDESBASE System::AnsiString __fastcall GetText();
	HIDESBASE void __fastcall SetText(System::AnsiString value);
	double __fastcall GetFloat(void);
	int __fastcall GetInt(void);
	int __fastcall GetTextSize(void);
	int __fastcall FixedLength(System::AnsiString s);
	int __fastcall DecimalPos(void);
	void __fastcall SetFloat(const double Value);
	void __fastcall SetInt(const int Value);
	void __fastcall SetPrefix(const System::AnsiString Value);
	void __fastcall SetSuffix(const System::AnsiString Value);
	void __fastcall SetLabelCaption(const System::AnsiString value);
	System::AnsiString __fastcall GetLabelCaption();
	void __fastcall SetLabelPosition(const TLabelPosition value);
	void __fastcall SetLabelMargin(const int value);
	void __fastcall SetLabelTransparent(const bool value);
	void __fastcall SetFlat(const bool value);
	void __fastcall SetFlatRect(const bool Value);
	void __fastcall SetPrecision(const short Value);
	Extended __fastcall EStrToFloat(System::AnsiString s);
	void __fastcall UpdateLabel(void);
	void __fastcall AutoSeparators(void);
	HIDESBASE bool __fastcall GetModified(void);
	HIDESBASE void __fastcall SetModified(const bool Value);
	bool __fastcall GetVisible(void);
	HIDESBASE void __fastcall SetVisible(const bool Value);
	void __fastcall PaintEdit(void);
	void __fastcall DrawControlBorder(HDC DC);
	void __fastcall DrawBorder(void);
	bool __fastcall Is3DBorderButton(void);
	void __fastcall SetDisabledColor(const Graphics::TColor Value);
	bool __fastcall GetEnabledEx(void);
	void __fastcall SetEnabledEx(const bool Value);
	void __fastcall SetEditAlign(const TEditAlign Value);
	void __fastcall SetCanUndo(const bool Value);
	Graphics::TColor __fastcall GetColorEx(void);
	void __fastcall SetColorEx(const Graphics::TColor Value);
	void __fastcall SetTransparent(const bool Value);
	void __fastcall SetFlatLineColor(const Graphics::TColor Value);
	void __fastcall SetFlatParentColor(const bool Value);
	void __fastcall LabelFontChange(System::TObject* Sender);
	void __fastcall SetLabelFont(const Graphics::TFont* Value);
	bool __fastcall GetError(void);
	void __fastcall SetError(const bool Value);
	bool __fastcall TestURL(void);
	void __fastcall ApplyURL(const bool Value);
	void __fastcall SetOleDropSource(const bool Value);
	void __fastcall SetOleDropTarget(const bool Value);
	void __fastcall SetAutoThousandSeparator(const bool Value);
	void __fastcall SetEmptyText(const System::AnsiString Value);
	void __fastcall SetSoftBorder(const bool Value);
	
protected:
	DYNAMIC void __fastcall Change(void);
	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);
	Stdctrls::TLabel* __fastcall CreateLabel(void);
	virtual void __fastcall Loaded(void);
	void __fastcall InvalidateCaret(const tagPOINT &pt);
	void __fastcall EraseCaret(void);
	void __fastcall DrawCaretByCursor(void);
	void __fastcall SetCaretByCursor(void);
	
public:
	__fastcall virtual TAdvEdit(Classes::TComponent* aOwner);
	__fastcall virtual ~TAdvEdit(void);
	virtual void __fastcall SetBounds(int ALeft, int ATop, int AWidth, int AHeight);
	HIDESBASE void __fastcall SelectAll(void);
	void __fastcall SelectBeforeDecimal(void);
	void __fastcall SelectAfterDecimal(void);
	int __fastcall CharFromPos(const tagPOINT &pt);
	tagPOINT __fastcall PosFromChar(Word uChar);
	__property double FloatValue = {read=GetFloat, write=SetFloat};
	__property int IntValue = {read=GetInt, write=SetInt, nodefault};
	__property bool Modified = {read=GetModified, write=SetModified, nodefault};
	__property bool IsError = {read=GetError, write=SetError, nodefault};
	bool __fastcall RangeStrToList(TRangeList* rangelist);
	void __fastcall ListToRangeStr(TRangeList* rangelist);
	void __fastcall LoadPersist(void);
	void __fastcall SavePersist(void);
	
__published:
	__property TValueValidateEvent OnValueValidate = {read=FOnValueValidate, write=FOnValueValidate};
	__property TClipboardEvent OnClipboardCopy = {read=FOnClipboardCopy, write=FOnClipboardCopy};
	__property TClipboardEvent OnClipboardCut = {read=FOnClipboardCut, write=FOnClipboardCut};
	__property TClipboardEvent OnClipboardPaste = {read=FOnClipboardPaste, write=FOnClipboardPaste};
	__property bool AutoFocus = {read=FAutoFocus, write=FAutoFocus, nodefault};
	__property bool AutoThousandSeparator = {read=FAutoThousandSeparator, write=SetAutoThousandSeparator
		, default=1};
	__property TEditAlign EditAlign = {read=FEditAlign, write=SetEditAlign, nodefault};
	__property TAdvEditType EditType = {read=FEditType, write=SetEditType, nodefault};
	__property System::AnsiString EmptyText = {read=FEmptyText, write=SetEmptyText};
	__property Graphics::TColor ErrorColor = {read=FErrorColor, write=FErrorColor, nodefault};
	__property Graphics::TColor ErrorFontColor = {read=FErrorFontColor, write=FErrorFontColor, nodefault
		};
	__property bool ExcelStyleDecimalSeparator = {read=FExcelStyleDecimalSeparator, write=FExcelStyleDecimalSeparator
		, nodefault};
	__property bool Flat = {read=FFlat, write=SetFlat, nodefault};
	__property Graphics::TColor FlatLineColor = {read=FFlatLineColor, write=SetFlatLineColor, nodefault
		};
	__property bool FlatParentColor = {read=FFlatParentColor, write=SetFlatParentColor, nodefault};
	__property TEditAlign FocusAlign = {read=FFocusAlign, write=FFocusAlign, nodefault};
	__property bool FocusBorder = {read=FFocusBorder, write=FFocusBorder, nodefault};
	__property Graphics::TColor FocusColor = {read=FFocusColor, write=FFocusColor, nodefault};
	__property Graphics::TColor FocusFontColor = {read=FFocusFontColor, write=FFocusFontColor, nodefault
		};
	__property bool FocusLabel = {read=FFocusLabel, write=FFocusLabel, nodefault};
	__property int FocusWidthInc = {read=FFocusWidthInc, write=FFocusWidthInc, nodefault};
	__property Graphics::TColor ModifiedColor = {read=FModifiedColor, write=FModifiedColor, nodefault};
		
	__property Graphics::TColor DisabledColor = {read=FDisabledColor, write=SetDisabledColor, nodefault
		};
	__property bool ShowError = {read=FShowError, write=FShowError, default=0};
	__property bool ShowModified = {read=FShowModified, write=FShowModified, default=0};
	__property bool ShowURL = {read=FShowURL, write=FShowURL, default=0};
	__property bool SoftBorder = {read=FSoftBorder, write=SetSoftBorder, default=0};
	__property Graphics::TColor URLColor = {read=FURLColor, write=FURLColor, nodefault};
	__property bool ReturnIsTab = {read=FReturnIsTab, write=FReturnIsTab, nodefault};
	__property short LengthLimit = {read=FLengthLimit, write=FLengthLimit, nodefault};
	__property bool TabOnFullLength = {read=FTabOnFullLength, write=FTabOnFullLength, nodefault};
	__property short Precision = {read=FPrecision, write=SetPrecision, nodefault};
	__property System::AnsiString Prefix = {read=FPrefix, write=SetPrefix};
	__property System::AnsiString Suffix = {read=FSuffix, write=SetSuffix};
	__property System::AnsiString LabelCaption = {read=GetLabelCaption, write=SetLabelCaption};
	__property TLabelPosition LabelPosition = {read=FLabelPosition, write=SetLabelPosition, nodefault};
		
	__property int LabelMargin = {read=FLabelMargin, write=SetLabelMargin, nodefault};
	__property bool LabelTransparent = {read=FLabelTransparent, write=SetLabelTransparent, nodefault};
	__property Graphics::TFont* LabelFont = {read=FLabelFont, write=SetLabelFont};
	__property TPersistence* Persistence = {read=FPersistence, write=FPersistence};
	__property AutoSelect ;
	__property AutoSize ;
	__property BorderStyle ;
	__property bool CanUndo = {read=FCanUndo, write=SetCanUndo, default=1};
	__property Graphics::TColor Color = {read=GetColorEx, write=SetColorEx, nodefault};
	__property Ctl3D ;
	__property DragCursor ;
	__property DragMode ;
	__property bool Enabled = {read=GetEnabledEx, write=SetEnabledEx, nodefault};
	__property Font ;
	__property HideSelection ;
	__property Hint ;
	__property bool HintShowLargeText = {read=FHintShowLargeText, write=FHintShowLargeText, nodefault};
		
	__property ImeMode ;
	__property ImeName ;
	__property MaxLength ;
	__property OEMConvert ;
	__property ParentColor ;
	__property ParentCtl3D ;
	__property ParentFont ;
	__property ParentShowHint ;
	__property PasswordChar ;
	__property bool OleDropTarget = {read=FOleDropTarget, write=SetOleDropTarget, nodefault};
	__property bool OleDropSource = {read=FOleDropSource, write=SetOleDropSource, nodefault};
	__property PopupMenu ;
	__property ReadOnly ;
	__property ShowHint ;
	__property bool Signed = {read=FSigned, write=FSigned, nodefault};
	__property TabOrder ;
	__property TabStop ;
	__property System::AnsiString Text = {read=GetText, write=SetText};
	__property bool Transparent = {read=FTransparent, write=SetTransparent, nodefault};
	__property bool Visible = {read=GetVisible, write=SetVisible, nodefault};
	__property OnChange ;
	__property OnClick ;
	__property OnDblClick ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDrag ;
	__property OnStartDrag ;
	__property OnEnter ;
	__property OnExit ;
	__property OnKeyDown ;
	__property OnKeyPress ;
	__property OnKeyUp ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
public:
	/* TWinControl.CreateParented */ __fastcall TAdvEdit(HWND ParentWindow) : Stdctrls::TCustomEdit(ParentWindow
		) { }
	
};

class DELPHICLASS TAdvMaskEdit;
class PASCALIMPLEMENTATION TAdvMaskEdit : public Mask::TMaskEdit 
{
	typedef Mask::TMaskEdit inherited;
	
private:
	Stdctrls::TLabel* FLabel;
	bool FAutoFocus;
	bool FAutoTab;
	bool FReturnIsTab;
	TAlignment FAlignment;
	Graphics::TColor FFocusColor;
	Graphics::TColor FFocusFontColor;
	Graphics::TColor FNormalColor;
	Graphics::TColor FFontColor;
	Graphics::TColor FModifiedColor;
	bool FShowModified;
	int FLabelMargin;
	TLabelPosition FLabelPosition;
	bool FLabelTransparent;
	bool FSelectFirstChar;
	bool FFlat;
	TMaskCompleteEvent FOnMaskComplete;
	Graphics::TColor FDisabledColor;
	System::AnsiString FOriginalValue;
	bool fCanUndo;
	void __fastcall SetAlignment(Classes::TAlignment value);
	HIDESBASE MESSAGE void __fastcall CMFontChanged(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMKillFocus(Messages::TWMKillFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall CMMouseEnter(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall WMPaint(Messages::TWMPaint &Msg);
	HIDESBASE MESSAGE void __fastcall WMKeyDown(Messages::TWMKey &Msg);
	System::AnsiString __fastcall GetLabelCaption();
	void __fastcall SetLabelCaption(const System::AnsiString Value);
	void __fastcall SetLabelMargin(const int Value);
	void __fastcall SetLabelPosition(const TLabelPosition Value);
	void __fastcall UpdateLabel(void);
	void __fastcall SetFlat(const bool Value);
	HIDESBASE bool __fastcall GetModified(void);
	HIDESBASE void __fastcall SetModified(const bool Value);
	void __fastcall SetLabelTransparent(const bool Value);
	void __fastcall SetDisabledColor(const Graphics::TColor Value);
	bool __fastcall GetEnabledEx(void);
	void __fastcall SetEnabledEx(const bool Value);
	Graphics::TColor __fastcall GetColorEx(void);
	void __fastcall SetColorEx(const Graphics::TColor Value);
	
protected:
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall DoEnter(void);
	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);
	Stdctrls::TLabel* __fastcall CreateLabel(void);
	
public:
	__fastcall virtual TAdvMaskEdit(Classes::TComponent* AOwner);
	virtual void __fastcall SetBounds(int ALeft, int ATop, int AWidth, int AHeight);
	__fastcall virtual ~TAdvMaskEdit(void);
	__property bool Modified = {read=GetModified, write=SetModified, nodefault};
	virtual void __fastcall Loaded(void);
	
__published:
	__property bool AutoFocus = {read=FAutoFocus, write=FAutoFocus, nodefault};
	__property bool AutoTab = {read=FAutoTab, write=FAutoTab, default=1};
	__property bool CanUndo = {read=fCanUndo, write=fCanUndo, default=0};
	__property Graphics::TColor Color = {read=GetColorEx, write=SetColorEx, nodefault};
	__property Graphics::TColor DisabledColor = {read=FDisabledColor, write=SetDisabledColor, nodefault
		};
	__property bool Enabled = {read=GetEnabledEx, write=SetEnabledEx, nodefault};
	__property bool Flat = {read=FFlat, write=SetFlat, nodefault};
	__property bool ShowModified = {read=FShowModified, write=FShowModified, nodefault};
	__property Graphics::TColor FocusColor = {read=FFocusColor, write=FFocusColor, nodefault};
	__property Graphics::TColor FocusFontColor = {read=FFocusFontColor, write=FFocusFontColor, nodefault
		};
	__property System::AnsiString LabelCaption = {read=GetLabelCaption, write=SetLabelCaption};
	__property TLabelPosition LabelPosition = {read=FLabelPosition, write=SetLabelPosition, nodefault};
		
	__property int LabelMargin = {read=FLabelMargin, write=SetLabelMargin, nodefault};
	__property bool LabelTransparent = {read=FLabelTransparent, write=SetLabelTransparent, nodefault};
	__property Graphics::TColor ModifiedColor = {read=FModifiedColor, write=FModifiedColor, nodefault};
		
	__property bool ReturnIsTab = {read=FReturnIsTab, write=FReturnIsTab, default=1};
	__property Classes::TAlignment Alignement = {read=FAlignment, write=SetAlignment, default=0};
	__property bool SelectFirstChar = {read=FSelectFirstChar, write=FSelectFirstChar, nodefault};
	__property TMaskCompleteEvent OnMaskComplete = {read=FOnMaskComplete, write=FOnMaskComplete};
public:
		
	/* TWinControl.CreateParented */ __fastcall TAdvMaskEdit(HWND ParentWindow) : Mask::TMaskEdit(ParentWindow
		) { }
	
};

struct TQueryParams;
typedef TQueryParams *PQueryParams;

struct TQueryParams
{
	int Precision;
	bool Flat;
	int Lengthlimit;
	System::AnsiString Prefix;
	System::AnsiString Suffix;
} ;

class DELPHICLASS TEditDropTarget;
class PASCALIMPLEMENTATION TEditDropTarget : public Adveddd::TAEDropTarget 
{
	typedef Adveddd::TAEDropTarget inherited;
	
private:
	TAdvEdit* FAdvEdit;
	
public:
	__fastcall TEditDropTarget(TAdvEdit* aEdit);
	virtual void __fastcall DropText(const tagPOINT &pt, System::AnsiString s);
	virtual void __fastcall DragMouseMove(const tagPOINT &pt, bool &allow);
public:
	/* TInterfacedObject.Destroy */ __fastcall virtual ~TEditDropTarget(void) { }
	
};

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE int BorderRec[2];
extern PACKAGE bool __fastcall AdvInputQuery(const TAdvEditType QueryType, PQueryParams QueryParams, 
	const System::AnsiString ACaption, const System::AnsiString APrompt, System::AnsiString &Value);

}	/* namespace Advedit */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Advedit;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// AdvEdit
