unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, AdCalc;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Edit2: TEdit;
    AdCalc1: TAdCalc;
    ComboBox1: TComboBox;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AdCalc1GetBooleanVar(Sender: TObject; VarName: String;
      var Found, Value: Boolean);
    procedure AdCalc1GetExtendedVar(Sender: TObject; VarName: String;
      var Found: Boolean; var Value: Extended);
    procedure AdCalc1Error(Sender: TObject; ErrorCode, ErrorPosition: Word;
      ErrorStr: String);
    procedure AdCalc1GetExtendedFunct(Sender: TObject; FunctName: String;
      var Found: Boolean; var Value: Extended);
    procedure AdCalc1GetBooleanFunct(Sender: TObject; FunctName: String;
      var Found, Value: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
  n:Extended;
begin
  AdCalc1.Formula:=Edit1.Text;
  ActiveControl:=Edit1;
  if AdCalc1.calculate(n) then begin
    Label1.Caption:='Result= '+FloatToStr(n);
    Edit1.SelectAll;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ActiveControl:=Edit1;
  ComboBox1.ItemIndex:=0;
  AdCalc1.DefExtendedFunct('Max',[expExtended,expExtended]);
  AdCalc1.DefBooleanFunct('IsEqual',[expExtended,expExtended]);
end;

procedure TForm1.AdCalc1GetBooleanVar(Sender: TObject; VarName: String;
  var Found, Value: Boolean);
begin
  if VarName=LowerCase('MyBooleanVar') then begin
    Found:=true;
    if LowerCase(ComboBox1.Text)='true' then
      Value:=true
    else Value:=false;
  end;
end;

procedure TForm1.AdCalc1GetExtendedVar(Sender: TObject; VarName: String;
  var Found: Boolean; var Value: Extended);
begin
  if VarName=LowerCase('MyExtendedVar') then begin
    Found:=true;
    Value:=StrToFloat(Edit2.Text);
  end;
end;

procedure TForm1.AdCalc1Error(Sender: TObject; ErrorCode,
  ErrorPosition: Word; ErrorStr: String);
begin
  Label1.Caption:='Error '+IntToStr(ErrorCode)+
    ' - '+ErrorStr;
  Edit1.SelStart:=ErrorPosition;
end;

procedure TForm1.AdCalc1GetExtendedFunct(Sender: TObject;
  FunctName: String; var Found: Boolean; var Value: Extended);
begin
  if FunctName=LowerCase('Max') then with AdCalc1 do begin
    Found:=true;
    if extended(GetParam(1)^)>extended(GetParam(2)^) then
      Value:=extended(GetParam(1)^)
    else Value:=extended(GetParam(2)^);
  end;
end;

procedure TForm1.AdCalc1GetBooleanFunct(Sender: TObject; FunctName: String;
  var Found, Value: Boolean);
begin
  if FunctName=LowerCase('IsEqual') then with AdCalc1 do begin
    Found:=true;
    if extended(GetParam(1)^)=extended(GetParam(2)^) then
      Value:=true else Value:=false;
  end;
end;

end.
 