{
    :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    ::                                                         ::
    ::                                                         ::
    ::   Copyright (C) 1997-1999, Legitima Software            ::
    ::   All Rights Reserved.                                  ::
    ::   http://www.legitima.com                               ::
    ::                                                         ::
    ::   This example, get information from a HTML file        ::
    ::   like the hyperlinks, images and fonts.                ::
    ::                                                         ::
    :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
    StdCtrls, hpReg;

type
  TForm1 = class (TForm)
    Button1        : TButton;
    OpenDialog1    : TOpenDialog;
    Links          : TListBox;
    Label1         : TLabel;
    Fonts          : TListBox;
    Label2         : TLabel;
    Pictures       : TListBox;
    Label3         : TLabel;
    lbFilename     : TLabel;
    LegHtmlParser1 : TLegHtmlParser;
    Meta: TListBox;
    Label4: TLabel;
    procedure Button1Click (Sender: TObject);
    procedure FormCreate (Sender: TObject);
    procedure LegHtmlParser1Tag (Sender: TObject; HtmlTag: String; Attributes:
      TStringList);
  private

    { Private declarations }
    public
    { Public declarations }

  end;

var
  Form1 : TForm1;

implementation 

{$R *.DFM} 
procedure TForm1.Button1Click (Sender: TObject); 
begin 
  OpenDialog1.Filename := ''; 
  if OpenDialog1.Execute then 
    begin 
      Links.Items.BeginUpdate; 
      Fonts.Items.BeginUpdate; 
      Pictures.Items.BeginUpdate; 
      Links.clear; 
      Fonts.clear; 
      Pictures.clear; 
      lbFilename.Caption := 'Info for ' + OpenDialog1.Filename; 
      LegHtmlParser1.Content.LoadFromFile (OpenDialog1.Filename); 
      screen.cursor := crHourGlass; 
      LegHtmlParser1.Parse; 
      Links.Items.EndUpdate; 
      Fonts.Items.EndUpdate; 
      Pictures.Items.EndUpdate; 
      screen.cursor := crDefault 
    end 
end; 


procedure TForm1.FormCreate (Sender: TObject); 
begin 
  lbFilename.Caption := '' 
end; 


procedure TForm1.LegHtmlParser1Tag (Sender: TObject; HtmlTag: String; Attributes
  : TStringList); 
begin 
  if (CompareText (HtmlTag, 'img') = 0) then 
    begin 
      if (Pictures.Items.IndexOf (Attributes.Values['src']) = -1) then 
        Pictures.Items.add (Attributes.Values['src']) 
    end 
  else 
  if (CompareText (HtmlTag, 'font') = 0) then 
    begin 
      if (Attributes.Values['face'] <> '') 
          and 
         (Fonts.Items.IndexOf (Attributes.Values['face']) = -1) then 
        Fonts.Items.add (Attributes.Values['face'])
    end 
  else 
  if (CompareText (HtmlTag, 'a') = 0) then 
    begin 
      if ((Attributes.Values['href'] <> '') 
           and 
          (Links.Items.IndexOf (Attributes.Values['href']) = -1)) then 
        Links.Items.add (Attributes.Values['href'])
    end
  else
  if CompareText(HtmlTag,'meta') = 0 then
    begin
      if Attributes.Values['http-equiv'] <> '' then
        Meta.Items.add (Format('HTTP-EQUIV: %s = "%s"',
          [Attributes.Values['http-equiv'],Attributes.Values['content']]))
      else if Attributes.Values['name'] <> '' then
        Meta.Items.add (Format('NAME: %s = "%s"',
          [Attributes.Values['name'],Attributes.Values['content']]))
    end;
    
end; 


end. 
