{
    :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    ::                                                         ::
    ::                                                         ::
    ::   Copyright (C) 1997-1999, Legitima Software            ::
    ::   All Rights Reserved.                                  ::
    ::   http://www.legitima.com                               ::
    ::                                                         ::
    ::                                                         ::
    ::   This example filters a HTML document changing every   ::
    ::   link to "mailto:info@legitima.com and changes the     ::
    ::   font color to RED                                     ::
    ::                                                         ::
    :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
    ShellApi, StdCtrls, hpReg;

type
  TForm1 = class (TForm)
    Memo1          : TMemo;
    Memo2          : TMemo;
    Button1        : TButton;
    Label1         : TLabel;
    Label2         : TLabel;
    Label3         : TLabel;
    Button2        : TButton;
    Button3        : TButton;
    OpenDialog1    : TOpenDialog;
    LegHtmlParser1 : TLegHtmlParser;
    procedure Button1Click (Sender: TObject);
    procedure Button2Click (Sender: TObject);
    procedure Button3Click (Sender: TObject);
    procedure LegHtmlParser1Comment (Sender: TObject; Token: String);
    procedure LegHtmlParser1DTDTag (Sender: TObject; Token: String);
    procedure LegHtmlParser1Script (Sender: TObject; Token: String);
    procedure LegHtmlParser1Text (Sender: TObject; Token: String);
    procedure LegHtmlParser1Tag (Sender: TObject; HtmlTag: String; Attributes:
      TStringList);
  private
    { Private declarations }
    CurrentFile : String;
  public
    { Public declarations }

  end;

var
  Form1 : TForm1;

implementation

{$R *.DFM}
procedure TForm1.Button1Click (Sender: TObject);
begin
  OpenDialog1.Filename := '';
  if OpenDialog1.Execute then
    begin
      CurrentFile := OpenDialog1.Filename;
      LegHtmlParser1.Content.LoadFromFile (OpenDialog1.Filename);
      Memo1.lines.Assign (LegHtmlParser1.Content);
      Memo2.lines.BeginUpdate;
      Memo2.lines.clear;
      screen.cursor := crHourGlass;
      LegHtmlParser1.Parse;
      Memo2.lines.EndUpdate;
      screen.cursor := crDefault
    end
end;


procedure TForm1.Button2Click (Sender: TObject);
begin
  ShellExecute (GetDesktopWindow, 'open', PChar (CurrentFile), nil, nil,
    SW_SHOWNORMAL)
end;


procedure TForm1.Button3Click (Sender: TObject);
var
  TempFilename : String;
begin
  TempFilename := ExtractFilePath (Application.Exename) + 'temp.htm';
  Memo2.lines.SaveToFile (TempFilename);
  ShellExecute (GetDesktopWindow, 'open', PChar (TempFilename), nil, nil,
    SW_SHOWNORMAL)
end;


procedure TForm1.LegHtmlParser1Comment (Sender: TObject; Token: String);
begin
  Memo2.lines.add ('<!-- ' + Token + ' -->')
end;


procedure TForm1.LegHtmlParser1DTDTag (Sender: TObject; Token: String);
begin
  Memo2.lines.add ('<!' + Token + '>')
end;


procedure TForm1.LegHtmlParser1Script (Sender: TObject; Token: String);
begin
  Memo2.lines.add (Token)
end;


procedure TForm1.LegHtmlParser1Text (Sender: TObject; Token: String);
begin
  Memo2.lines.add (Token)
end;


procedure TForm1.LegHtmlParser1Tag (Sender: TObject; HtmlTag: String; Attributes
  : TStringList);
var
  i   : Integer;
  Str : String;
begin

  if CompareText (HtmlTag, 'font') = 0 then   // Is a Font tag?
    Attributes.Values['color'] := '#ff0000';  // Then change the color to red

  if Attributes.Values['href'] <> '' then     // The tag has a HREF attribute?
    Attributes.Values['href'] := 'mailto:info@legitima.com'; // then change it

// let's reassemble the tag
  Str := HtmlTag;
  if Attributes.count > 0 then 
    Str := Str + ' ' + Attributes.Names[0] + '="' + Attributes.Values[Attributes.Names[0]] + '"'; 
  for i := 1 to Attributes.count - 1 do 
    Str := Str + ' ' + Attributes.Names[i] + '="' + Attributes.Values[Attributes.Names[i]] + '"'; 
  Memo2.lines.add ('<' + Str + '>')
end; 


end. 
