{
    :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    ::                                                         ::
    ::                                                         ::
    ::   Copyright (C) 1997-1999, Legitima Software            ::
    ::   All Rights Reserved.                                  ::
    ::   http://www.legitima.com                               ::
    ::                                                         ::
    ::                                                         ::
    ::   This example shows syntax errors and how to implement ::
    ::   the OnError event                                     ::
    ::                                                         ::
    :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, hpReg;

type
  TForm1 = class(TForm)
    RichEdit1: TRichEdit;
    ErrorList: TMemo;
    Button1: TButton;
    LegHtmlParser1: TLegHtmlParser;
    procedure Button1Click(Sender: TObject);
    procedure LegHtmlParser1Error(Sender: TObject; Error,
      PosError: Integer; var Abort: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  ErrorList.Lines.Clear;
  LegHtmlParser1.Content.Assign(RichEdit1.Lines);
  LegHtmlParser1.Parse;
end;

procedure TForm1.LegHtmlParser1Error(Sender: TObject; Error,
  PosError: Integer; var Abort: Boolean);
begin
  case Error of
    1: ErrorList.Lines.Add('Unfinished block. Expected ">", but found EOF instead');
    2: ErrorList.Lines.Add('Unfinished comment. Expected  "-->", but found EOF instead');
    3: ErrorList.Lines.Add('Unfinished comment. Expected  ">" after "--"');
    4: ErrorList.Lines.Add('Nested "<"');
    5: ErrorList.Lines.Add('Found ">" not preceded by "<"');
    6: ErrorList.Lines.Add('Unfinished script. Expected "</SCRIPT>", but found EOF instead');
  end;
  ErrorList.Lines.Add(Format('  at the absolute position %d',[PosError]));
  ErrorList.Lines.Add('');

// colorizes the error
  RichEdit1.SelStart := PosError-1;
  RichEdit1.SelLength := 1;
  RichEdit1.SelAttributes.Color := clRed;
  RichEdit1.SelAttributes.Style := [fsBold,fsUnderline];
end;

end.
 