{
    :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    ::                                                         ::
    ::   Copyright (C) 1997-1999, Legitima Software            ::
    ::   All Rights Reserved.                                  ::
    ::   http://www.legitima.com                               ::
    ::                                                         ::
    ::   This example colorizes all the tokens from a          ::
    ::   HTML file                                             ::
    ::                                                         ::
    :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
    ComCtrls, ExtCtrls, StdCtrls, hpReg;

type
  TForm1 = class (TForm)
    RichEdit1      : TRichEdit;
    Panel1         : TPanel;
    StatusBar1     : TStatusBar;
    Button1        : TButton;
    OpenDialog1    : TOpenDialog;
    cbTranslate    : TCheckBox;
    cbNormalize    : TCheckBox;
    chIndent       : TCheckBox;
    LegHtmlParser1 : TLegHtmlParser;
    procedure Button1Click (Sender: TObject);
    procedure LegHtmlParser1Comment (Sender: TObject; Token: String);
    procedure LegHtmlParser1Script (Sender: TObject; Token: String);
    procedure LegHtmlParser1DTDTag (Sender: TObject; Token: String);
    procedure LegHtmlParser1Tag (Sender: TObject; HtmlTag: String; Attributes:
      TStringList);
    procedure LegHtmlParser1Text (Sender: TObject; Token: String);
  private
    { Private declarations }
    IndentSpace : Integer;
    CommCount   : Integer;
    TextCount   : Integer;
    ScriptCount : Integer;
    TagCount    : Integer;
    function Spaces (N: Integer) : String;
    procedure DrawText (Text: String; Color: TColor);
  public
    { Public declarations }

  end;

var
  Form1 : TForm1;

implementation

{$R *.DFM}
function TForm1.Spaces (N: Integer) : String;
begin
  Result := '';
  while N > 0 do
    begin
      Result := Result + ' ';
      dec (N)
    end
end;


procedure TForm1.DrawText (Text: String; Color: TColor);
var
  i,
  j : Integer;
begin
  i := RichEdit1.SelStart;
  RichEdit1.lines.add (Text);
  j := RichEdit1.SelStart;
  RichEdit1.SelStart := i;
  RichEdit1.SelLength := length (Text);
  RichEdit1.SelAttributes.Color := Color;
  RichEdit1.SelStart := j;
  RichEdit1.SelLength := 0;
  RichEdit1.Font.Color := clBlack
end;


procedure TForm1.Button1Click (Sender: TObject);
begin
  OpenDialog1.Filename := '';
  if OpenDialog1.Execute then
    begin
      CommCount := 0;
      TextCount := 0;
      ScriptCount := 0;
      TagCount := 0;
      IndentSpace := 0;
      LegHtmlParser1.Content.LoadFromFile (OpenDialog1.Filename);
      screen.cursor := crHourGlass;
      RichEdit1.lines.BeginUpdate;
      RichEdit1.lines.clear;
      LegHtmlParser1.Translate := cbTranslate.Checked;
      LegHtmlParser1.Normalize := cbNormalize.Checked;
      LegHtmlParser1.Parse;
      RichEdit1.lines.EndUpdate;
      screen.cursor := crDefault;
      StatusBar1.Panels[0].Text := Format ('HTML Tags: %d', [TagCount]);
      StatusBar1.Panels[1].Text := Format ('Text Blocks: %d', [TextCount]);
      StatusBar1.Panels[2].Text := Format ('Comment Blocks: %d', [CommCount]);
      StatusBar1.Panels[3].Text := Format ('Script Blocks: %d', [ScriptCount])
    end
end;


procedure TForm1.LegHtmlParser1Comment (Sender: TObject; Token: String);
begin
  inc (CommCount);
  DrawText ('<!-- ' + Token + ' -->', clGreen)
end;


procedure TForm1.LegHtmlParser1Script (Sender: TObject; Token: String);
begin
  inc (ScriptCount);
  DrawText (Token, clFuchsia)
end;


procedure TForm1.LegHtmlParser1DTDTag (Sender: TObject; Token: String);
begin
  DrawText ('<!' + Token + '>', clMaroon)
end;


procedure TForm1.LegHtmlParser1Tag (Sender: TObject; HtmlTag: String; Attributes:
  TStringList);
var
  i,
  j  : Integer;
  st : string;
begin
  inc (TagCount);
  st := Spaces (IndentSpace) + '<' + HtmlTag; 
  if Attributes.count > 0 then 
    st := st + ' ' + Attributes.Names[0] + '="' + Attributes.Values[Attributes.Names[0]] + '"'; 
  for i := 1 to Attributes.count - 1 do 
    st := st + ' ' + Attributes.Names[i] + '="' + Attributes.Values[Attributes.Names[i]] + '"'; 
  i := RichEdit1.SelStart + 1 + IndentSpace; 
  RichEdit1.lines.add (st + '>'); 
  j := RichEdit1.SelStart; 
  RichEdit1.SelStart := i; 
  RichEdit1.SelLength := length (HtmlTag); 
  RichEdit1.SelAttributes.Color := clPurple; 
  RichEdit1.SelStart := RichEdit1.SelStart + length (HtmlTag) + 1; 
  for i := 0 to Attributes.count - 1 do 
    begin 
      RichEdit1.SelLength := length (Attributes.Names[i]); 
      RichEdit1.SelAttributes.Color := clRed; 
      RichEdit1.SelStart := RichEdit1.SelStart + length (Attributes.Names[i]) + 1; 
      RichEdit1.SelLength := length (Attributes.Values[Attributes.Names[i]]) + 2; 
      RichEdit1.SelAttributes.Color := clBlue; 
      RichEdit1.SelStart := RichEdit1.SelStart + length (Attributes.Values[Attributes.Names[i]]) + 3
    end; 
  RichEdit1.SelStart := j; 
  RichEdit1.SelLength := 0; 
  RichEdit1.Font.Color := clBlack; 
  if chIndent.Checked 
      and 
     ((CompareText (HtmlTag, 'table') = 0) 
       or 
      (CompareText (HtmlTag, 'tr') = 0)) then 
    inc (IndentSpace, 2); 
  if chIndent.Checked 
      and 
     ((CompareText (HtmlTag, '/table') = 0) 
       or 
      (CompareText (HtmlTag, '/tr') = 0)) then 
    dec (IndentSpace, 2) 
end; 


procedure TForm1.LegHtmlParser1Text (Sender: TObject; Token: String); 
begin 
  inc (TextCount); 
  DrawText (Token, clBlack) 
end; 


end. 
