{
    :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    ::                                                         ::
    ::                                                         ::
    ::   Copyright (C) 1997-1999, Legitima Software            ::
    ::   All Rights Reserved.                                  ::
    ::   http://www.legitima.com                               ::
    ::                                                         ::
    ::                                                         ::
    ::   This example shows a HTML file as plain text          ::
    ::                                                         ::
    :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
    StdCtrls, ExtCtrls, hpReg;

type
  TForm1 = class (TForm)
    Panel1         : TPanel;
    Button1        : TButton;
    OpenDialog1    : TOpenDialog;
    Memo1          : TMemo;
    LegHtmlParser1 : TLegHtmlParser;
    procedure Button1Click (Sender: TObject);
    procedure LegHtmlParser1Text (Sender: TObject; Token: String);
    procedure LegHtmlParser1Tag (Sender: TObject; HtmlTag: String; Attributes:
      TStringList);
  private
    { Private declarations }
    CanBreak : boolean;
  public
    { Public declarations }

  end;

var
  Form1 : TForm1;

implementation 

{$R *.DFM} 
procedure TForm1.Button1Click (Sender: TObject); 
begin 
  OpenDialog1.Filename := ''; 
  if OpenDialog1.Execute then 
    begin 
      LegHtmlParser1.Content.LoadFromFile (OpenDialog1.Filename); 
      screen.cursor := crHourGlass; 
      Memo1.lines.BeginUpdate; 
      Memo1.lines.clear; 
      CanBreak := false; 
      LegHtmlParser1.Parse; 
      Memo1.lines.EndUpdate; 
      screen.cursor := crDefault 
    end 
end; 


procedure TForm1.LegHtmlParser1Text (Sender: TObject; Token: String); 
begin 
  if Token <> #160 then 
    begin 
      Memo1.Text := Memo1.Text + Token + ' '; 
      CanBreak := true 
    end 
end; 


procedure TForm1.LegHtmlParser1Tag (Sender: TObject; HtmlTag: String; Attributes: 
  TStringList); 
begin 
  if ((CompareText (HtmlTag, 'br') = 0) 
       or 
      (CompareText (HtmlTag, 'p') = 0) 
       or 
      (CompareText (HtmlTag, '/p') = 0) 
       or 
      (CompareText (Copy (HtmlTag, 1, 1), 'h') = 0) 
       or 
      (CompareText (Copy (HtmlTag, 1, 2), '/h') = 0)) 
      and 
     CanBreak then 
    begin 
      Memo1.lines.add (''); 
      Memo1.lines.add (''); 
      CanBreak := false 
    end 
end; 


end. 
