// By:    practicalsoft@usa.net
//        http://practicalsoft.hypermart.net/shareware/delphi/tarraybitmap.html
// Desc:  Test app for TArrayBitmap Shareware.
//        Delphi 3/4 class for high speed access to bitmap pixels.
//        Read readme.txt for details.


unit testArrayBitmap;

interface
                                      
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ArrayBitmap, ExtCtrls, ComCtrls, Buttons;

type
  TForm_test = class(TForm)
    Timer1: TTimer;
    button_blur: TButton;
    TrackBar1: TTrackBar;
    TrackBar3: TTrackBar;
    CheckBox1: TCheckBox;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure button_blurClick(Sender: TObject);
    procedure Button_blendClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
    t, t2 : TArrayBitmap;
    alphaBmp : TArrayBitmap;
    backBuffer : TArrayBitmap;
  public
    { Public declarations }
  end;

var
  Form_test: TForm_test;

implementation

{$R *.DFM}


// Here's the static screen effect
procedure TForm_test.Button1Click(Sender: TObject);
var c : TRGBTriple;
		w : integer;
    x, y : integer;
begin
  for w := 0 to 10000 do begin
  	x := random(t.width);
    y := random(t.height);
  	c.rgbtBlue := random(256);
  	c.rgbtRed := random(256);
  	c.rgbtGreen := random(256);
  	backBuffer.bits[x, y] := c;
  end;

  canvas.CopyRect(canvas.clipRect, backBuffer.canvas, backBuffer.canvas.clipRect);
end;



procedure TForm_test.FormCreate(Sender: TObject);
begin
	t := TArrayBitmap.create;
  if fileExists('landscape.bmp') then
    t.loadFromFile('landscape.bmp')
  else
    t.loadFromFile('..\landscape.bmp');

  //t.PixelFormat := pf24bit;  //dont't need this anymore. Set automatically.

  t2 := TArrayBitmap.create;
  if fileExists('leafs.bmp') then
    t2.loadFromFile('leafs.bmp')
  else
    t2.loadFromFile('..\leafs.bmp');
  //t2.PixelFormat := pf24bit;  //dont't need this anymore. Set automatically.

  backBuffer := TArrayBitmap.create;
  if fileExists('landscape.bmp') then
    backBuffer.loadFromFile('landscape.bmp')
  else
    backBuffer.loadFromFile('..\landscape.bmp');
  //backBuffer.PixelFormat := pf24bit;  //dont't need this anymore. Set automatically.

  alphaBmp := TArrayBitmap.create;
  if fileExists('lens.bmp') then
    alphaBmp.loadFromFile('lens.bmp')
  else
    alphaBmp.loadFromFile('..\lens.bmp');
  //alphaBmp.PixelFormat := pf24bit; //dont't need this anymore. Set automatically.
end;

procedure TForm_test.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	t.free;
  t2.free;
  backBuffer.FreeImage;
end;


//Here's a simple blur
procedure TForm_test.button_blurClick(Sender: TObject);
const FRAME = 1;
var c : TRGBTriple;
    x, y : integer;
begin
  // blur
  for x := 0+FRAME to t.width-1-FRAME do
    for y := 0+FRAME to t.height-1-FRAME do begin
      c.rgbtRed := (backBuffer.bits[x-1, y].rgbtRed+backBuffer.bits[x, y].rgbtRed+t.bits[x+1, y].rgbtRed+backBuffer.bits[x, y-1].rgbtRed+t.bits[x, y+1].rgbtRed) div 5;
      c.rgbtGreen := (backBuffer.bits[x-1, y].rgbtGreen+backBuffer.bits[x, y].rgbtGreen+backBuffer.bits[x+1, y].rgbtGreen+t.bits[x, y-1].rgbtGreen+t.bits[x, y+1].rgbtGreen) div 5;
      c.rgbtBlue := (backBuffer.bits[x-1, y].rgbtBlue+t.bits[x, y].rgbtBlue+backBuffer.bits[x+1, y].rgbtBlue+backBuffer.bits[x, y-1].rgbtBlue+t.bits[x, y+1].rgbtBlue) div 5;
      backBuffer.bits[x, y] := c;
    end;

  canvas.CopyRect(canvas.clipRect, backBuffer.canvas, t.canvas.clipRect);
end;


//Blends images t and t2
procedure TForm_test.Button_blendClick(Sender: TObject);
var c : TRGBTriple;
    x, y : integer;
    dimWidth, dimHeight : integer;
    val : integer;
begin
  // blend
  if t2.width > t.width then
    dimWidth := t.width-1
  else
    dimWidth := t2.width-1;
  if t2.height > t.height then
    dimHeight := t.height-1
  else
    dimHeight := t2.height-1;

  for x := 0 to dimWidth do
    for y := 0 to dimHeight do begin
      val := TTrackBar(Sender).Position;
      c.rgbtRed := trunc (val/100*t2.bits[x,y].rgbtRed + (100-val)/100*t.bits[x,y].rgbtRed);
      c.rgbtGreen := trunc (val/100*t2.bits[x,y].rgbtGreen + (100-val)/100*t.bits[x,y].rgbtGreen);
      c.rgbtBlue := trunc (val/100*t2.bits[x,y].rgbtBlue + (100-val)/100*t.bits[x,y].rgbtBlue);
      backBuffer.bits[x, y] := c;
    end;

  canvas.CopyRect(canvas.clipRect, backBuffer.canvas, t.canvas.clipRect);
end;


procedure TForm_test.FormPaint(Sender: TObject);
begin
  canvas.CopyRect(canvas.clipRect, backBuffer.canvas, backBuffer.canvas.clipRect);
end;


//Here's a simple fade to a custom color
procedure TForm_test.TrackBar2Change(Sender: TObject);
var c, targetColor : TRGBTriple;
    x, y : integer;
    val : integer;
begin
  // fade
  targetColor.rgbtBlue := 200;
  targetColor.rgbtGreen := 255;
  targetColor.rgbtRed := 200;
  for x := 0 to t.width-1 do
    for y := 0 to t.height-1 do begin
      val := TTrackBar(Sender).Position;
      c.rgbtRed := trunc (val/100*t.bits[x,y].rgbtRed + (100-val)/100*targetColor.rgbtRed);
      c.rgbtGreen := trunc (val/100*t.bits[x,y].rgbtGreen + (100-val)/100*targetColor.rgbtGreen);
      c.rgbtBlue := trunc (val/100*t.bits[x,y].rgbtBlue + (100-val)/100*targetColor.rgbtBlue);
      backBuffer.bits[x, y] := c;
    end;

  canvas.CopyRect(canvas.clipRect, backBuffer.canvas, t.canvas.clipRect);
end;


procedure TForm_test.CheckBox1Click(Sender: TObject);
begin
  timer1.Enabled := CheckBox1.Checked;
end;


//Here's a light effect
procedure TForm_test.Button2Click(Sender: TObject);
var x, y : integer;
		rgb : TRGBTriple;
    alfaChannel : integer;
    lft, tp : integer;
begin
  lft := random(t.width-alphaBmp.width);
  tp := random(t.height-alphaBmp.height);
	for y := 0 to alphaBmp.height-1 do
  	for x := 0 to alphaBmp.width-1 do begin
      rgb := backBuffer.bits[x+lft, y+tp];
      alfaChannel := alphaBmp.bits[x,y].rgbtBlue;
      rgb.rgbtBlue := trunc(rgb.rgbtBlue + (255-rgb.rgbtBlue)*alfaChannel/255);
      alfaChannel := alphaBmp.bits[x,y].rgbtRed;
      rgb.rgbtRed := trunc(rgb.rgbtRed + (255-rgb.rgbtRed)*alfaChannel/255);
      alfaChannel := alphaBmp.bits[x,y].rgbtGreen;
      rgb.rgbtGreen := trunc(rgb.rgbtGreen + (255-rgb.rgbtGreen)*alfaChannel/255);

      backBuffer.bits[x+lft, y+tp] := rgb;
    end;
  canvas.CopyRect(canvas.clipRect, backBuffer.canvas, t.canvas.clipRect);
end;


end.
