unit MainModule1;

interface

uses
  Windows, Messages, SysUtils, Classes, HTTPApp, WebTracker;

type
  TWebModule1 = class(TWebModule)
    ppCheckProfile: TPageProducer;
    ppViewProfile: TPageProducer;
    procedure WebModule1Create(Sender: TObject);
    procedure WebModule1AfterDispatch(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule1BeforeDispatch(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule1Destroy(Sender: TObject);
    procedure WebModule1waLoginAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule1waViewProfileAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure ppViewProfileHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
  private
    { Private declarations }
  public
    { Public declarations }
    WebSession : TWebSession;
  end;

var
  WebModule1: TWebModule1;

implementation

{$R *.DFM}

type
  TUserProfile = class(TObject)
    UserId : string;
    Password : string;
    IPAddress : string;
    end;

procedure TWebModule1.WebModule1Create(Sender: TObject);
begin
  WebSession := nil;
end;

procedure TWebModule1.WebModule1Destroy(Sender: TObject);
begin
  if Assigned(WebSession) then
    WebSession.Free;
end;

procedure TWebModule1.WebModule1AfterDispatch(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  if Assigned(WebSession) then
    WebTracker.SaveWebSession(WebSession, Response);
end;

procedure TWebModule1.WebModule1BeforeDispatch(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  try
    if Request.PathInfo <> '/Login' then
      WebSession := WebTracker.FindWebSession(Request);
  except
    on EUnknownWebSessionError do
      begin
      Response.Content := 'Error:  Unknown WebSession.';
      Handled := true;
      end;
    on EExpiredWebSessionError do
      begin
      Response.Content := 'Error:  WebSession has expired.';
      Handled := true;
      end;
    end;
end;

procedure TWebModule1.WebModule1waLoginAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  UserId, Password : string;
  UserProfile : TUserProfile;
begin
  UserId := Request.ContentFields.Values['UserId'];
  Password := Request.ContentFields.Values['Password'];

  { ... Validate the User ... }

  {create a web user object to track this user}
  WebSession := TWebSession.Create;

  {create some data to track with this WebSession}
  UserProfile := TUserProfile.Create;
  UserProfile.UserId := UserId;
  UserProfile.Password := Password;
  UserProfile.IPAddress := Request.RemoteAddr;
  WebSession.AddData('Profile', UserProfile);

  Response.Content := ppCheckProfile.Content;
  Handled := true;
end;

procedure TWebModule1.WebModule1waViewProfileAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  Response.Content := ppViewProfile.Content;
  Handled := true;
end;

procedure TWebModule1.ppViewProfileHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
var
  UserProfile : TUserProfile;
begin
  if TagString = 'UserProfile' then
    begin
    UserProfile := TUserProfile(WebSession.GetData('Profile'));
    ReplaceText := 'User Id = ' + UserProfile.UserId + '<BR>' +
                   'Password = ' + UserProfile.Password + '<BR>' +
                   'IP Address = ' + UserProfile.IPAddress + '<BR>';
    end;
end;

end.
