unit VSWindowDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, VSWindow, ComCtrls, ExtCtrls;

type
  TVSWindowDemoForm = class(TForm)
    Button1: TButton;
    Panel1: TPanel;
    edtCaption: TEdit;
    Label1: TLabel;
    chkVisible: TCheckBox;
    chkEnabled: TCheckBox;
    cboState: TComboBox;
    Label2: TLabel;
    edtLeft: TEdit;
    Label3: TLabel;
    edtTop: TEdit;
    Label4: TLabel;
    edtWidth: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    edtHeight: TEdit;
    Panel2: TPanel;
    ListBox1: TListBox;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    edtHandle: TEdit;
    Label7: TLabel;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    edtProcessID: TEdit;
    Label8: TLabel;
    chkOnTop: TCheckBox;
    VSWindow1: TVSWindow;
    edtClassName: TEdit;
    Label9: TLabel;
    ListBox2: TListBox;
    Panel3: TPanel;
    Label10: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label18: TLabel;
    edtCCaption: TEdit;
    chkCVisible: TCheckBox;
    chkCEnabled: TCheckBox;
    edtCLeft: TEdit;
    edtCTop: TEdit;
    edtCWidth: TEdit;
    edtCHeight: TEdit;
    edtCHandle: TEdit;
    edtCClassName: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure edtCaptionChange(Sender: TObject);
    procedure cboStateChange(Sender: TObject);
    procedure edtLeftChange(Sender: TObject);
    procedure edtTopChange(Sender: TObject);
    procedure edtWidthChange(Sender: TObject);
    procedure edtHeightChange(Sender: TObject);
    procedure chkVisibleClick(Sender: TObject);
    procedure chkEnabledClick(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure chkOnTopClick(Sender: TObject);
    procedure ListBox2Click(Sender: TObject);
    procedure edtCCaptionChange(Sender: TObject);
    procedure edtCLeftChange(Sender: TObject);
    procedure edtCWidthChange(Sender: TObject);
    procedure edtCTopChange(Sender: TObject);
    procedure edtCHeightChange(Sender: TObject);
    procedure chkCEnabledClick(Sender: TObject);
    procedure chkCVisibleClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  VSWindowDemoForm: TVSWindowDemoForm;

implementation
var
  Window:TWindowData;
  Child:TChildWindow;

{$R *.DFM}

procedure ShowError;
begin
  ShowMessage('Error');
end;

procedure TVSWindowDemoForm.Button1Click(Sender: TObject);
var
  Index, i:integer;
begin
  Index:=ListBox1.ItemIndex;
  ListBox1.Items.BeginUpdate;
  ListBox1.Items.Clear;
  VSWindow1.Refresh;
  for i:=0 to VSWindow1.Count-1 do
    with VSWindow1.Windows[i] do
      ListBox1.Items.Add(Caption);
  if Index>=0 then
    ListBox1.ItemIndex:=Index
  else
    ListBox1.ItemIndex:=0;
  ActiveControl:=ListBox1;
  ListBox1Click(nil);
  ListBox1.Items.EndUpdate;
end;

procedure TVSWindowDemoForm.edtCaptionChange(Sender: TObject);
begin
  Window.Caption:=edtCaption.Text;
  edtCaption.Text:=Window.Caption;
  ListBox1.Items[ListBox1.ItemIndex]:=Window.Caption;
  ListBox1Click(nil);
end;

procedure TVSWindowDemoForm.cboStateChange(Sender: TObject);
begin
  Window.WindowState:=TWindowState(cboState.ItemIndex);
  ListBox1Click(nil);
end;

procedure TVSWindowDemoForm.edtLeftChange(Sender: TObject);
begin
  Window.Left:=StrToIntDef(edtLeft.Text,0);
  ListBox1Click(nil);
end;

procedure TVSWindowDemoForm.edtTopChange(Sender: TObject);
begin
  Window.Top:=StrToIntDef(edtTop.Text,0);
  ListBox1Click(nil);
end;

procedure TVSWindowDemoForm.edtWidthChange(Sender: TObject);
begin
  Window.Width:=StrToIntDef(edtWidth.Text,0);
  ListBox1Click(nil);
end;

procedure TVSWindowDemoForm.edtHeightChange(Sender: TObject);
begin
  Window.Height:=StrToIntDef(edtHeight.Text,0);
  ListBox1Click(nil);
end;

procedure TVSWindowDemoForm.chkVisibleClick(Sender: TObject);
begin
  Window.Visible:=chkVisible.Checked;
  ListBox1Click(nil);
end;

procedure TVSWindowDemoForm.chkEnabledClick(Sender: TObject);
begin
  Window.Enabled:=chkEnabled.Checked;
  ListBox1Click(nil);
end;

procedure TVSWindowDemoForm.ListBox1Click(Sender: TObject);
var
  Index:integer;
  j:integer;
begin
  if ListBox1.SelCount=0 then Exit;
  Index:=ListBox1.ItemIndex;
  Window:=VSWindow1.Windows[Index];
  with Window do
  begin
    Refresh;
    edtCaption.Text:=Caption;
    edtLeft.Text:=IntToStr(Left);
    edtTop.Text:=IntToStr(Top);
    edtWidth.Text:=IntToStr(Width);
    edtHeight.Text:=IntToStr(Height);
    chkEnabled.Checked:=Enabled;
    chkVisible.Checked:=Visible;
    cboState.ItemIndex:=ord(WindowState);
    edtHandle.Text:=IntToStr(Handle);
    edtProcessID.Text:=IntToHex(DWORD(ProcessID), 0);
    chkOnTop.Checked:=OnTop;
    edtClassName.Text:=WindowClassName;
    ListBox2.Items.BeginUpdate;
    ListBox2.Clear;
    for j:=0 to ChildsCount-1 do
      with Childs[j] do
        ListBox2.Items.Add(WindowClassName);
    if ListBox2.Items.Count>0 then
    begin
      ListBox2.ItemIndex:=0;
      ListBox2Click(nil);
      Panel3.Visible:=true;
    end
    else
      Panel3.Visible:=false;
    ListBox2.Items.EndUpdate;
  end;
end;

procedure TVSWindowDemoForm.FormCreate(Sender: TObject);
begin
  Button1Click(nil);
end;

procedure TVSWindowDemoForm.Button2Click(Sender: TObject);
begin
  Window.Maximize;
  ListBox1Click(nil);
end;

procedure TVSWindowDemoForm.Button3Click(Sender: TObject);
begin
  Window.Minimize;
  ListBox1Click(nil);
end;

procedure TVSWindowDemoForm.Button4Click(Sender: TObject);
begin
  Window.Restore;
  ListBox1Click(nil);
end;

procedure TVSWindowDemoForm.Button5Click(Sender: TObject);
begin
  Window.Close;
  ListBox1Click(nil);
  Button1Click(nil);
end;

procedure TVSWindowDemoForm.Button6Click(Sender: TObject);
begin
  if not Window.BringToTop then ShowError;
end;

procedure TVSWindowDemoForm.Button7Click(Sender: TObject);
begin
  if not Window.SetForeground then ShowError;
end;

procedure TVSWindowDemoForm.chkOnTopClick(Sender: TObject);
begin
  Window.OnTop:=chkOnTop.Checked;
  ListBox1Click(nil);
end;

procedure TVSWindowDemoForm.ListBox2Click(Sender: TObject);
var Index:integer;
begin
  if (ListBox2.items.Count<=0) or (ListBox2.SelCount=0) then Exit;
  Index:=ListBox2.ItemIndex;
  Child:=Window.Childs[Index];
  with Child do
  begin
    edtCCaption.Text:=Caption;
    edtCLeft.Text:=IntToStr(Left);
    edtCTop.Text:=IntToStr(Top);
    edtCWidth.Text:=IntToStr(Width);
    edtCHeight.Text:=IntToStr(Height);
    chkCVisible.Checked:=Visible;
    chkCEnabled.Checked:=Enabled;
    edtCHandle.Text:=IntToStr(Handle);
    edtCClassName.Text:=WindowClassName;
  end;
end;

procedure TVSWindowDemoForm.edtCCaptionChange(Sender: TObject);
begin
  Child.caption:=edtCCaption.Text;
  ListBox2Click(nil);
end;

procedure TVSWindowDemoForm.edtCLeftChange(Sender: TObject);
begin
  Child.Left:=StrToIntDef(edtCLeft.Text,0);
  ListBox2Click(nil);
end;

procedure TVSWindowDemoForm.edtCWidthChange(Sender: TObject);
begin
  Child.Width:=StrToIntDef(edtCWidth.Text,0);
  ListBox2Click(nil);
end;

procedure TVSWindowDemoForm.edtCTopChange(Sender: TObject);
begin
  Child.Top:=StrToIntDef(edtCTop.Text,0);
  ListBox2Click(nil);
end;

procedure TVSWindowDemoForm.edtCHeightChange(Sender: TObject);
begin
  Child.Height:=StrToIntDef(edtCHeight.Text,0);
  ListBox2Click(nil);
end;

procedure TVSWindowDemoForm.chkCEnabledClick(Sender: TObject);
begin
  Child.Enabled:=chkCEnabled.Checked;
  ListBox2Click(nil);
end;

procedure TVSWindowDemoForm.chkCVisibleClick(Sender: TObject);
begin
  Child.Visible:=chkCVisible.Checked;
  ListBox2Click(nil);
end;

end.
