unit VSWallpaperDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ExtDlgs, VSWallPaper;

type
  TVSWallpaperDemoForm = class(TForm)
    pnlColor: TPanel;
    edtFileName: TEdit;
    Button3: TButton;
    cboPlace: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    OpenPictureDialog1: TOpenPictureDialog;
    ColorDialog1: TColorDialog;
    Button1: TButton;
    Button2: TButton;
    VSWallPaper: TVSWallPaper;
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure pnlColorClick(Sender: TObject);
    procedure cboPlaceChange(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  VSWallpaperDemoForm: TVSWallpaperDemoForm;

implementation

{$R *.DFM}

procedure WUpdate;
begin
  with VSWallpaperDemoForm, VSWallpaperDemoForm.VSWallpaper do
  begin
    FileName:=edtFileName.Text;
    Place:=TPlaceKind(cboPlace.ItemIndex);
    DesktopColor:=pnlColor.Color;
    Update;
  end;
end;

procedure WRefresh;
begin
  with VSWallpaperDemoForm, VSWallpaperDemoForm.VSWallpaper do
  begin
    Refresh;
    edtFileName.Text:=FileName;
    cboPlace.ItemIndex:=ord(Place);
    pnlColor.Color:=DesktopColor;
  end;
end;

procedure TVSWallpaperDemoForm.Button3Click(Sender: TObject);
begin
  if OpenPictureDialog1.Execute then
  begin
    edtFileName.Text:=OpenPictureDialog1.FileName;
    WUpdate
  end;
end;

procedure TVSWallpaperDemoForm.FormCreate(Sender: TObject);
begin
  WRefresh;
end;

procedure TVSWallpaperDemoForm.pnlColorClick(Sender: TObject);
begin
  ColorDialog1.Color:=pnlColor.Color;
  if ColorDialog1.Execute then
  begin
    pnlColor.Color:=ColorDialog1.Color;
    WUpdate;
    WRefresh
  end;
end;

procedure TVSWallpaperDemoForm.cboPlaceChange(Sender: TObject);
begin
  WUpdate;
  WRefresh
end;

procedure TVSWallpaperDemoForm.Button1Click(Sender: TObject);
begin
  Close
end;

procedure TVSWallpaperDemoForm.Button2Click(Sender: TObject);
begin
  edtFileName.Text:='';
  WUpdate;
  WRefresh
end;

end.
