unit VSMacrosDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, VSMacros, ComCtrls;

type
  TVSMacrosDemoForm = class(TForm)
    btnRecord: TButton;
    btnPlay: TButton;
    edtFileName: TEdit;
    HotKey: THotKey;
    VSMacros1: TVSMacros;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    edtCount: TEdit;
    edtSpeed: TEdit;
    Label4: TLabel;
    chkNoDelay: TCheckBox;
    Label5: TLabel;
    procedure btnPlayClick(Sender: TObject);
    procedure btnRecordClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure VSMacros1AfterPlay(Sender: TObject; var Event: TEventMsg);
    procedure VSMacros1AfterRecord(Sender: TObject; var Event: TEventMsg);
    procedure chkNoDelayClick(Sender: TObject);
  private
    procedure Prepare(Final:boolean);
  public
    { Public declarations }
  end;

var
  VSMacrosDemoForm: TVSMacrosDemoForm;

implementation

{$R *.DFM}

procedure TVSMacrosDemoForm.Prepare(Final:boolean);
var Color:TColor;
begin
  if Final then
  begin
    Application.BringToFront;
    Color:=clWindow
  end
  else
  begin
    VSMacros1.FileName:=edtFileName.Text;
    Color:=clBtnFace;
  end;
  Label1.Enabled:=Final;
  Label2.Enabled:=Final;
  Label3.Enabled:=Final;
  Label4.Enabled:=Final;
  btnPlay.Enabled:=Final;
  btnRecord.Enabled:=Final;
  edtFileName.Color:=Color;
  edtFileName.Enabled:=Final;
  edtSpeed.Color:=Color;
  edtSpeed.Enabled:=Final;
  chkNoDelay.Enabled:=Final;
  Hotkey.Enabled:=Final;
end;

procedure TVSMacrosDemoForm.btnPlayClick(Sender: TObject);
begin
  Prepare(false);
  VSMacros1.Speed:=StrToIntDef(edtSpeed.Text, 100);
  VSMacros1.NoDelay:=chkNoDelay.Checked;
  VSMacros1.PlayMacros;
  Prepare(true);
end;

procedure TVSMacrosDemoForm.btnRecordClick(Sender: TObject);
begin
  Prepare(false);
  VSMacros1.StopShortcut:=Hotkey.HotKey;
  VSMacros1.RecordMacros;
  Prepare(true);
end;

procedure TVSMacrosDemoForm.FormCreate(Sender: TObject);
begin
  chkNoDelay.Checked:=VSMacros1.NoDelay;
  edtSpeed.Text:=IntToStr(VSMacros1.Speed);
  edtFileName.Text:=VSMacros1.FileName;
  Hotkey.HotKey:=VSMacros1.StopShortcut;
  chkNoDelayClick(Self);
end;

procedure TVSMacrosDemoForm.VSMacros1AfterPlay(Sender: TObject; var Event: TEventMsg);
begin
  edtCount.Text:=IntToStr(VSMacros1.Count);
end;

procedure TVSMacrosDemoForm.VSMacros1AfterRecord(Sender: TObject;
  var Event: TEventMsg);
begin
  edtCount.Text:=IntToStr(VSMacros1.Count);
end;

procedure TVSMacrosDemoForm.chkNoDelayClick(Sender: TObject);
begin
  edtSpeed.Enabled:=not chkNoDelay.Checked;
  if chkNoDelay.Checked then
    edtSpeed.Color:=clBtnFace
  else
    edtSpeed.Color:=clWindow;
end;

end.
