unit VSCursorDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  VSCursor, StdCtrls, ExtCtrls;

type
  TSVCursorDemoForm = class(TForm)
    Timer1: TTimer;
    VSCursor1: TVSCursor;
    GroupBox1: TGroupBox;
    edtClipLeft: TEdit;
    Label1: TLabel;
    edtClipBottom: TEdit;
    Bottom: TLabel;
    edtClipRight: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    GroupBox2: TGroupBox;
    edtPosX: TEdit;
    Label4: TLabel;
    edtClipTop: TEdit;
    edtPosY: TEdit;
    Label5: TLabel;
    btnRestoreClip: TButton;
    btnSetPos: TButton;
    edtPosX1: TEdit;
    edtPosY1: TEdit;
    Label6: TLabel;
    Label7: TLabel;
    GroupBox3: TGroupBox;
    edtDoubleClick: TEdit;
    chkSwapMouse: TCheckBox;
    GroupBox4: TGroupBox;
    cboButton: TComboBox;
    btnDown: TButton;
    btnUp: TButton;
    btnShow: TButton;
    btnHide: TButton;
    btnClick: TButton;
    Button: TLabel;
    chkActiveCursors: TCheckBox;
    Label8: TLabel;
    procedure Timer1Timer(Sender: TObject);
    procedure chkActiveCursorsClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure edtClipLeftChange(Sender: TObject);
    procedure btnSetPosClick(Sender: TObject);
    procedure edtClipTopChange(Sender: TObject);
    procedure edtClipBottomChange(Sender: TObject);
    procedure edtClipRightChange(Sender: TObject);
    procedure btnRestoreClipClick(Sender: TObject);
    procedure btnRestoreClick(Sender: TObject);
    procedure btnShowClick(Sender: TObject);
    procedure btnHideClick(Sender: TObject);
    procedure edtDoubleClickChange(Sender: TObject);
    procedure chkSwapMouseClick(Sender: TObject);
    procedure btnDownClick(Sender: TObject);
    procedure btnUpClick(Sender: TObject);
    procedure btnClickClick(Sender: TObject);
  private
    procedure SetClipInfo;
  public
    { Public declarations }
  end;

var
  VSCursorDemoForm: TSVCursorDemoForm;

implementation

{$R *.DFM}

procedure TSVCursorDemoForm.Timer1Timer(Sender: TObject);
begin
  edtPosX1.Text:=IntToStr(VSCursor1.PositionX);
  edtPosY1.Text:=IntToStr(VSCursor1.PositionY);
end;

procedure TSVCursorDemoForm.chkActiveCursorsClick(Sender: TObject);
begin
  VSCursor1.ActiveCursors:=chkActiveCursors.Checked;
end;

procedure TSVCursorDemoForm.FormCreate(Sender: TObject);
begin
  SetClipInfo;
  edtDoubleClick.Text:=IntToStr(VSCursor1.DoubleClickTime);
  edtPosX.Text:=IntToStr(VSCursor1.PositionX);
  edtPosY.Text:=IntToStr(VSCursor1.PositionY);
  cboButton.ItemIndex:=0;
end;

procedure TSVCursorDemoForm.edtClipLeftChange(Sender: TObject);
begin
  VSCursor1.ClipLeft:=StrToIntDef(edtClipLeft.Text,0);
  edtClipLeft.Text:=IntToStr(VSCursor1.ClipLeft);
end;

procedure TSVCursorDemoForm.btnSetPosClick(Sender: TObject);
begin
  VSCursor1.PositionX:=StrToIntDef(edtPosX.Text, 0);
  VSCursor1.PositionY:=StrToIntDef(edtPosY.Text, 0);
end;

procedure TSVCursorDemoForm.edtClipTopChange(Sender: TObject);
begin
  VSCursor1.ClipTop:=StrToIntDef(edtClipTop.Text,0);
  edtClipTop.Text:=IntToStr(VSCursor1.ClipTop);
end;

procedure TSVCursorDemoForm.edtClipBottomChange(Sender: TObject);
begin
  VSCursor1.ClipBottom:=StrToIntDef(edtClipBottom.Text,0);
  edtClipBottom.Text:=IntToStr(VSCursor1.ClipBottom);
end;

procedure TSVCursorDemoForm.edtClipRightChange(Sender: TObject);
begin
  VSCursor1.ClipRight:=StrToIntDef(edtClipRight.Text,0);
  edtClipRight.Text:=IntToStr(VSCursor1.ClipRight);
end;

procedure TSVCursorDemoForm.SetClipInfo;
begin
  edtClipLeft.Text:=IntToStr(VSCursor1.ClipLeft);
  edtClipTop.Text:=IntToStr(VSCursor1.ClipTop);
  edtClipRight.Text:=IntToStr(VSCursor1.ClipRight);
  edtClipBottom.Text:=IntToStr(VSCursor1.ClipBottom);
end;

procedure TSVCursorDemoForm.btnRestoreClipClick(Sender: TObject);
begin
  VSCursor1.RestoreClip;
  SetClipInfo;
end;

procedure TSVCursorDemoForm.btnRestoreClick(Sender: TObject);
begin
  VSCursor1.RestoreClip;
  SetClipInfo;
end;

procedure TSVCursorDemoForm.btnShowClick(Sender: TObject);
begin
  VSCursor1.Show;
end;

procedure TSVCursorDemoForm.btnHideClick(Sender: TObject);
begin
  VSCursor1.Hide;
end;

procedure TSVCursorDemoForm.edtDoubleClickChange(Sender: TObject);
begin
  VSCursor1.DoubleClickTime:=StrToIntDef(edtDoubleClick.Text,0);
  edtDoubleClick.Text:=IntToStr(VSCursor1.DoubleClickTime);
end;

procedure TSVCursorDemoForm.chkSwapMouseClick(Sender: TObject);
begin
  VSCursor1.SwapMouseButton(chkSwapMouse.Checked);
end;

procedure TSVCursorDemoForm.btnDownClick(Sender: TObject);
begin
  btnSetPosClick(Self);
  VSCursor1.MouseDown(TMouseButton(cboButton.ItemIndex));
end;

procedure TSVCursorDemoForm.btnUpClick(Sender: TObject);
begin
  btnSetPosClick(Self);
  VSCursor1.MouseUp(TMouseButton(cboButton.ItemIndex));
end;

procedure TSVCursorDemoForm.btnClickClick(Sender: TObject);
begin
  btnSetPosClick(Self);
  VSCursor1.MouseClick(TMouseButton(cboButton.ItemIndex));
end;

end.
