unit unModes;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MBSRectangle, StdCtrls, MBSTransBase, MBSTransparentForm, ExtCtrls,
  MBSShape, MBSEllipse, Buttons, unMain;

type
  TfoModes = class(TForm)
    MBSTransparentForm1: TMBSTransparentForm;
    MBSEllipse7: TMBSEllipse;
    MBSEllipse8: TMBSEllipse;
    MBSEllipse9: TMBSEllipse;
    MBSEllipse10: TMBSEllipse;
    MBSEllipse11: TMBSEllipse;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    MBSEllipse12: TMBSEllipse;
    MBSEllipse2: TMBSEllipse;
    MBSEllipse6: TMBSEllipse;
    MBSEllipse3: TMBSEllipse;
    MBSEllipse1: TMBSEllipse;
    MBSEllipse5: TMBSEllipse;
    MBSEllipse4: TMBSEllipse;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    MBSEllipse13: TMBSEllipse;
    Label15: TLabel;
    MBSEllipse15: TMBSEllipse;
    pButtons: TPanel;
    Label13: TLabel;
    btApply: TSpeedButton;
    Shape1: TShape;
    MBSRectangle6: TMBSRectangle;
    pCaptionBar: TPanel;
    Shape3: TShape;
    SpeedButton1: TSpeedButton;
    MBSRectangle7: TMBSRectangle;
    Label14: TLabel;
    MBSRectangle8: TMBSRectangle;
    MBSRectangle9: TMBSRectangle;
    MBSRectangle10: TMBSRectangle;
    MBSRectangle11: TMBSRectangle;
    MBSRectangle12: TMBSRectangle;
    tpShadow1: TMBSRectangle;
    tpMain: TMBSRectangle;
    procedure btApplyClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure pCaptionBarMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    FIsActive : Boolean;
    procedure SetShapes(Enable : Boolean);
  end;

implementation

{$R *.DFM}
procedure TfoModes.SetShapes(Enable : Boolean);

function Max(M,N : Integer):Integer;
begin
 IF M > N then
  Result := M
 else
  Result := N;
end;

function Shadow(Color : TColor):TColor;
var
 P,C1,C2,C3 : Byte;
begin
 C1 := Color and $FF;
 C2 := (Color shr 8) and $FF;
 C3 := (Color shr 16) and $FF;
 P  := (Color shr 24) and $FF;

 C1 := Max(0,C1-20);
 C2 := Max(0,C2-20);
 C3 := Max(0,C3-20);

 Result := C1
         + (C2 shl 8)
         + (C3 shl 16)
         + (P shl 24);

end;

var
 T : Integer;
begin
 FIsActive := Enable;
 tpMain.Enabled := not Enable;
 tpMain.Visible := not Enable;
 tpShadow1.Enabled := tpMain.Enabled;
 tpShadow1.Visible := tpMain.Visible;

 For T := 0 to ComponentCount-1 do
  IF Components[T] is TMBSEllipse then
   with (Components[T] as TMBSEllipse) do
    begin
     Enabled := Enable;
     Pen.Color := Shadow(Brush.Color);
    end;

 MBSTransparentForm1.MakeTransparent;
end;

procedure TfoModes.btApplyClick(Sender: TObject);
begin
 SetShapes(Not FIsActive);

 IF FIsActive then
  btApply.Caption := 'Restore Window'
 else
  btApply.Caption := 'Make Transparent!';
end;


procedure TfoModes.FormCreate(Sender: TObject);
begin
 Height := tpShadow1.Top + tpShadow1.Height;
 Width := tpShadow1.Left + tpShadow1.Width;
 SetShapes(False);
 MBSTransparentForm1.Active := True;
end;

procedure TfoModes.SpeedButton1Click(Sender: TObject);
begin
 unMain.foMain.FAttachedForm := nil;
 Close;
end;

procedure TfoModes.pCaptionBarMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 if Button = mbLeft then
  if Sender is TControl then
   MBSTransparentForm1.BeginDragMove(Sender as TControl, X, Y);
end;















end.
