unit unMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, MBSImage, Buttons, MBSTransBase, MBSTransparentForm;

type
  TfoMain = class(TForm)
    imNavbar: TMBSImage;
    MBSTransparentForm1: TMBSTransparentForm;
    btExit: TSpeedButton;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    Shape5: TShape;
    procedure imNavbarMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButton1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
  private
    { Private declarations }
    procedure WMMove(var Message: TMessage); message WM_MOVE;
    procedure WMMoving(var Message: TMessage); message WM_MOVING;
    procedure OnShowHint(var HintStr: string; var CanShow: Boolean; var HintInfo: THintInfo);

  public
    { Public declarations }
    FAttachedForm : TCustomForm;

    procedure CreateOurForm(aClass : TFormClass);
    procedure FreeAttachedForm;
    procedure MoveAttachedForm;
  end;

var
  foMain: TfoMain;

implementation

uses
 unAbout, unImageDemo, unModes, unAlbum,

unHintWindow;

{$R *.DFM}

procedure TfoMain.FreeAttachedForm;
begin
 IF FAttachedForm <> nil then
   FAttachedForm.Free;
  FAttachedForm := nil;
end;

procedure TfoMain.CreateOurForm(aClass : TFormClass);
begin
 FreeAttachedForm;

 FAttachedForm := aClass.Create(nil);
 MoveAttachedForm;
 FAttachedForm.Show;
end;


procedure TfoMain.imNavbarMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 IF Button = mbLeft then
   IF Sender is TControl then
     MBSTransparentForm1.BeginDragMove(Sender as TControl, X, Y);
end;



procedure TfoMain.btExitClick(Sender: TObject);
begin
 Close;
end;

procedure TfoMain.MoveAttachedForm;
begin
 IF FAttachedForm = nil then Exit;

{
 FAttachedForm.Left := Self.Left + Self.Width;
 FAttachedForm.Top := Self.Top + 7;
}

 //Direct move is just faster since
 //we don't move Top & Left seperately
 MoveWindow(
    FAttachedForm.Handle,
    Self.Left + Self.Width, Self.Top + 7,
    FAttachedForm.Width, FAttachedForm.Height,
    True);
end;

procedure TfoMain.WMMove(var Message: TMessage);
begin
 MoveAttachedForm;
end;


procedure TfoMain.WMMoving(var Message: TMessage);
begin
 MoveAttachedForm;
end;


procedure TfoMain.OnShowHint(var HintStr: string; var CanShow: Boolean; var HintInfo: THintInfo);
begin
 CanShow := HintInfo.HintStr <> '';
 HintInfo.HintWindowClass := TMyHintWindow;
end;

procedure TfoMain.FormCreate(Sender: TObject);
begin
 Application.OnShowHint := OnShowHint;
 CreateOurForm(TfoAbout);
end;

procedure TfoMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 FreeAttachedForm;
end;



procedure TfoMain.SpeedButton1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
// unHintWindow.ShowHint(X, Y,'Demo1: Tester is the the thing I must test?');
end;


procedure TfoMain.SpeedButton4Click(Sender: TObject);
begin
 CreateOurForm(TfoAbout);
end;

procedure TfoMain.SpeedButton1Click(Sender: TObject);
begin
 CreateOurForm(TfoImageDemo);
end;

procedure TfoMain.SpeedButton2Click(Sender: TObject);
begin
 CreateOurForm(TfoModes);
end;

procedure TfoMain.SpeedButton3Click(Sender: TObject);
begin
 CreateOurForm(TfoAlbum);
end;

end.
