unit unImageDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MBSShape, MBSRectangle, StdCtrls, Buttons, ExtCtrls, MBSTransBase,
  MBSTransparentForm,
  unMain, MBSImage, MBSTranslucency, ComCtrls, MBSRoundRect;

const
 WM_FADEIN = WM_USER + 20;


type
  TfoImageDemo = class(TForm)
    pCaptionBar: TPanel;
    Shape3: TShape;
    SpeedButton1: TSpeedButton;
    Label14: TLabel;
    MBSRectangle7: TMBSRectangle;
    MBSTransparentForm1: TMBSTransparentForm;
    imImage: TMBSImage;
    MBSRectangle6: TMBSRectangle;
    pButtons: TPanel;
    Label13: TLabel;
    Label1: TLabel;
    MBSRectangle1: TMBSRectangle;
    Panel1: TPanel;
    TrackBar1: TTrackBar;
    Shape1: TShape;
    btFadeIn: TSpeedButton;
    Shape2: TShape;
    btFadeOut: TSpeedButton;
    Label2: TLabel;
    MBSTranslucency1: TMBSTranslucency;
    tpWarning: TMBSRoundRect;
    Label3: TLabel;
    Label4: TLabel;
    procedure SpeedButton1Click(Sender: TObject);
    procedure Label14MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure btFadeInClick(Sender: TObject);
    procedure btFadeOutClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TrackBar1Change(Sender: TObject);
  private
    { Private declarations }
      procedure WMFadeIn(var Message: TMessage); message WM_FADEIN;
  public
    { Public declarations }
  end;


implementation

{$R *.DFM}

procedure TfoImageDemo.WMFadeIn(var Message: TMessage);
begin
  MBSTranslucency1.Fade(100,0);
  MBSTranslucency1.Translucency := 0;
end;

procedure TfoImageDemo.SpeedButton1Click(Sender: TObject);
begin
 unMain.foMain.FAttachedForm := nil;
 Close;
end;

procedure TfoImageDemo.Label14MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 if Button = mbLeft then
  if Sender is TControl then
   MBSTransparentForm1.BeginDragMove(Sender as TControl, X, Y);
end;


procedure TfoImageDemo.FormCreate(Sender: TObject);
begin
 if not GetSupportLayeredWindows then
 begin
  btFadeIn.Enabled := False;
  btFadeOut.Enabled := False;
  TrackBar1.Enabled := False;
  tpWarning.Enabled := True;
 end;

 MBSTransparentForm1.MakeTransparent;
end;

procedure TfoImageDemo.btFadeInClick(Sender: TObject);
begin
  MBSTranslucency1.FadeIn;
end;

procedure TfoImageDemo.btFadeOutClick(Sender: TObject);
begin
 MBSTranslucency1.FadeOut;
 MBSTranslucency1.Translucency := TrackBar1.Position;
end;

procedure TfoImageDemo.FormShow(Sender: TObject);
begin
IF GetSupportLayeredWindows then
 begin
   MBSTranslucency1. Translucency := 100;
   PostMessage(Handle,WM_FADEIN,0,0);
 end;
end;

procedure TfoImageDemo.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  IF GetSupportLayeredWindows then
    MBSTranslucency1.FadeOut;
end;

procedure TfoImageDemo.TrackBar1Change(Sender: TObject);
begin
 MBSTranslucency1.Translucency := TrackBar1.Position;
end;




end.
