unit unHintWindow;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, MBSShape, MBSEllipse, StdCtrls, MBSTransBase,
  MBSTransparentForm;

type
  TfoHintWindow = class(TForm)
    tpBubbleSmallest: TMBSEllipse;
    MBSEllipse3: TMBSEllipse;
    tpBubble: TMBSEllipse;
    lbCaption: TLabel;
    MBSTransparentForm1: TMBSTransparentForm;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

 TMyHintWindow = class(THintWindow)
 private
  procedure WMShowWindow(var Message: TMessage); message WM_SHOWWINDOW;
 public
  foHintWindow : TfoHintWindow;
  constructor Create(AOwner : TComponent); override;
  destructor Destroy; override;

  procedure ActivateHint(Rect: TRect; const AHint: string); override;
  procedure ActivateHintData(Rect: TRect; const AHint: string; AData: Pointer); override;
 end;

{var
  foHintWindow: TfoHintWindow = nil;
}

procedure DoShowHint(Form : TfoHintWindow; X, Y : Integer; aCaption : String);

implementation

{$R *.DFM}

constructor TMyHintWindow.Create(AOwner : TComponent);
begin
 inherited Create(AOwner);
 Visible := False;
 foHintWindow := TfoHintWindow.Create(nil);
end;

destructor TMyHintWindow.Destroy;
begin
 foHintWindow.Free;
 inherited Destroy;
end;
procedure TMyHintWindow.WMShowWindow(var Message: TMessage);
begin
 IF Message.WParam = 0 then
  foHintWindow.Close
 else
  ;//Else window is being shown
end;

procedure TMyHintWindow.ActivateHint(Rect: TRect; const AHint: string);
begin
  DoShowHint(foHintWindow,Rect.Left, Rect.Top, AHint);
  inherited ActivateHint(Rect, AHint);
end;

procedure TMyHintWindow.ActivateHintData(Rect: TRect; const AHint: string; AData: Pointer);
begin
  DoShowHint(foHintWindow,Rect.Left, Rect.Top, AHint);

  Rect.Bottom := Rect.Top;
  Rect.Right := Rect.Left;

  inherited ActivateHintData(Rect,AHint,AData);

end;

function Max(M,N : Integer):Integer;
begin
 IF M > N then
  Result := M
 else
  Result := N;
end;

procedure DoShowHint(Form : TfoHintWindow; X, Y : Integer; aCaption : String);
begin
 IF Form = nil then
  Form := TfoHintWindow.Create(nil);

  with Form do begin
   lbCaption.Caption := aCaption;
   Left := X;
   Top := Y;

   //Make sure caption is minimum size
   IF Length(lbCaption.Caption) > 20 then
     lbCaption.Width := Max(lbCaption.Width,120);

   //Make sure bubble is big enough
   tpBubble.Width := Max(84,Round(lbCaption.Width*1.5));
   tpBubble.Height := Max(40,Round(lbCaption.Height*2));

   //Center out caption
   lbCaption.Top := tpBubble.Top + ((tpBubble.Height-lbCaption.Height) div 2);
   lbCaption.Left := tpBubble.Left + ((tpBubble.Width-lbCaption.Width) div 2);

   //Make sure form is big enough
   Width := tpBubble.Left + tpBubble.Width+5;
   Height := Max(tpBubble.Top + tpBubble.Height+5, tpBubbleSmallest.Top+tpBubbleSmallest.Height+5);

   MBSTransparentForm1.MakeTransparent;
   Show;
   Update;
  end;

end;

//===============================

end.
