unit unAlbum;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  unMain, StdCtrls, Buttons, ExtCtrls, MBSShape, MBSRectangle,
  MBSTransBase, MBSTransparentForm;

const
 InfoText : Array[1..7] of String = (
 {1}
 'TMBSTransparentForm generates complex transparent windows by combining the various shapes & images below into one complex region.'+#13#10+
 'This allows for a visual (WYSIWYG), very powerfull and flexible way to create regions fast - without writing any lines of code!'+#13#10+
 'You can even work with the form in design-time WHILE IT IS TRANSPARENT!!'+#13#10#13#10+
 'Other features include automatic dragging, REAL stay-on-top forms, saving regions to file and much more...',
 {2}
 'TMBSRegionData can load its region from a file or internal stream.'+#13#10#13#10+
 'TMBSRegionData is usefull because it is FAST - you can even create animated forms with it!'+#13#10#13#10+
 'Other features include automatic dragging, REAL stay-on-top forms and saving regions to file',
 {3}
 'TMBSImage is a very powerfull component that can create a region by tracing the shape of an image.'+#13#10#13#10+
 'With this component you can finally create forms in ANY shape you can imagine.'+#13#10#13#10+
 'Comes with a very cool component editor that allows you to create a mask for your image in one simple step!'+#13#10#13#10+
 'The region from a TMBSImage can be combined with other region components to create very complex regions without any hassles.',
 {4}
 'TMBSEllipse generates an elliptical region that can be combined with all the other regions to create very complex regions in a snap.',
 {5}
 'TMBSRectangle generates a rectangular region that can be combined with all the other regions to create very complex regions in a snap.',
 {6}
 'TMBSRoundRect generates a rectangular region with rounded corners that can be combined with all the other regions to create very complex regions in a snap.',
 {7}
 'Windows 2000 & Windows XP allows users to create semi-transparent windows where you can see the contents behind the window as if you were looking through colored glass.'+#13#10+
 'TMBSTranslucency encapsulates this functionality in a very simple to use component.'+#13#10+
 'It automatically detects if the operating system supports layered windows (as it is technically called) and will not report errors on operating systems that do not support it.'+#13#10+
 'TMBSTranslucency also has some nifty fade-in & fade-out functions...'
 );

type
  TfoAlbum = class(TForm)
    tpShadow: TMBSRectangle;
    MBSRectangle2: TMBSRectangle;
    MBSRectangle7: TMBSRectangle;
    pCaptionBar: TPanel;
    Shape3: TShape;
    SpeedButton1: TSpeedButton;
    Label14: TLabel;
    MBSTransparentForm1: TMBSTransparentForm;
    SpeedButton2: TSpeedButton;
    Shape1: TShape;
    Label1: TLabel;
    Shape2: TShape;
    Shape10: TShape;
    Shape11: TShape;
    SpeedButton6: TSpeedButton;
    Label5: TLabel;
    Shape12: TShape;
    Shape13: TShape;
    SpeedButton7: TSpeedButton;
    Label6: TLabel;
    Shape14: TShape;
    Shape15: TShape;
    SpeedButton8: TSpeedButton;
    Label7: TLabel;
    Shape4: TShape;
    Shape5: TShape;
    SpeedButton3: TSpeedButton;
    Label2: TLabel;
    Shape6: TShape;
    Shape7: TShape;
    SpeedButton4: TSpeedButton;
    Label3: TLabel;
    Shape8: TShape;
    Shape9: TShape;
    SpeedButton5: TSpeedButton;
    Label4: TLabel;
    Shape16: TShape;
    Shape19: TShape;
    Label9: TLabel;
    MBSRectangle6: TMBSRectangle;
    pButtons: TPanel;
    mInfo: TMemo;
    Bevel1: TBevel;
    Label8: TLabel;
    Shape17: TShape;
    Label10: TLabel;
    Shape18: TShape;
    Label11: TLabel;
    SpeedButton9: TSpeedButton;
    SpeedButton10: TSpeedButton;
    SpeedButton11: TSpeedButton;
    SpeedButton12: TSpeedButton;
    SpeedButton13: TSpeedButton;
    SpeedButton14: TSpeedButton;
    SpeedButton15: TSpeedButton;
    SpeedButton16: TSpeedButton;
    procedure SpeedButton1Click(Sender: TObject);
    procedure Label14MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure Shape17MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SpeedButton2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  foAlbum: TfoAlbum;

implementation

{$R *.DFM}

uses ShellApi;

procedure TfoAlbum.SpeedButton1Click(Sender: TObject);
begin
 unMain.foMain.FAttachedForm := nil;
 Close;
end;

procedure TfoAlbum.Label14MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 if Button = mbLeft then
  if Sender is TControl then
   MBSTransparentForm1.BeginDragMove(Sender as TControl, X, Y);
end;

procedure TfoAlbum.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Height := tpShadow.Top + tpShadow.Height;
 Width := tpShadow.Left + tpShadow.Width;
end;

procedure TfoAlbum.FormCreate(Sender: TObject);
begin
 Height := tpShadow.Top + tpShadow.Height;
 Width := tpShadow.Left + tpShadow.Width;
end;

procedure TfoAlbum.Shape17MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 ShellExecute(GetDesktopWindow,Pchar('Open'),PChar('http://www.MindBlastSoftware.com'),nil,nil,SW_SHOW);
end;

procedure TfoAlbum.SpeedButton2Click(Sender: TObject);
begin
 IF Sender is TSpeedButton then
 case (Sender as TSpeedButton).Tag of
  1..7 : mInfo.Text := InfoText[(Sender as TSpeedButton).Tag];
  else mInfo.Text := 'No extra information available at this stage';
 end;
end;









end.
