unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, FileShareD3, NapsterD3, StdCtrls, ExtCtrls, ComCtrls, scktcomp,
  FileShareFreeD3, NapsterFreeD3;

type
  TForm1 = class(TForm)
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    Edit1: TEdit;
    Label1: TLabel;
    Edit2: TEdit;
    Label2: TLabel;
    Button1: TButton;
    Panel2: TPanel;
    Button2: TButton;
    Edit3: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Edit4: TEdit;
    Label5: TLabel;
    Label8: TLabel;
    Panel3: TPanel;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Panel5: TPanel;
    Panel6: TPanel;
    Panel8: TPanel;
    Label7: TLabel;
    Panel9: TPanel;
    Label9: TLabel;
    ListView3: TListView;
    ListView2: TListView;
    CheckBox1: TCheckBox;
    Label10: TLabel;
    Edit5: TEdit;
    PopupMenu1: TPopupMenu;
    Download1: TMenuItem;
    Edit6: TEdit;
    Label11: TLabel;
    Button6: TButton;
    OpenDialog1: TOpenDialog;
    Panel4: TPanel;
    ListView1: TListView;
    Panel7: TPanel;
    Label6: TLabel;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    ComboBox3: TComboBox;
    ComboBox4: TComboBox;
    Napster1: TNapsterFree;
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure ComboBox4Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Napster1Connect(Sender: TObject);
    procedure Napster1Disconnect(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Napster1InvalidNick(Sender: TObject);
    procedure Napster1NickNotReg(Sender: TObject);
    procedure Napster1NickReg(Sender: TObject);
    procedure Napster1SearchResult(Sender: TComponent; Filename, MD5, Size,
      Bitrate, Frequency, Length, Nick, IP, LinkType, weight: String);
    procedure FormDestroy(Sender: TObject);
    procedure Download1Click(Sender: TObject);
    procedure Napster1DownloadAck(Sender: TComponent; Nick, IP, Port,
      Filename, MD5, LinkType: String);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Napster1PushFile(Sender: TComponent; Nick, IP, Port,
      Filename, MD5, LinkType: String);
    procedure Napster1ReceiveFile(Socket: TCustomWinSocket; Nick, Filename,
      Size: String);
    procedure Napster1UploadFile(Socket: TCustomWinSocket; Nick, Filename,
      Offset: String);
    procedure Napster1QueueLimit(Sender: TComponent; Nick, Filename, Size,
      Limit: String);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Napster1UploadRequest(Sender: TComponent; Nick, Filename,
      LinkType: String);
    procedure Napster1Login(Sender: TComponent; Email: String);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    files:TList;
    numfiles:integer;
    ObjectsToFree:TStringList;
    function find_nickipfilename(nick,ip,filename:string):integer;
    function find_nickfilename(nick,filename:string):integer;
    function findfull_nickipfilename(nick,ip,filename:string):integer;
    function findfull_nickfilename(nick,filename:string):integer;

    procedure OnProgress(Sender: TComponent; Filename : string; BytesReceived : integer);
    procedure OnError (Sender: TComponent; Filename, ErrorMsg : string);
    procedure OnDownloaded(Sender: TComponent; Filename : string);
    procedure OnConnect(Sender: TComponent; Filename : string);
    procedure OnDisconnect(Sender: TComponent; Filename : string);

    procedure OnPushProgress(Sender: TComponent; Filename : string; BytesReceived : integer);
    procedure OnPushError (Sender: TComponent; Filename, ErrorMsg : string);
    procedure OnPushed(Sender: TComponent; Filename : string);
    procedure OnPushConnect(Sender: TComponent; Filename : string);
    procedure OnPushDisconnect(Sender: TComponent; Filename : string);
    procedure OnStartPush(Sender: TComponent; Filename : string);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Login;

{$R *.dfm}

function TForm1.find_nickipfilename(nick,ip,filename:string):integer;
var
  i:integer;
begin
  i:=numfiles;
  result:=-1;
  if numfiles=-1 then exit;
  repeat
    if (PFileInfoRecord(files[i])^.Filename=filename)and(PFileInfoRecord(files[i])^.ip=IP)and(PFileInfoRecord(files[i])^.User=nick) then
    begin
      result:=i;
      exit;
    end;
    dec(i);
  until i=-1;
end;

function TForm1.find_nickfilename(nick,filename:string):integer;
var
  i:integer;
begin
  i:=numfiles;
  result:=-1;
  if numfiles=-1 then exit;
  repeat
    if (PFileInfoRecord(files[i])^.Filename=filename)and(PFileInfoRecord(files[i])^.User=nick) then
    begin
      result:=i;
      exit;
    end;
    dec(i);
  until i=-1;
end;

function TForm1.findfull_nickipfilename(nick,ip,filename:string):integer;
var
  i:integer;
begin
  i:=numfiles;
  result:=-1;
  if numfiles=-1 then exit;
  repeat
    if (PFileInfoRecord(files[i])^.FullFilename=filename)and(PFileInfoRecord(files[i])^.ip=IP)and(PFileInfoRecord(files[i])^.User=nick) then
    begin
      result:=i;
      exit;
    end;
    dec(i);
  until i=-1
end;

function TForm1.findfull_nickfilename(nick,filename:string):integer;
var
  i:integer;
begin
  i:=numfiles;
  result:=-1;
  if numfiles=-1 then exit;
  repeat
    if (PFileInfoRecord(files[i])^.FullFilename=filename)and(PFileInfoRecord(files[i])^.User=nick) then
    begin
      result:=i;
      exit;
    end;
    dec(i);
  until i=-1
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  if (ComboBox1.Text='') or (ComboBox1.Text='Don''t care') then
  begin
    Napster1.BitRateCmp:=cmpDontCare;
  end;
  if (ComboBox1.Text='') or (ComboBox1.Text='Don''t care') then
  begin
    Napster1.BitRateCmp:=cmpDontCare;
  end;
  if (ComboBox1.Text='') or (ComboBox1.Text='Don''t care') then
  begin
    Napster1.BitRateCmp:=cmpDontCare;
  end;
end;

procedure TForm1.ComboBox3Change(Sender: TObject);
begin
  if (ComboBox1.Text='') or (ComboBox1.Text='Don''t care') then
  begin
    Napster1.LineSpeedCmp:=cmpDontCare;
  end;
  if (ComboBox1.Text='') or (ComboBox1.Text='Don''t care') then
  begin
    Napster1.LineSpeedCmp:=cmpDontCare;
  end;
  if (ComboBox1.Text='') or (ComboBox1.Text='Don''t care') then
  begin
    Napster1.LineSpeedCmp:=cmpDontCare;
  end;
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
begin
  if ComboBox2.Text='' then
  begin
    Napster1.BitRate:=320;
  end
  else
  begin
    Napster1.BitRate:=strtoint(ComboBox2.Text);
  end;
end;

procedure TForm1.ComboBox4Change(Sender: TObject);
begin
  if ComboBox4.Text='T3' then
  begin
    Napster1.LineSpeed:=ltT3more;
  end;
  if ComboBox4.Text='T1' then
  begin
    Napster1.LineSpeed:=ltT1;
  end;
  if ComboBox4.Text='DSL' then
  begin
    Napster1.LineSpeed:=ltDSL;
  end;
  if ComboBox4.Text='Cable' then
  begin
    Napster1.LineSpeed:=ltCable;
  end;
  if ComboBox4.Text='ISDN 128K' then
  begin
    Napster1.LineSpeed:=lt128KbsISDN;
  end;
  if ComboBox4.Text='ISDN 64K' then
  begin
    Napster1.LineSpeed:=lt64KbsISDN;
  end;
  if ComboBox4.Text='56K' then
  begin
    Napster1.LineSpeed:=lt56KbsModem;
  end;
  if ComboBox4.Text='33.6' then
  begin
    Napster1.LineSpeed:=lt33KbsModem;
  end;
  if ComboBox4.Text='28.8' then
  begin
    Napster1.LineSpeed:=lt28KbsModem;
  end;
  if ComboBox4.Text='lt14KbsModem' then
  begin
    Napster1.LineSpeed:=ltT3more;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if Button1.Caption='Connect' then
  begin
    Button1.Caption:='Connect';
    Napster1.Host:=Edit1.Text;
    Napster1.Port:=strtoint(Edit2.Text);
    Napster1.Connect;
  end
  else
  begin
    Napster1.Disconnect;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if (Edit3.Text='')and (Edit4.Text='') then
    exit;
  if (Edit3.Text<>'')and (Edit4.Text<>'') then
    Napster1.SearchSong(Edit3.Text,Edit4.Text);
  if (Edit3.Text<>'') then
    Napster1.Search(Edit3.Text);
  if (Edit4.Text<>'') then
    Napster1.Search(Edit4.Text);
end;

procedure TForm1.Napster1Connect(Sender: TObject);
begin
  Button1.Caption:='Disconnect';
  if Form2.ShowModal=mrOK then
  begin
    Napster1.Nick:=Form2.Edit1.Text;
    Napster1.Password:=Edit2.Text;
    Napster1.Email:=Edit3.Text;
    Napster1.LineSpeed:=ltUnknown;
    if Form2.ComboBox4.Text='T3' then Napster1.LineSpeed:=ltT3more;
    if Form2.ComboBox4.Text='T1' then Napster1.LineSpeed:=ltT1;
    if Form2.ComboBox4.Text='DSL' then Napster1.LineSpeed:=ltDSL;
    if Form2.ComboBox4.Text='Cable' then Napster1.LineSpeed:=ltCable;
    if Form2.ComboBox4.Text='ISDN 128K' then Napster1.LineSpeed:=lt128KbsISDN;
    if Form2.ComboBox4.Text='ISDN 64K' then Napster1.LineSpeed:=lt64KbsISDN;
    if Form2.ComboBox4.Text='56K' then Napster1.LineSpeed:=lt56KbsModem;
    if Form2.ComboBox4.Text='33.6' then Napster1.LineSpeed:=lt33KbsModem;
    if Form2.ComboBox4.Text='28.8' then Napster1.LineSpeed:=lt28KbsModem;
    if Form2.ComboBox4.Text='14.4' then Napster1.LineSpeed:=lt14KbsModem;
    if Form2.RadioButton1.Checked then
    begin
      Napster1.CheckUser(Napster1.Nick);
    end
    else
    begin
      Napster1.Login;
    end;
  end;
  StatusBar1.Panels.Items[0].text:='Connected';
end;

procedure TForm1.Napster1Disconnect(Sender: TObject);
begin
  Button1.Caption:='Connect';
  StatusBar1.Panels.Items[0].text:='Disconnected';
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  numfiles:=-1;
  files:=TList.Create;
  ObjectsToFree:=TStringList.Create;
  Napster1.Firewall:=false;
  Napster1.ListenPort:=6789;
  Panel4.Align:=alClient;
  Panel5.Align:=alClient;
  Panel6.Align:=alClient;
end;

procedure TForm1.Napster1InvalidNick(Sender: TObject);
begin
  ShowMessage('Invalid Username');
  Napster1Connect(Sender);
end;

procedure TForm1.Napster1NickNotReg(Sender: TObject);
begin
  Napster1.RegisterUser;
end;

procedure TForm1.Napster1NickReg(Sender: TObject);
begin
  ShowMessage('Username already registred!');
  Napster1Connect(Sender);
end;

procedure TForm1.Napster1SearchResult(Sender: TComponent; Filename, MD5,
  Size, Bitrate, Frequency, Length, Nick, IP, LinkType, weight: String);
var
  item:TListItem;
  f:PFileInfoRecord;

begin
  delete(filename,1,1);
  delete(filename,System.length(filename),1);
  System.new(f);
  inc(numfiles);
  f^.FullFilename:=filename;
  f^.Filename:=extractfilename(filename);
  f^.Size:=strtoint(size);
  f^.Bitrate:=strtoint(bitrate);
  f^.Frequency:=strtoint(frequency);
  f^.Duration:=strtoint(length);
  f^.User:=nick;
  f^.Connection:=strtoint(LinkType);
  f^.Ping:=-1;
  f^.IP:=IP;
  f^.md5:=md5;
  f^.Weight:=strtoint(Weight);
  files.Add(f);
  filename:=ExtractFilename(filename);
  item:=ListView1.Items.Add;
  item.Caption:=filename;
  item.SubItems.Add(Size);
  item.SubItems.Add(Bitrate);
  item.SubItems.Add(Frequency);
  item.SubItems.Add(Length);
  item.SubItems.Add(Nick);
  item.SubItems.Add(LinkType);
  //item.SubItems.Add('N/A');
  item.Data:=f;//@files[numfiles];
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  files.Free;
end;

procedure TForm1.Download1Click(Sender: TObject);
begin
  Napster1.Download(ListView1.Selected.SubItems[4],PFileInfoRecord(files[find_nickfilename(ListView1.Selected.SubItems[4],ListView1.Selected.Caption)])^.fullfilename{ListView1.Selected.Caption});
end;

procedure TForm1.Napster1DownloadAck(Sender: TComponent; Nick, IP, Port,
  Filename, MD5, LinkType: String);
var
  fn:string;
  item:^TListItem;
begin
  fn:=Filename;
  Delete(Filename,1,1);
  Delete(Filename,length(Filename),1);
  if port<>'0' then
  begin
    getmem(item,SizeOf(TListItem));
    item^:=ListView3.Items.Add;
    item^.Caption:=filename;
    item^.SubItems.Add(inttostr(PFileInfoRecord(files[findfull_nickipfilename(nick,ip,filename)])^.Size));
    item^.SubItems.Add(Nick);
    item^.SubItems.Add('Connecting...');
    item^.SubItems.Add('0 KB/s');
    item^.SubItems.Add('0%');
    TNapsterDownloadFile.CreateStart(self,IP,strtoint(Port),fn,Napster1.Nick,0,{strtoint(edit6.text)}PFileInfoRecord(files[findfull_nickipfilename(nick,ip,filename)])^.Size, Edit6.text+ExtractFileName(filename),OnError, OnProgress, OnDownloaded, OnConnect, OnDisconnect, nil,item)
  end
  else
    Napster1.PushFile(Nick,Filename);
end;

procedure TForm1.OnConnect(Sender: TComponent; Filename : string);
begin
  TListItem((Sender AS TNapsterFileTransfer).Data^).SubItems[2]:='Connected';
end;

procedure TForm1.OnDisconnect(Sender: TComponent; Filename : string);
begin
  TListItem((Sender AS TNapsterFileTransfer).Data^).SubItems[2]:='Disconnected';
  ObjectsToFree.AddObject('',Sender)
  //(Sender AS TNapsterFileTransfer).Free;
end;

procedure TForm1.OnProgress(Sender: TComponent; Filename : string; BytesReceived : integer);
begin
  TListItem((Sender AS TNapsterFileTransfer).Data^).SubItems[4]:=inttostr(round(BytesReceived / strtoint(TListItem((Sender AS TNapsterFileTransfer).Data^).SubItems[0])*100))+'%';
  TListItem((Sender AS TNapsterFileTransfer).Data^).SubItems[3]:=inttostr(BytesReceived);
end;

procedure TForm1.OnError (Sender: TComponent; Filename, ErrorMsg : string);
begin
  TListItem((Sender AS TNapsterFileTransfer).Data^).SubItems[2]:='Error: '+ErrorMsg;
end;

procedure TForm1.OnDownloaded( Sender: TComponent; Filename:string);
begin
  TListItem((Sender AS TNapsterFileTransfer).Data^).SubItems[2]:='Downloaded';
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Panel4.BringToFront;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  Panel5.BringToFront;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  Panel6.BringToFront;
end;

procedure TForm1.Napster1PushFile(Sender: TComponent; Nick, IP, Port,
  Filename, MD5, LinkType: String);
var
  item:^TListItem;
begin
  Delete(Filename,1,1);
  Delete(Filename,length(Filename),1);
  getmem(item,SizeOf(TListItem));
  item^:=ListView2.Items.Add;
  item^.Caption:=filename;
  item^.SubItems.Add(getFileSize(Filename));
  item^.SubItems.Add(Nick);
  item^.SubItems.Add('Connecting...');
  item^.SubItems.Add('0 KB/s');
  item^.SubItems.Add('0%');
  TNapsterPushFile.CreateStart(self,ip,strtoint(port),filename,Napster1.Nick,0,OnPushError,OnPushProgress,OnPushed,OnPushConnect,OnPushDisconnect,OnStartPush, item);
end;

procedure TForm1.OnPushProgress(Sender: TComponent; Filename : string; BytesReceived : integer);
begin
  TListItem((Sender AS TNapsterFileTransfer).Data^).SubItems[4]:=inttostr(round(BytesReceived / strtoint((TListItem((Sender AS TNapsterFileTransfer).Data^).SubItems[0]))*100))+'%';
  TListItem((Sender AS TNapsterFileTransfer).Data^).SubItems[3]:=inttostr(BytesReceived);
end;

procedure TForm1.OnPushError (Sender: TComponent; Filename, ErrorMsg : string);
begin
  TListItem((Sender AS TNapsterFileTransfer).Data^).SubItems[2]:='Error: '+ErrorMsg;
end;

procedure TForm1.OnPushed(Sender: TComponent; Filename : string);
begin
  TListItem((Sender AS TNapsterFileTransfer).Data^).SubItems[2]:='Uploaded';
end;

procedure TForm1.OnPushConnect(Sender: TComponent; Filename : string);
begin
  TListItem((Sender AS TNapsterFileTransfer).Data^).SubItems[2]:='Connected';
end;

procedure TForm1.OnPushDisconnect(Sender: TComponent; Filename : string);
begin
  TListItem((Sender AS TNapsterFileTransfer).Data^).SubItems[2]:='Disconneced';
  ObjectsToFree.AddObject('',Sender)
  //(Sender AS TNapsterFileTransfer).Free;
end;

procedure TForm1.OnStartPush(Sender: TComponent; Filename : string);
begin
  TListItem((Sender AS TNapsterFileTransfer).Data^).SubItems[2]:='Starting Upload';
end;

procedure TForm1.Napster1ReceiveFile(Socket: TCustomWinSocket; Nick,
  Filename, Size: String);
var
  item:^TListItem;
begin
  Delete(Filename,1,1);
  Delete(Filename,length(Filename),1);
  getmem(item,SizeOf(TListItem));
  item^:=ListView3.Items.Add;
  item^.Caption:=filename;
  item^.SubItems.Add(Size);
  item^.SubItems.Add(Nick);
  item^.SubItems.Add('Connecting...');
  item^.SubItems.Add('0 KB/s');
  item^.SubItems.Add('0%');
  TNapsterPopFile.CreateStart(self,Socket,Filename,Edit6.text+ExtractFileName(filename),0,strtoint(size),OnProgress,OnError,OnDownloaded,OnDisconnect,nil,item);
end;

procedure TForm1.Napster1UploadFile(Socket: TCustomWinSocket; Nick,
  Filename, Offset: String);
var
  item:^TListItem;
begin
  Delete(Filename,1,1);
  Delete(Filename,length(Filename),1);
  getmem(item,SizeOf(TListItem));
  item^:=ListView2.Items.Add;
  item^.Caption:=filename;
  item^.SubItems.Add(getFileSize(Filename));
  item^.SubItems.Add(Nick);
  item^.SubItems.Add('Connecting...');
  item^.SubItems.Add('0 KB/s');
  item^.SubItems.Add('0%');
  TNapsterUploadFile.CreateStart(self,Socket,Filename,strtoint(Offset),0,OnPushProgress,OnPushError,OnPushed,OnPushDisconnect,OnStartPush,item);
end;

procedure TForm1.Napster1QueueLimit(Sender: TComponent; Nick, Filename,
  Size, Limit: String);
var
  item:^TListItem;
begin
    getmem(item,SizeOf(TListItem));
    item^:=ListView3.Items.Add;
    item^.Caption:=filename;
    item^.SubItems.Add(Size);
    item^.SubItems.Add(Nick);
    item^.SubItems.Add('Queued');
    item^.SubItems.Add('0 KB/s');
    item^.SubItems.Add('0%');
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  if CheckBox1.Checked then Edit5.Text:='0' else Edit5.Text:='6789'
end;

procedure TForm1.Button6Click(Sender: TObject);
var
  i:integer;
begin
  if OpenDialog1.Execute then
  begin
    for i:=0 to OpenDialog1.Files.Count-1 do
    begin
      Napster1.ShareFile(OpenDialog1.Files[i]);
    end;
  end;
end;

procedure TForm1.Napster1UploadRequest(Sender: TComponent; Nick, Filename,
  LinkType: String);
begin
  Delete(Filename,1,1);
  Delete(Filename,length(Filename),1);
  Napster1.UploadAccept(Nick,Filename);
end;

procedure TForm1.Napster1Login(Sender: TComponent; Email: String);
begin
  StatusBar1.Panels.Items[0].text:='Logged in';
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var
  i:integer;
begin
  if Napster1.Connected then
  begin
    Napster1.Disconnect;
  end;
  //Application.MessageBox('close','close');
  for i:=0 to ListView1.Items.Count-1 do
  begin
    if Assigned(ListView1.Items[i].Data) then
    begin
      Dispose(ListView1.Items[i].Data);
      ListView1.Items[i].Data:=nil;
    end;
  end;
  for i:=0 to ObjectsToFree.Count-1 do
  begin
    ObjectsToFree.Objects[i].Free;
  end;
  ObjectsToFree.free
end;

end.
