unit uDemo;

(*  TStockGraph may contain up to 3000 OHLCV date data.
    TStockGraph must be put into a panel or tabsheet for proper display.
    See BtnLoadClick for how to put data into it.
    See BtnShowClick for how to display data.
    See BtnMoveClick for forward and backward navigation:
    1 step = two months forth/back in time
    2 steps = four months forth/back in time
    10 steps = till end of data
    -10 steps = till start of data
    See BtnEmaClick for how to display an ema-line.
    Bollinger Bands may be displayed by using both AdditionalInds1
    and AdditionalInds2, and at the same time stating:
      StockGraph1.StockChart.View.Show.AdditionalInds := aiBollBands;
    The TStockData component is not necessary for using TStockGraph,
    it is only used for loading example data from a file.
    Volum displayed is rescaled by 6 months average volum:
      volumScaled = 100 * volum / ema volum 6 months
    The volum senterline represent 100.
    In the unregistered version only clFuchsia is used as forground color
*)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, Spin,
  cStockData, cStockGraph;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    BtnShow: TButton;
    Panel2: TPanel;
    StockGraph1: TStockGraph;
    BtnMove: TButton;
    Steps: TComboBox;
    Scale: TComboBox;
    Label1: TLabel;
    ChartType: TComboBox;
    ForeGroundColor: TComboBox;
    StockData1: TStockData;
    BtnEma: TButton;
    VerticalMove: TSpinEdit;
    BtnLoad2: TButton;
    BtnLoad1: TButton;
    procedure BtnLoad1Click(Sender: TObject);
    procedure BtnLoad2Click(Sender: TObject);
    procedure BtnShowClick(Sender: TObject);
    procedure BtnMoveClick(Sender: TObject);
    procedure ScaleChange(Sender: TObject);
    procedure ChartTypeChange(Sender: TObject);
    procedure ForeGroundColorChange(Sender: TObject);
    procedure BtnEmaClick(Sender: TObject);
    procedure VerticalMoveChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
     StockGraph1.ClearViewStruct;
end;

procedure TForm1.BtnLoad1Click(Sender: TObject);
var
   i: Integer;
begin
     StockData1.IsOwnMaster := True;
     StockData1.LoadFromFile( ExtractFileDir( Application.ExeName)
         + '\' + 'CAT' + '.txt');
     if StockData1.FileLoaded = '' then begin
        ShowMessage( 'File load failure');
        exit;
     end;
     StockGraph1.Stock.ClearData;
     for i := 1 to StockData1.Count do begin
         StockGraph1.SetData( i,
             StockData1.Date[ i],
             StockData1.Open[ i],
             StockData1.High[ i],
             StockData1.Low[ i],
             StockData1.Close[ i],
             StockData1.Volum[ i]);
     end;
     StockGraph1.Stock.NameOfStock := StockData1.NameOfStock;
     StockGraph1.StockChart.Ticker := 'CAT';
     StockGraph1.BuildSectionIndex;
     StockGraph1.StockChart.View.DataIsReady := True;
end;

procedure TForm1.BtnLoad2Click(Sender: TObject);
var
   i: Integer;
begin
     StockData1.IsOwnMaster := True;
     StockData1.LoadFromFile( ExtractFileDir( Application.ExeName)
         + '\' + 'BUD' + '.txt');
     if StockData1.FileLoaded = '' then begin
        ShowMessage( 'File load failure');
        exit;
     end;
     StockGraph1.Stock.ClearData;
     for i := 1 to StockData1.Count do begin
         StockGraph1.SetData( i,
             StockData1.Date[ i],
             StockData1.Open[ i],
             StockData1.High[ i],
             StockData1.Low[ i],
             StockData1.Close[ i],
             StockData1.Volum[ i]);
     end;
     StockGraph1.Stock.NameOfStock := StockData1.NameOfStock;
     StockGraph1.StockChart.Ticker := 'BUD';
     StockGraph1.BuildSectionIndex;
     StockGraph1.StockChart.View.DataIsReady := True;
end;

procedure TForm1.BtnShowClick(Sender: TObject);
begin
     if not StockGraph1.StockChart.View.DataIsReady then exit;
     StockGraph1.StockChart.View.Show.AdditionalInds := aiNil;
     StockGraph1.StockChart.View.Show.BackgroundText := '';
     StockGraph1.StockChart.View.Show.SelectionText := '<Context info>';
     StockGraph1.ChangeView( 10);
     StockGraph1.Invalidate;
end;

procedure TForm1.BtnMoveClick(Sender: TObject);
begin
     StockGraph1.ChangeView( StrToInt( Steps.Text));
     StockGraph1.Invalidate;
end;

procedure TForm1.ScaleChange(Sender: TObject);
begin
     if Scale.Text = '7 months' then
        StockGraph1.ChartScale := cs7m;
     if Scale.Text = '1 year' then
        StockGraph1.ChartScale := cs1y;
     if Scale.Text = '3 years' then
        StockGraph1.ChartScale := cs3y;
     StockGraph1.Invalidate;
end;

procedure TForm1.ChartTypeChange(Sender: TObject);
begin
     if ChartType.Text = 'Bars' then
        StockGraph1.StockChart.View.Show.ChartType := ctBars;
     if ChartType.Text = 'Candlestick' then
        StockGraph1.StockChart.View.Show.ChartType := ctCandlestick;
     if ChartType.Text = 'Line' then
        StockGraph1.StockChart.View.Show.ChartType := ctLine;
     StockGraph1.Invalidate;
end;

procedure TForm1.ForeGroundColorChange(Sender: TObject);
begin
     // In the unregistered version only clFuchsia is used
     if ForeGroundColor.Text = 'Black' then begin
        StockGraph1.ForeGroundColor := clBlack;
        StockGraph1.Color := clWhite; // any color
     end;
     if ForeGroundColor.Text = 'White' then begin
        StockGraph1.ForeGroundColor := clWhite;
        StockGraph1.Color := clOlive; // any color
     end;
     if ForeGroundColor.Text = 'Yellow' then begin
        StockGraph1.ForeGroundColor := clYellow;
        StockGraph1.Color := clGray; // any color
     end;
     ShowMessage( 'Foreground color disabled in unregistered version');
     StockGraph1.Invalidate;
end;

procedure TForm1.BtnEmaClick(Sender: TObject);
var
   i: Integer;
   alpha1, alpha2: Single;
   ema: Single;
begin
     alpha1 := 2 / (40 + 1);  // 40 days
     alpha2 := 1 - alpha1;
     ema := StockData1.Close[ 1];
     for i := 2 to StockData1.Count do begin
         ema := alpha2 * ema + alpha1 * StockData1.Close[ i];
         StockGraph1.Stock.AdditionalInds1[ i] := ema;
         // StockGraph1.Stock.AdditionalInds2[ i] := ??;
     end;
     StockGraph1.StockChart.View.Show.AdditionalInds := aiEma;
     // StockGraph1.StockChart.View.Show.AdditionalInds := aiBollBands;
     StockGraph1.StockChart.View.Show.BackgroundText := 'Ema days=40';
     StockGraph1.Invalidate;
end;

procedure TForm1.VerticalMoveChange(Sender: TObject);
begin
     StockGraph1.StockChart.View.Show.VerticalMove := VerticalMove.Value;
     StockGraph1.Invalidate;
end;

end.
