unit TransparentSkin;

//{$DEFINE DELPHI3}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TTransparentSkin = class(TComponent)
  private
    { Private declarations }
    FTransparency : ShortInt;
    FFadeTime : ShortInt;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(Aowner : TComponent); override;
    procedure SetTransparency(value : ShortInt);
    procedure SetFadeTime(value : ShortInt);
    {$IFDEF DELPHI3}
    procedure SetTransparent(value : ShortInt);
    {$ELSE}
    procedure SetTransparent;overload;
    procedure SetTransparent(value : ShortInt);overload;
    {$ENDIF}
    procedure SetTransparentWindowHandle(hWnd: LongInt; value : ShortInt);
    procedure FadeOut;
    procedure FadeInTo(value : ShortInt);
  published
    { Published declarations }
    property Transparency : ShortInt read FTransparency
                                     write SetTransparency;
    property FadeTime : ShortInt read FFadeTime
                                 write SetFadeTime;

  end;

procedure GetWindowsVersion(var Major : integer; var Minor : integer);
procedure Register;

implementation

const LWA_ALPHA = $2;
const GWL_EXSTYLE = (-20);
const WS_EX_LAYERED = $80000;
const WS_EX_TRANSPARENT = $20;

constructor TTransparentSkin.Create(Aowner : TComponent);
begin
    inherited Create(Aowner);
    FTransparency := 10;
    FFadeTime := 5;
    if not (csDesigning in ComponentState) then SetTransparent(FTransparency);
end;

procedure TTransparentSkin.SetTransparency(value : ShortInt);
begin
     if FTransparency <> value then FTransparency := value;
end;

procedure TTransparentSkin.SetFadeTime(value : ShortInt);
begin
     if FFadeTime <> value then FFadeTime := value;
end;

{$IFDEF DELPHI3}
procedure TTransparentSkin.SetTransparent(value : ShortInt);
begin
     FTransparency := value;
     SetTransparentWindowHandle((self.Owner as TForm).Handle, 100 - FTransparency);
end;
{$ELSE}
procedure TTransparentSkin.SetTransparent;
begin
     SetTransparentWindowHandle((self.Owner as TForm).Handle, 100 - FTransparency);
end;

procedure TTransparentSkin.SetTransparent(value : ShortInt);
begin
     FTransparency := value;
     SetTransparentWindowHandle((self.Owner as TForm).Handle, 100 - FTransparency);
end;
{$ENDIF}

procedure TTransparentSkin.SetTransparentWindowHandle(hWnd: LongInt; value : ShortInt);
var
  major, minor : integer;
  old: longint;
  User32: Cardinal;
  SetLayeredWindowAttributes: function (hwnd: LongInt; crKey: byte; bAlpha: byte; dwFlags: LongInt): LongInt; stdcall;
begin
     GetWindowsVersion(major, minor);
     if ((major = 5) and (minor = 0)) then //Windows 2000(NT5)
     begin
        User32 := LoadLibrary('USER32');
        if User32 <> 0 then
        try
           SetLayeredWindowAttributes := GetProcAddress(User32, 'SetLayeredWindowAttributes');
           if @SetLayeredWindowAttributes <> nil then
           begin
                old := GetWindowLongA(hwnd,GWL_EXSTYLE);
                SetWindowLongA(hwnd,GWL_EXSTYLE,old or WS_EX_LAYERED);
                SetLayeredWindowAttributes(hwnd, 0, (255 * value) DIV 100, LWA_ALPHA);
           end;
        finally
                FreeLibrary(User32);
        end;
     end;
end;

procedure TTransparentSkin.FadeOut;
var
   iLoop : ShortInt;
begin
     for iLoop := FTransparency to 100 do
     begin
        FTransparency := iLoop;
        SetTransparentWindowHandle((self.Owner as TForm).Handle, 100 - FTransparency);
        Sleep(FFadeTime);
     end;

end;

procedure TTransparentSkin.FadeInTo(value : ShortInt);
var
   iLoop : ShortInt;
begin
     SetTransparent(100);
     (self.Owner as TForm).Show;
     for iLoop := 100 downto value do
     begin
        SetTransparentWindowHandle((self.Owner as TForm).Handle, 100 - iLoop);
        (self.Owner as TForm).Refresh;
        Sleep(FFadeTime);
     end;
     FTransparency := value;
end;

procedure GetWindowsVersion(var Major : integer;var Minor : integer);
var
  l : longint;
begin
  l := GetVersion;
  Major := LoByte(LoWord(l));
  Minor := HiByte(LoWord(l));
end;

procedure Register;
begin
  RegisterComponents('Add On', [TTransparentSkin]);
end;

end.
