unit skinpacker;

{$WARN UNIT_PLATFORM OFF}

interface

uses Sysutils, FileCtrl, Windows, Messages, Classes, Graphics, Controls,
     Forms, Dialogs, StdCtrls;

type
    TSkinFormFileRec = record
        ID : string[9];
        TotalFileNumbers : Byte;
        FilesName : array [1..128] of string[64];
        FilesSize : array [1..128] of LongWord;
    end;


procedure PackUpSkinFile(SkinFileFolder, targetSkinFile: string);
function UnPackSkinFile(targetSkinFile, OutputFolder: string):Boolean;

implementation

procedure PackUpSkinFile(SkinFileFolder, targetSkinFile: string);
var
  sr: TSearchRec;
  FileAttrs: Integer;
  inputfile,outputfile : File;
  inputfilename, outputfilename : string;
  loop : integer;
  NumRead, NumWritten: Integer;
  Buf: array [1..8192] of Char;
  mySkinFormFile : TSkinFormFileRec;
begin
    //check this folder
    if DirectoryExists(SkinFileFolder) then
    begin
        //find all files in this folder
        FileAttrs := 0;
        FileAttrs := FileAttrs + faAnyFile;
        mySkinFormFile.ID := 'TSKINFORM';
        mySkinFormFile.TotalFileNumbers := 0;

        if FindFirst(SkinFileFolder+'\*.*', FileAttrs, sr) = 0 then
        begin
            while FindNext(sr) = 0 do
            begin
                if ((sr.Attr and FileAttrs) = sr.Attr) AND (sr.Attr <> faDirectory ) AND (sr.Name <> '..' ) AND (sr.Name <> '.' ) AND (sr.Name <> ExtractFileName(targetSkinFile)) then
                begin
                     Inc(mySkinFormFile.TotalFileNumbers);
                     mySkinFormFile.FilesName[mySkinFormFile.TotalFileNumbers] := sr.Name;
                     mySkinFormFile.FilesSize[mySkinFormFile.TotalFileNumbers] := sr.Size;
                end;
            end;
            Sysutils.FindClose(sr);
        end
    end
    else
    begin
        raise Exception.Create('Can not find directory named - "' + SkinFileFolder + '"');
        Exit;
    end;

    outputfilename := ChangeFileExt(targetSkinFile, '.skn');
    
    AssignFile(outputfile, outputfilename);

    rewrite(outputfile, 1);
    try
        BlockWrite(outputfile, mySkinFormFile, sizeof(mySkinFormFile));

        for loop:=1 to mySkinFormFile.TotalFileNumbers do
        begin
            inputfilename := SkinFileFolder+'\'+mySkinFormFile.FilesName[loop];
            AssignFile(inputfile, inputfilename);
            reset(inputfile, 1);
            repeat
                BlockRead(inputfile, Buf, SizeOf(Buf), NumRead);
                BlockWrite(outputfile, Buf, NumRead, NumWritten);
            until (NumRead = 0) or (NumWritten <> NumRead);
            CloseFile(inputfile);
        end;
    finally
        CloseFile(outputfile);
    end;

end;

function UnPackSkinFile(targetSkinFile, OutputFolder: string):Boolean;
var
  inputfile,outputfile : File;
  outputfilename : string;
  loop : integer;
  NumRead, NumWritten: Integer;
  Buf: array [1..8192] of Char;
  filesize : longword;
  i : integer;
  mySkinFormFile : TSkinFormFileRec;
begin
    UnPackSkinFile := FALSE;

    if not DirectoryExists(OutputFolder) then
        if not ForceDirectories(OutputFolder) then
            Exit;

    Assignfile(inputfile, targetSkinFile);
    reset(inputfile, 1);
    try
        BlockRead(inputfile, mySkinFormFile, sizeof(mySkinFormFile));
        if mySkinFormFile.ID = 'TSKINFORM' then
        UnPackSkinFile := TRUE;
        begin
        for loop := 1 to mySkinFormFile.TotalFileNumbers do
        begin
            if OutputFolder[Length(OutputFolder)] <> '\' then
                 OutputFolder := OutputFolder + '\';
            outputfilename := OutputFolder+mySkinFormFile.FilesName[loop];
            AssignFile(outputfile, outputfilename);
            rewrite(outputfile, 1);

            filesize := mySkinFormFile.FilesSize[loop];

            for i := 1 to filesize div SizeOf(Buf) do
            begin
                BlockRead(inputfile, Buf, SizeOf(Buf), NumRead);
                BlockWrite(outputfile, Buf, NumRead, NumWritten);
            end;

            BlockRead(inputfile, Buf, filesize mod SizeOf(Buf), NumRead);
            BlockWrite(outputfile, Buf, NumRead, NumWritten);

            CloseFile(outputfile);
        end;
        end;
    finally
        CloseFile(inputfile);
    end;
end;

end.
