unit main;

{$WARN UNIT_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl;

type
  TMainForm = class(TForm)
    btnPack: TButton;
    btnUnPack: TButton;
    btnExit: TButton;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    procedure btnPackClick(Sender: TObject);
    procedure btnUnPackClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses skinpacker;

{$R *.DFM}

procedure TMainForm.btnPackClick(Sender: TObject);
var
    OutDir : string;
begin
    if SelectDirectory('Select Directory', '', OutDir) then
    begin
        SaveDialog.InitialDir := OutDir;
        if SaveDialog.Execute then
            PackUpSkinFile(OutDir, SaveDialog.FileName);
    end;
end;

procedure TMainForm.btnUnPackClick(Sender: TObject);
var
    OutDir : string;
begin
    if OpenDialog.Execute then
        if SelectDirectory('Select Directory', '', OutDir) then
            if UnPackSkinFile(OpenDialog.FileName, OutDir) <> TRUE then
                ShowMessage('File Format Not Correct !');
end;

procedure TMainForm.btnExitClick(Sender: TObject);
begin
    Close;
end;

end.
