unit GraphicStrings;

// This file is part of the image library GraphicEx (www.lischke-online.de/Graphics.html).
//
// GraphicStrings contains the strings used in GraphicEx which could be localized.
// Rename the file to GraphicStrings.pas to use it as your favourite language file.
//
// This is the german version of GraphicStrings.
//
// (c) Copyright 1999, 2000  Dipl. Ing. Mike Lischke (public@lischke-online.de). All rights reserved.
// Translation done by Dipl. Ing. Mike Lischke
//
// This package is freeware for non-commercial use only.
// Contact author for licenses (shareware@lischke-online.de) and see License.txt which comes with the package.

interface
                   
{$I GraphicConfiguration.inc}

resourcestring
  // image file descriptions
  gesAllImages = 'Alle Bilder';
  gesRegistration = 'Das Format %s ist schon registriert.';

  gesBitmaps = 'Windows bitmaps';
  gesRLEBitmaps = 'Run length encoded Windows bitmaps';
  gesDIBs = 'Gerteunabhngige Windows bitmaps';
  gesEPS = 'Encapsulated Postscript Bilder';
  gesIcons = 'Windows icons';
  gesMetaFiles = 'Windows metafiles';
  gesEnhancedMetaFiles = 'Windows erweiterte metafiles';
  gesJPGImages = 'JPG Bilder';
  gesJPEGImages = 'JPEG Bilder';
  gesJPEImages = 'JPE Bilder';
  gesJFIFImages = 'JFIF Bilder';
  gesTruevision = 'Truevision Bilder';
  gesTIFF = 'Tagged image file format';
  gesMacTIFF =  'Macintosh TIFF Bilder';
  gesPCTIF = 'PC TIF Bilder';
  gesGFIFax = 'GFI FAX Dateien';
  gesSGI = 'SGI Bilder';
  gesSGITrueColor = 'SGI True Color Bilder';
  gesZSoft = 'ZSoft Paintbrush Bilder';
  gesZSoftWord = 'Word 5.x Snapschuss Bilder';
  gesAliasWaveFront = 'Alias/Wavefront Bilder';
  gesSGITrueColorAlpha = 'SGI True Color Bilder mit Transparenz';
  gesSGIMono = 'SGI schwarz/weiss Bilder';
  gesPhotoshop = 'Photoshop Bilder';
  gesPortable = 'Portable map Bilder';
  gesPortablePixel = 'Portable pixel map Bilder';
  gesPortableGray = 'Portable gray map Bilder';
  gesPortableMono = 'Portable bitmap Bilder';
  gesAutoDesk = 'Autodesk Bilder';
  gesKodakPhotoCD = 'Kodak Photo-CD Bilder';
  gesCompuserve = 'CompuServe Bilder';
  gesHalo = 'Dr. Halo Bilder';
  gesPaintShopPro = 'Paintshop Pro Bilder';
  gesPortableNetworkGraphic = 'Portable network graphic Bilder';

  // image specific error messages
  gesInvalidImage = 'Bild konnte nicht geladen werden. Ungltiges oder unerwartetes %s Bildformat.';
  gesInvalidColorFormat = 'Ungltiges Farbformat in %s Bild.';
  gesStreamReadError = 'Stream Lesefehler in %s Datei.';
  gesUnsupportedImage = 'Bild konnte nicht geladen werden. Nicht untersttztes %s Bildformat.';
  gesUnsupportedFeature = 'Bild konnte nicht geladen werden. %s nicht untersttzt fr %s Dateien.';
  gesInvalidCRC = 'Bild konnte nicht geladen werden. Ein CRC Fehler ist in der %s Datei aufgetreten.';
  gesCompression = 'Bild konnte nicht geladen werden. Kompressionsfehler in %s Datei gefunden.';
  gesExtraCompressedData = 'Bild konnte nicht geladen werden. Zuviele komprimierte Daten in %s Datei gefunden.';
  gesInvalidPalette = 'Bild konnte nicht geladen werden. Palette in %s Datei ist ungltig.';
  gesUnknownCriticalChunk = 'PNG Bild konnte nicht geladen werden. Unerwarteter, aber als kritisch markierter Chunk gefunden.';

  // features (usually used together with unsupported feature string)
  gesCompressionScheme = 'Das Kompressionsformat ist';
  gesRLAPixelFormat = 'Andere Bildformat, als RGB und RGBA werden';
  gesPSPFileType = 'Andere Dateiversionen als 3 or 4 werden';

  // color manager error messages
  gesIndexedNotSupported = 'Konvertierung zwischen indizierten und nicht-indizierten Formaten wird nicht untersttzt.';
  gesConversionUnsupported = 'Farbkonvertierung schlug fehl. Es konnte keine passende Konvertierungsmethode gefunden werden.';
  gesInvalidSampleDepth = 'Farbtiefe ist nicht gltig. Bits pro Sample muss 1, 2, 4, 8 oder 16 sein.';
  gesInvalidPixelDepth = 'Sampleanzahl pro Pixel korrespondiert nicht zum angegebenen Farbschema.';
  gesInvalidSubSampling = 'Subsampling Wert ist ungltig. Erlaubt sind 1, 2 und 4.';
  gesVerticalSubSamplingError = 'Der vertikale Subsampling Wert muss kleiner oder gleich dem horizontalen Wert sein.';

  // progress strings
  gesPreparing = 'Vorbereitung...';
  gesLoadingData = 'Daten werden geladen...';
  gesUpsampling = 'Upsampling...';
  gesTransfering = 'bertragung...';

  // compression errors
  gesLZ77Error = 'LZ77 Dekompressionsfehler.';
  gesJPEGEOI = 'JPEG Dekompressionsfehler. Unerwartetes Ende der Eingabedaten.';
  gesJPEGStripSize = 'Unpassende JPEG Strip oder Tile Gre.';
  gesJPEGComponentCount = 'Unpassende JPEG Komponentenanzahl';
  gesJPEGDataPrecision = 'Unpassende JPEG Datengenauigkeit.';
  gesJPEGSamplingFactors = 'Unpassende JPEG Samplingfaktoren.';
  gesJPEGBogusTableField = 'Falsches JPEG Tabellenfeld gefunden.';
  gesJPEGFractionalLine = 'Unvollstndige JPEG Bildzeilen werden nicht understtzt.';

  // miscellaneous
  gesWarning = 'Warnung';

//----------------------------------------------------------------------------------------------------------------------

implementation

//----------------------------------------------------------------------------------------------------------------------

end.
