unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,UFormulaOperators, UFormulaParser, ComCtrls, Spin, ShellApi,
  ExtCtrls;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    Label3: TLabel;
    Label4: TLabel;
    EditFormula: TEdit;
    ButtonCalculateSingle: TButton;
    EditResult: TEdit;
    EditParser: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    EditXVariable: TEdit;
    EditXValue: TEdit;
    Label5: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    EditYVariable: TEdit;
    EditYValue: TEdit;
    EditNULLVariable: TEdit;
    EditNULLValue: TEdit;
    EditpiVariable: TEdit;
    EditpiValue: TEdit;
    Label11: TLabel;
    Label6: TLabel;
    Editformula2: TEdit;
    Label7: TLabel;
    EditX2Variable: TEdit;
    Editpi2Variable: TEdit;
    EditX2Value: TEdit;
    Editpi2Value: TEdit;
    ButtonCalculateMulti: TButton;
    Label12: TLabel;
    EditParser2: TEdit;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    EditnVariable: TEdit;
    Label17: TLabel;
    Label18: TLabel;
    SpinEditnStart: TSpinEdit;
    SpinEditnStop: TSpinEdit;
    MemoResults: TMemo;
    Label19: TLabel;
    Memo1: TMemo;
    Label20: TLabel;
    Label21: TLabel;
    EditCalculationError: TEdit;
    EditCalculationError2: TEdit;
    Label22: TLabel;
    TabSheet4: TTabSheet;
    Label23: TLabel;
    EditFormula3: TEdit;
    Label24: TLabel;
    EditX3Variable: TEdit;
    EditX3Value: TEdit;
    Label25: TLabel;
    ButtonCalculateOperators: TButton;
    Label27: TLabel;
    EditParser3: TEdit;
    Label28: TLabel;
    EditCalculationError3: TEdit;
    Label29: TLabel;
    EditResult3: TEdit;
    Label30: TLabel;
    CheckBoxPlus: TCheckBox;
    Label31: TLabel;
    SpinEditPlusPriority: TSpinEdit;
    CheckBoxMinus: TCheckBox;
    Label32: TLabel;
    SpinEditMinusPriority: TSpinEdit;
    CheckBoxMult: TCheckBox;
    Label33: TLabel;
    SpinEditMultPriority: TSpinEdit;
    CheckBoxDiv: TCheckBox;
    Label34: TLabel;
    SpinEditDivPriority: TSpinEdit;
    CheckBoxSin: TCheckBox;
    Label35: TLabel;
    SpinEditSinPriority: TSpinEdit;
    CheckBoxCos: TCheckBox;
    Label36: TLabel;
    SpinEditCosPriority: TSpinEdit;
    EditPI3Variable: TEdit;
    Label38: TLabel;
    EditPI3Value: TEdit;
    Label26: TLabel;
    Panel1: TPanel;
    Label37: TLabel;
    Label39: TLabel;
    Splitter1: TSplitter;
    procedure FormCreate(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    function OnVariable (Name: String; var Answer, Error: String): Boolean;
    function OnVariable2 (Name: String; var Answer, Error: String): Boolean;
    function OnVariable3 (Name: String; var Answer, Error: String): Boolean;
    procedure ButtonCalculateSingleClick(Sender: TObject);
    procedure ButtonCalculateMultiClick(Sender: TObject);
    procedure ButtonCalculateOperatorsClick(Sender: TObject);
    procedure Label39Click(Sender: TObject);
    private
      F_Current_n : String;
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
  close;
end;

function TForm1.OnVariable(Name: String; var Answer,
  Error: String): Boolean;
begin
  Name := lowercase(Name);
  if Name = lowercase(EditXVariable.text) then begin
    Answer := EditXValue.text;
    result := true;
  end
  else if Name = lowercase(EditYVariable.text) then begin
    Answer := EditYValue.text;
    result := true;
  end
  else if Name = lowercase(EditNULLVariable.text) then begin
    Answer := EditNULLValue.text;
    result := true;
  end
  else if Name = lowercase(EditpiVariable.text) then begin
    Answer := EditpiValue.text;
    result := true;
  end
  else begin
    result := false;
    Answer :='';
    Error := 'Variable: "' + Name + '" is unknown.';
  end;
end;

procedure TForm1.ButtonCalculateSingleClick(Sender: TObject);
var
  s, Answer: String;
  FP: TFormulaParser;
begin
  FP := TFormulaParser.create;
  FP.Formula := EditFormula.Text;
  s:='Successful parsed';
  if FP.Parse(s) then begin
    EditParser.text := s;
    FP.Callback := OnVariable;
    if FP.Calculate(Answer, s) then begin
      EditResult.text := Answer;
      EditCalculationError.text := 'No calculation error.';
    end else begin
      EditResult.text := '';
      EditCalculationError.text := s;
    end;
  end else begin
    EditParser.text := s;
    EditResult.text := '';
    EditCalculationError.text := '';
  end;
  FP.Free;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  PageControl1.ActivePage := TabSheet1;
  EditpiValue.Text := FloatToStr(pi);
  Editpi2Value.Text := FloatToStr(pi);
  Editpi3Value.Text := FloatToStr(pi);
end;

procedure TForm1.ButtonCalculateMultiClick(Sender: TObject);
var
  s, Answer: String;
  FP: TFormulaParser;
  i: Integer;
begin
  MemoResults.clear;
  FP := TFormulaParser.create;
  FP.Formula := EditFormula2.Text;
  s:='Successful parsed';
  if FP.Parse(s) then begin
    EditParser2.text := s;
    FP.Callback := OnVariable2;
    s := 'No calculation error.';
    if SpinEditnStart.value <= SpinEditnStop.value then begin
      for i := SpinEditnStart.value to SpinEditnStop.value do begin
        str(i,F_Current_n);
        if FP.Calculate(Answer, s) then begin
          MemoResults.Lines.add(Answer);
          s := 'No calculation error.';
        end else begin
          break;
        end;
      end;
      EditCalculationError2.text := s
    end else begin
      for i := SpinEditnStart.value downto SpinEditnStop.value do begin
        str(i,F_Current_n);
        if FP.Calculate(Answer, s) then begin
          MemoResults.Lines.add(Answer);
          s := 'No calculation error.';
        end else begin
          break;
        end;
      end;
      EditCalculationError2.text := s
    end;
  end else begin
    EditParser2.text := s;
    EditCalculationError2.text := '';
  end;
  FP.Free;
end;

function TForm1.OnVariable2(Name: String; var Answer,
  Error: String): Boolean;
begin
  Name := lowercase(Name);
  if Name = lowercase(EditX2Variable.text) then begin
    Answer := EditX2Value.text;
    result := true;
  end
  else if Name = lowercase(Editpi2Variable.text) then begin
    Answer := Editpi2Value.text;
    result := true;
  end
  else if Name = lowercase(EditnVariable.text) then begin
    Answer := F_Current_n;
    result := true;
  end
  else begin
    result := false;
    Answer :='';
    Error := 'Variable: "' + Name + '" is unknown.';
  end;
end;

procedure TForm1.ButtonCalculateOperatorsClick(Sender: TObject);
var
  s, Answer: String;
  FP: TFormulaParser;
  OP: TFormulaOperator;
begin
  FP := TFormulaParser.create;

  if CheckBoxPlus.checked then begin
    OP := TFormulaOperator_Addition.create(SpinEditPlusPriority.Value);
    FP.AddOperator(OP)
  end else begin
    FP.RemoveBinaryOperatorByName('+');
  end;
  if CheckBoxMinus.checked then begin
    OP := TFormulaOperator_Subtraction.create(SpinEditMinusPriority.Value);
    FP.AddOperator(OP)
  end else begin
    FP.RemoveBinaryOperatorByName('-');
  end;
  if CheckBoxMult.checked then begin
    OP := TFormulaOperator_Multiplication.create(SpinEditMultPriority.Value);
    FP.AddOperator(OP)
  end else begin
    FP.RemoveBinaryOperatorByName('*');
  end;
  if CheckBoxDiv.checked then begin
    OP := TFormulaOperator_Division.create(SpinEditDivPriority.Value);
    FP.AddOperator(OP)
  end else begin
    FP.RemoveBinaryOperatorByName('/');
  end;
  if CheckBoxSin.checked then begin
    OP := TFormulaOperator_Sinus.create(SpinEditSinPriority.Value);
    FP.AddOperator(OP)
  end else begin
    FP.RemoveUnaryOperatorByName('sin');
  end;
  if CheckBoxCos.checked then begin
    OP := TFormulaOperator_Cosinus.create(SpinEditCosPriority.Value);
    FP.AddOperator(OP)
  end else begin
    FP.RemoveUnaryOperatorByName('cos');
  end;

  FP.ReorganizePriorities;
  FP.Formula := EditFormula3.Text;
  s:='Successful parsed';
  if FP.Parse(s) then begin
    EditParser3.text := s;
    FP.Callback := OnVariable3;
    if FP.Calculate(Answer, s) then begin
      EditResult3.text := Answer;
      EditCalculationError3.text := 'No calculation error.';
    end else begin
      EditResult3.text := '';
      EditCalculationError3.text := s;
    end;
  end else begin
    EditParser3.text := s;
    EditResult3.text := '';
    EditCalculationError3.text := '';
  end;
  FP.Free;
end;

function TForm1.OnVariable3(Name: String; var Answer,
  Error: String): Boolean;
begin
  Name := lowercase(Name);
  if Name = lowercase(EditX3Variable.text) then begin
    Answer := EditX3Value.text;
    result := true;
  end
  else if Name = lowercase(Editpi3Variable.text) then begin
    Answer := Editpi3Value.text;
    result := true;
  end
  else begin
    result := false;
    Answer :='';
    Error := 'Variable: "' + Name + '" is unknown.';
  end;
end;

procedure TForm1.Label39Click(Sender: TObject);
begin
  ShellExecute(Handle,
               nil,
               'http://www.ibhalbauer.de/Components/components.html',
               nil,
               nil,
               SW_ShowNormal);
end;

end.
