unit UFormulaOperators;

interface

uses sysutils, classes, math, UFormulaParser;

type TFormulaOperator_Addition = class(TFormulaOperator)
  public
    function Calculate(Argument1, Argument2: String; var Answer, Error: String):Boolean; override;
    constructor Create(Priority: Integer);
  end;

type TFormulaOperator_Subtraction = class(TFormulaOperator)
  public
    function Calculate(Argument1, Argument2: String; var Answer, Error: String):Boolean; override;
    constructor Create(Priority: Integer);
  end;

type TFormulaOperator_Multiplication = class(TFormulaOperator)
  public
    function Calculate(Argument1, Argument2: String; var Answer, Error: String):Boolean; override;
    constructor Create(Priority: Integer);
  end;

type TFormulaOperator_Division = class(TFormulaOperator)
  public
    function Calculate(Argument1, Argument2: String; var Answer, Error: String):Boolean; override;
    constructor Create(Priority: Integer);
  end;

type TFormulaOperator_unaryMinus = class(TFormulaOperator)
  public
    function Calculate(Argument1, Argument2: String; var Answer, Error: String):Boolean; override;
    constructor Create(Priority: Integer);
  end;

type TFormulaOperator_Sinus = class(TFormulaOperator)
  public
    function Calculate(Argument1, Argument2: String; var Answer, Error: String):Boolean; override;
    constructor Create(Priority: Integer);
  end;

type TFormulaOperator_Cosinus = class(TFormulaOperator)
  public
    function Calculate(Argument1, Argument2: String; var Answer, Error: String):Boolean; override;
    constructor Create(Priority: Integer);
  end;

type TFormulaOperator_Tangens = class(TFormulaOperator)
  public
    function Calculate(Argument1, Argument2: String; var Answer, Error: String):Boolean; override;
    constructor Create(Priority: Integer);
  end;

type TFormulaOperator_ArcusSinus = class(TFormulaOperator)
  public
    function Calculate(Argument1, Argument2: String; var Answer, Error: String):Boolean; override;
    constructor Create(Priority: Integer);
  end;

type TFormulaOperator_ArcusCosinus = class(TFormulaOperator)
  public
    function Calculate(Argument1, Argument2: String; var Answer, Error: String):Boolean; override;
    constructor Create(Priority: Integer);
  end;

type TFormulaOperator_ArcusTangens = class(TFormulaOperator)
  public
    function Calculate(Argument1, Argument2: String; var Answer, Error: String):Boolean; override;
    constructor Create(Priority: Integer);
  end;

implementation

{Lokal}

{ TFormulaOperator_Plus }

function TFormulaOperator_Addition.Calculate(Argument1, Argument2: String;
  var Answer, Error: String): Boolean;
var
  x,k: Extended;
begin
  result := true;
  Answer := 'ERROR';
  Error := 'unknown error in addition.';
  if not Own_StrToFloat(Argument1, x) then begin
    Error := '"' + Argument1 + '" is not a valid floating number. Addition not possible.';
    result := false;
    exit;
  end;
  if not Own_StrToFloat(Argument2, k) then begin
    Error := '"' + Argument2 + '" is not a valid floating number. Addition not possible.';
    result := false;
    exit;
  end;
  if not Own_FloatToStr(x + k, Answer) then begin
    Error := '"' + Argument1 + ' + ' + Argument2 + '". Error in addition.';
    result := false;
    exit;
  end;
end;

constructor TFormulaOperator_Addition.Create(Priority: Integer);
begin
  F_Name := '+';
  F_unary := false;
  F_Priority := Priority;
  F_ReverseOperatorFirst := '';
  F_ReverseOperatorSecond := '';
end;

{ TFormulaOperator_Subtraction }

function TFormulaOperator_Subtraction.Calculate(Argument1,
  Argument2: String; var Answer, Error: String): Boolean;
var
  x,k: Extended;
begin
  result := true;
  Answer := 'ERROR';
  Error := 'unknown error in substraction.';
  if not Own_StrToFloat(Argument1, x) then begin
    Error := '"' + Argument1 + '" is not a valid floating number. Subtraction not possible.';
    result := false;
    exit;
  end;
  if not Own_StrToFloat(Argument2, k) then begin
    Error := '"' + Argument2 + '" is not a valid floating number. Subtraction not possible.';
    result := false;
    exit;
  end;
  if not Own_FloatToStr(x - k, Answer) then begin
    Error := '"' + Argument1 + ' - ' + Argument2 + '". Error in subtraction.';
    result := false;
    exit;
  end;
end;

constructor TFormulaOperator_Subtraction.Create(Priority: Integer);
begin
  F_Name := '-';
  F_unary := false;
  F_Priority := Priority;
  F_ReverseOperatorFirst := '';
  F_ReverseOperatorSecond := '';
end;

{ TFormulaOperator_Multiplication }

function TFormulaOperator_Multiplication.Calculate(Argument1,
  Argument2: String; var Answer, Error: String): Boolean;
var
  x,k: Extended;
begin
  result := true;
  Answer := 'ERROR';
  Error := 'unknown error in multiplication.';
  if not Own_StrToFloat(Argument1, x) then begin
    Error := '"' + Argument1 + '" is not a valid floating number. Multiplication not possible.';
    result := false;
    exit;
  end;
  if not Own_StrToFloat(Argument2, k) then begin
    Error := '"' + Argument2 + '" is not a valid floating number. Multiplication not possible.';
    result := false;
    exit;
  end;
  if not Own_FloatToStr(x * k, Answer) then begin
    Error := '"' + Argument1 + ' * ' + Argument2 + '". Error in multiplication.';
    result := false;
    exit;
  end;
end;

constructor TFormulaOperator_Multiplication.Create(Priority: Integer);
begin
  F_Name := '*';
  F_unary := false;
  F_Priority := Priority;
  F_ReverseOperatorFirst := '';
  F_ReverseOperatorSecond := '';
end;

{ TFormulaOperator_Division }

function TFormulaOperator_Division.Calculate(Argument1, Argument2: String;
  var Answer, Error: String): Boolean;
var
  x,k: Extended;
begin
  result := true;
  Answer := 'ERROR';
  Error := 'unknown error in division.';
  if not Own_StrToFloat(Argument1, x) then begin
    Error := '"' + Argument1 + '" is not a valid floating number. Division not possible.';
    result := false;
    exit;
  end;
  if not Own_StrToFloat(Argument2, k) then begin
    Error := '"' + Argument2 + '" is not a valid floating number. Division not possible.';
    result := false;
    exit;
  end;
  if k = 0 then begin
    Error := '"' + Argument1 + ' / ' + Argument2 + '". Error: Division by zero.';
    result := false;
    exit;
  end;
  if not Own_FloatToStr(x / k, Answer) then begin
    Error := '"' + Argument1 + ' / ' + Argument2 + '". Error in Division.';
    result := false;
    exit;
  end;
end;

constructor TFormulaOperator_Division.Create(Priority: Integer);
begin
  F_Name := '/';
  F_unary := false;
  F_Priority := Priority;
  F_ReverseOperatorFirst := '';
  F_ReverseOperatorSecond := '';
end;

{ TFormulaOperator_unaryMinus }

function TFormulaOperator_unaryMinus.Calculate(Argument1, Argument2: String;
  var Answer, Error: String): Boolean;
var
  x: Extended;
begin
  result := true;
  Answer := 'ERROR';
  Error := 'unknown error in unary minus.';
  if not Own_StrToFloat(Argument1, x) then begin
    Error := '"' + Argument1 + '" is not a valid floating number. Unary minus not possible.';
    result := false;
    exit;
  end;
  if not Own_FloatToStr(-x, Answer) then begin
    Error := '"-' + Argument1 + '". Error in unary minus.';
    result := false;
    exit;
  end;
end;

constructor TFormulaOperator_unaryMinus.Create(Priority: Integer);
begin
  F_Name := '-';
  F_unary := true;
  F_Priority := Priority;
  F_ReverseOperatorFirst := '-y';
  F_ReverseOperatorSecond := '';
end;

{ TFormulaOperator_Sinus }

function TFormulaOperator_Sinus.Calculate(Argument1, Argument2: String;
  var Answer, Error: String): Boolean;
var
  x: Extended;
begin
  result := true;
  Answer := 'ERROR';
  Error := 'unknown error in sinus.';
  if not Own_StrToFloat(Argument1, x) then begin
    Error := '"' + Argument1 + '" is not a valid floating number. Sinus not possible.';
    result := false;
    exit;
  end;
  if not Own_FloatToStr(sin(x), Answer) then begin
    Error := '"sin ' + Argument1 + '". Error in sinus.';
    result := false;
    exit;
  end;
end;

constructor TFormulaOperator_Sinus.Create(Priority: Integer);
begin
  F_Name := 'sin';
  F_unary := true;
  F_Priority := Priority;
  F_ReverseOperatorFirst := 'arcsin y';
  F_ReverseOperatorSecond := '';
end;

{ TFormulaOperator_Cosinus }

function TFormulaOperator_Cosinus.Calculate(Argument1, Argument2: String;
  var Answer, Error: String): Boolean;
var
  x: Extended;
begin
  result := true;
  Answer := 'ERROR';
  Error := 'unknown error in cosinus.';
  if not Own_StrToFloat(Argument1, x) then begin
    Error := '"' + Argument1 + '" is not a valid floating number. Cosinus not possible.';
    result := false;
    exit;
  end;
  if not Own_FloatToStr(cos(x), Answer) then begin
    Error := '"cos ' + Argument1 + '". Error in cosinus.';
    result := false;
    exit;
  end;
end;

constructor TFormulaOperator_Cosinus.Create(Priority: Integer);
begin
  F_Name := 'cos';
  F_unary := true;
  F_Priority := Priority;
  F_ReverseOperatorFirst := 'arccos y';
  F_ReverseOperatorSecond := '';
end;

{ TFormulaOperator_Tangens }

function TFormulaOperator_Tangens.Calculate(Argument1, Argument2: String;
  var Answer, Error: String): Boolean;
var
  x: Extended;
begin
  result := true;
  Answer := 'ERROR';
  Error := 'unknown error in tangens.';
  if not Own_StrToFloat(Argument1, x) then begin
    Error := '"' + Argument1 + '" is not a valid floating number. Tangens not possible.';
    result := false;
    exit;
  end;
  if cos(x) = 0  then begin
    Error := '"tan ' + Argument1 + '". Error: Tangens is undefined for this value.';
    result := false;
    exit;
  end;
  if not Own_FloatToStr(tan(x), Answer) then begin
    Error := '"tan ' + Argument1 + '". Error in tangens.';
    result := false;
    exit;
  end;
end;

constructor TFormulaOperator_Tangens.Create(Priority: Integer);
begin
  F_Name := 'tan';
  F_unary := true;
  F_Priority := Priority;
  F_ReverseOperatorFirst := 'arctan y';
  F_ReverseOperatorSecond := '';
end;


{ TFormulaOperator_ArcusSinus }

function TFormulaOperator_ArcusSinus.Calculate(Argument1, Argument2: String;
  var Answer, Error: String): Boolean;
var
  x: Extended;
begin
  result := true;
  Answer := 'ERROR';
  Error := 'unknown error in arcus sinus.';
  if not Own_StrToFloat(Argument1, x) then begin
    Error := '"' + Argument1 + '" is not a valid floating number. Arcus sinus not possible.';
    result := false;
    exit;
  end;
  while x > 1
    do x := x - 2;
  while x < -1
    do x := x + 2;
  if not Own_FloatToStr(arcsin(x), Answer) then begin
    Error := '"arcsin ' + Argument1 + '". Error in arcus sinus.';
    result := false;
    exit;
  end;
end;

constructor TFormulaOperator_ArcusSinus.Create(Priority: Integer);
begin
  F_Name := 'arcsin';
  F_unary := true;
  F_Priority := Priority;
  F_ReverseOperatorFirst := 'sin y';
  F_ReverseOperatorSecond := '';
end;

{ TFormulaOperator_ArcusCosinus }

function TFormulaOperator_ArcusCosinus.Calculate(Argument1,
  Argument2: String; var Answer, Error: String): Boolean;
var
  x: Extended;
begin
  result := true;
  Answer := 'ERROR';
  Error := 'unknown error in arcus cosinus.';
  if not Own_StrToFloat(Argument1, x) then begin
    Error := '"' + Argument1 + '" is not a valid floating number. Arcus cosinus not possible.';
    result := false;
    exit;
  end;
  while x > 1
    do x := x - 2;
  while x < -1
    do x := x + 2;
  if not Own_FloatToStr(arccos(x), Answer) then begin
    Error := '"arccos ' + Argument1 + '". Error in arcus cosinus.';
    result := false;
    exit;
  end;
end;

constructor TFormulaOperator_ArcusCosinus.Create(Priority: Integer);
begin
  F_Name := 'arccos';
  F_unary := true;
  F_Priority := Priority;
  F_ReverseOperatorFirst := 'cos y';
  F_ReverseOperatorSecond := '';
end;

{ TFormulaOperator_ArcusTangens }

function TFormulaOperator_ArcusTangens.Calculate(Argument1,
  Argument2: String; var Answer, Error: String): Boolean;
var
  x: Extended;
begin
  result := true;
  Answer := 'ERROR';
  Error := 'unknown error in arcus tangens.';
  if not Own_StrToFloat(Argument1, x) then begin
    Error := '"' + Argument1 + '" is not a valid floating number. Arcus tangens not possible.';
    result := false;
    exit;
  end;
  if not Own_FloatToStr(arctan(x), Answer) then begin
    Error := '"arctan ' + Argument1 + '". Error in arcus tangens.';
    result := false;
    exit;
  end;
end;

constructor TFormulaOperator_ArcusTangens.Create(Priority: Integer);
begin
  F_Name := 'arctan';
  F_unary := true;
  F_Priority := Priority;
  F_ReverseOperatorFirst := 'tan y';
  F_ReverseOperatorSecond := '';
end;

end.
