unit Main;

interface

uses
  Classes, Forms, ComCtrls, StdCtrls, Dialogs, SysUtils,
  Controls, AutoUpgrade, Menus;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    ProgressBar: TProgressBar;
    AutoUpgrade: TAutoUpgrade;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    About1: TMenuItem;
    Exit1: TMenuItem;
    Checkprogramupdates1: TMenuItem;
    procedure AutoUpgradeError(Sender: TObject);
    procedure AutoUpgradeDone(Sender: TObject; FileSize: Integer);
    procedure Checkprogramupdates1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure AutoUpgradeProgress(Sender: TObject; TotalSize,
      Readed: Integer);
    procedure AutoUpgradeUpgrade(Sender: TObject; UsersServed: Integer;
      var ShowMessage, CanUpgrade: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

// ---- AutoUpgrader ----

procedure TForm1.AutoUpgradeError(Sender: TObject);
begin
  ShowMessage('Connection with server failed.');
end;

procedure TForm1.AutoUpgradeDone(Sender: TObject; FileSize: Integer);
begin
  ShowMessage('Upgrading has completed successfully.'#13#10'Press Ok to restart.');
end;

procedure TForm1.AutoUpgradeProgress(Sender: TObject; TotalSize,
  Readed: Integer);
begin
  ProgressBar.Visible := True;
  ProgressBar.Max := TotalSize;
  ProgressBar.Position := Readed;
end;

procedure TForm1.AutoUpgradeUpgrade(Sender: TObject; UsersServed: Integer;
  var ShowMessage, CanUpgrade: Boolean);
begin
  Caption := 'Upgrading. . . BTW, you are ' + IntToStr(UsersServed) + ' served user';
end;

// ----- Menu -----

procedure TForm1.Checkprogramupdates1Click(Sender: TObject);
begin
  AutoUpgrade.GetInfo;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

end.
