unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, AczDbTreeView, Buttons, Grids, Db, DBTables, ImgList;

const
  FileNameDefined = '.\AczTreeFile';
type
  TFormDemo = class(TForm)
    GroupAddLeafNode: TGroupBox;
    Label3: TLabel;
    EditNewLeafName: TEdit;
    ButtonAddNode: TButton;
    GroupSelected: TGroupBox;
    Label1: TLabel;
    EditSelectedID: TEdit;
    ButtonGetNodeID: TButton;
    Label2: TLabel;
    MemoSelectedPath: TMemo;
    ButtonGetSelectedPath: TButton;
    Label4: TLabel;
    EditParentID: TEdit;
    ButtonGetParentID: TButton;
    Label7: TLabel;
    EditNewURL: TEdit;
    Label8: TLabel;
    EditNewLang: TEdit;
    Label5: TLabel;
    EditURL: TEdit;
    Label6: TLabel;
    EditLang: TEdit;
    ButtonGetOtherInfo: TButton;
    ButtonDeleteNode: TButton;
    GroupBoxAddGroupNode: TGroupBox;
    Label9: TLabel;
    EditNewGroupName: TEdit;
    ButtonAddGroupNode: TButton;
    ImageList1: TImageList;
    ButtonClearTree: TSpeedButton;
    ButtonQuit: TSpeedButton;
    UserTable: TTable;
    DataSource1: TDataSource;
    GroupBox1: TGroupBox;
    Label10: TLabel;
    EditNewRootName: TEdit;
    ButtonAddRoot: TButton;
    AczDbTreeView1: TAczDbTreeView;
    ButtonCutNode: TSpeedButton;
    ButtonCopyNode: TSpeedButton;
    ButtonPasteNode: TSpeedButton;
    procedure ButtonLoadTreeClick(Sender: TObject);
    procedure ButtonAddRootNodeClick(Sender: TObject);
    procedure ButtonAddGroupNodeClick(Sender: TObject);
    procedure ButtonAddLeafNodeClick(Sender: TObject);
    procedure ButtonGetNodeIDClick(Sender: TObject);
    procedure ButtonGetSelectedPathClick(Sender: TObject);
    procedure ButtonClearTreeClick(Sender: TObject);
    procedure ButtonGetParentIDClick(Sender: TObject);
    procedure ButtonQuitClick(Sender: TObject);
    procedure ButtonGetOtherInfoClick(Sender: TObject);
    procedure ButtonDeleteNodeClick(Sender: TObject);
    procedure AczDbTreeView1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ClearAllEdit;
    procedure ButtonLoadExpandedTreeClick(Sender: TObject);
    procedure AczDbTreeView1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ButtonCutNodeClick(Sender: TObject);
    procedure ButtonCopyNodeClick(Sender: TObject);
    procedure ButtonPasteNodeClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormDemo: TFormDemo;

implementation

{$R *.DFM}


procedure TFormDemo.ButtonLoadTreeClick(Sender: TObject);
begin
{ AczDbTreeView1.Items.Clear; }

  { Call LoadTree procedure of AczDbTreeView1 to load all nodes of the tree from the file,
    when having been loaded, all nodes are not expanded. }
{  AczDbTreeView1.LoadTree;  }
  ClearAllEdit;
end;

procedure TFormDemo.ButtonLoadExpandedTreeClick(Sender: TObject);
begin
{ AczDbTreeView1.Items.Clear; }

  { Call LoadExpandedTree procedure of AczDbTreeView1 to load all nodes of the tree from the file,
    when having been loaded, all nodes are expanded or not expanded as they were saved. }
{  AczDbTreeView1.LoadExpandedTree;   }
  ClearAllEdit;
end;

procedure TFormDemo.ButtonAddLeafNodeClick(Sender: TObject);
var
  NewNode: TTreeNode;
  NodeID: integer;
begin
  { Checking }
  if EditNewLeafName.GetTextLen = 0 then
  begin
    ShowMessage( 'There is no node name specified !' );
    exit;
  end;
  if EditNewURL.GetTextLen = 0 then
  begin
    ShowMessage( 'There is no URL specified !' );
    exit;
  end;
  if EditNewLang.GetTextLen = 0 then
  begin
    ShowMessage( 'There is no language specified !' );
    exit;
  end;
  if AczDbTreeView1.Items.Count = 0 then
  begin
    ShowMessage( 'There is not a root group !' );
    exit;
  end;

  { Call AddNewNode function of the AczDbTreeView1 to add a new node to the tree }
  NewNode := AczDbTreeView1.AddNewNode(AczDbTreeView1.Selected, EditNewLeafName.Text, 3, 3);
  NewNode.ImageIndex := 3;
  NewNode.SelectedIndex := 3;

  { Insert the node's information into User's Table }
  if ( Length(EditNewURL.Text)>0 ) and ( Length(EditNewLang.Text)>0 ) then
  with UserTable do
  begin
    try
      DisableControls;
      Edit;
      FieldByName( 'URL' ).AsString := EditNewURL.Text;
      FieldByName( 'Language' ).AsString := EditNewLang.Text;
      post;
      Close;
      EnableControls;
    except
      ShowMessage('Updating Table Urlbook Error');
    end;
  end;
  EditNewLeafName.Clear;
  EditNewURL.Clear;
  EditNewLang.Clear;
end;

procedure TFormDemo.ButtonGetNodeIDClick(Sender: TObject);
begin
  { Checking }
  if ( AczDbTreeView1.Items.Count = 0 ) or ( AczDbTreeView1.Selected = nil ) then
  begin
    ShowMessage( 'There is no node selected !' );
    exit;
  end;
  { Call GetNodeID function of AczDbTreeView1 to get the ID of currently selected node }
  EditSelectedID.Text := IntToStr( AczDbTreeView1.GetNodeID(AczDbTreeView1.Selected) );
end;

procedure TFormDemo.ButtonGetSelectedPathClick(Sender: TObject);
begin
  { Checking }
  if ( AczDbTreeView1.Items.Count = 0 ) or ( AczDbTreeView1.Selected = nil ) then
  begin
    ShowMessage( 'There is no node selected !' );
    exit;
  end;
  { Call GetPath function of AczDbTreeView1 to get the path of currently selected node }
  with MemoSelectedPath do
  begin
    Clear;
    Lines.Add( '' );
    Lines[1] := AczDbTreeView1.GetPath( AczDbTreeView1.Selected );
  end;
end;

procedure TFormDemo.ButtonClearTreeClick(Sender: TObject);
begin
  AczDbTreeView1.Items.Clear;
  ClearAllEdit;
end;

procedure TFormDemo.ButtonGetParentIDClick(Sender: TObject);
begin
  { Checking }
  if ( AczDbTreeView1.Items.Count = 0 ) or ( AczDbTreeView1.Selected = nil ) then
  begin
    ShowMessage( 'There is no node selected !' );
    exit;
  end;
  { Call GetNodeID function of AczDbTreeView1 to get the ID of the parent node of currently selected node }
  EditParentID.Text := IntToStr( AczDbTreeView1.GetNodeID( AczDbTreeView1.Selected.Parent ) );
end;

procedure TFormDemo.ButtonQuitClick(Sender: TObject);
begin
  FormDemo.Close;
end;

procedure TFormDemo.ButtonGetOtherInfoClick(Sender: TObject);
begin
  { Checking }
  if ( AczDbTreeView1.Items.Count = 0 ) or ( AczDbTreeView1.Selected = nil ) then
  begin
    ShowMessage( 'There is no node selected !' );
    exit;
  end;
  if AczDbTreeView1.Selected.HasChildren then
  begin
    ShowMessage( 'The selected node is not a leaf !' );
    exit;
  end;
  { At first call function GetNodeID of AczDbTreeView1 to get the ID of currently selected node,
    then use the node's ID as a key value to search information in the user's table }
  with UserTable do
  begin
    try
      Open;
      EditURL.Text  := FieldByName( 'URL' ).AsString ;
      EditLang.Text := FieldByName( 'Language' ).AsString ;
    except
      ShowMessage( 'Read Table Urlbook Error' );
    end;
  end;
end;

procedure TFormDemo.ButtonDeleteNodeClick(Sender: TObject);
begin
  { Checking }
  if ( AczDbTreeView1.Items.Count = 0 ) or ( AczDbTreeView1.Selected = nil ) then
  begin
    ShowMessage( 'There is no node selected !' );
    exit;
  end;

  { Delete the node selected }
  try
    AczDbTreeView1.Selected.Delete;
  except
    ShowMessage( 'Delete selected node error !' );
  end;
end;

procedure TFormDemo.AczDbTreeView1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  ClearAllEdit;
end;

procedure TFormDemo.ButtonAddRootNodeClick(Sender: TObject);
var
  NewNode: TTreeNode;
begin
  { Checking }
  if EditNewRootName.GetTextLen = 0 then
  begin
    ShowMessage( 'There is no root name specified !' );
    exit;
  end;

  { Call AddNewNode function of AczDbTreeView1 to add a new node to the tree }
  NewNode := AczDbTreeView1.AddRoot(EditNewRootName.Text, 0, 0);
  NewNode.ImageIndex := 0;
  NewNode.SelectedIndex := 0;
  ClearAllEdit;
end;

procedure TFormDemo.ButtonAddGroupNodeClick(Sender: TObject);
var
  NewNode: TTreeNode;
begin
  { Checking }
  if EditNewGroupName.GetTextLen = 0 then
  begin
    ShowMessage( 'There is no node name specified !' );
    exit;
  end;

  { Call AddNewNode function of AczDbTreeView1 to add a new node to the tree }
  if AczDbTreeView1.Items.Count = 0 then
  begin
    NewNode := AczDbTreeView1.AddNewNode(nil, EditNewGroupName.Text, 0, 0);
    NewNode.ImageIndex := 0;
    NewNode.SelectedIndex := 0;
  end
  else
  begin
    NewNode := AczDbTreeView1.AddNewNode(AczDbTreeView1.Selected, EditNewGroupName.Text, 1, 2);
    NewNode.ImageIndex := 1;
    NewNode.SelectedIndex := 2;
  end;
  ClearAllEdit;
end;

procedure TFormDemo.ClearAllEdit;
begin
  EditNewGroupName.Clear;
  EditNewLeafName.Clear;
  EditNewURL.Clear;
  EditNewLang.Clear;
  EditSelectedID.Clear;
  MemoSelectedPath.Clear;
  EditParentID.Clear;
  EditURL.Clear;
  EditLang.Clear;
end;

procedure TFormDemo.AczDbTreeView1Click(Sender: TObject);
begin
  ClearAllEdit;
end;

procedure TFormDemo.FormCreate(Sender: TObject);
begin
 { AczDbTreeView1.RegisterAcz ('Your Serial Number', 'Your Active Number'); }
  try
    UserTable.Open;
  except
    ShowMessage('User Table Open Error');
  end;
  with AczDbTreeView1 do
  begin
    DataSource:=DataSource1;
    IDFieldName := 'NodeID';
    NodeTextFieldName := 'NodeText';
    ExpandedFieldName := 'Expanded';
    ParentIDFieldName := 'ParentID';
    ImageIndexFieldName := 'ImageIndex';
    SelectedIndexFieldName := 'SelectedIndex';
    EnableDataLink ;
  end;

end;

procedure TFormDemo.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  AczDbTreeView1.Destroy;
  UserTable.Close;
end;


procedure TFormDemo.ButtonCutNodeClick(Sender: TObject);
begin
  AczDbTreeView1.CutNode;
end;

procedure TFormDemo.ButtonCopyNodeClick(Sender: TObject);
begin
  AczDbTreeView1.CopyNode;
end;

procedure TFormDemo.ButtonPasteNodeClick(Sender: TObject);
begin
  AczDbTreeView1.PasteNode;
end;

end.
