unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, ToolEdit, Buttons, ComObj, AVSecure,
  ComCtrls, ExtCtrls, jpeg;

type
  TForm1 = class(TForm)
    P1: TPanel;
    P2: TPanel;
    RBLocal: TRadioButton;
    RBOtra: TRadioButton;
    RBProv: TRadioButton;
    RBDef: TRadioButton;
    P3: TPanel;
    Label4: TLabel;
    Label6: TLabel;
    Label5: TLabel;
    P4: TPanel;
    EdIns: TEdit;
    P5: TPanel;
    Panel6: TPanel;
    BtnL: TButton;
    BtnR: TButton;
    BtnCancel: TButton;
    P0: TPanel;
    BtnDatos: TSpeedButton;
    P6: TPanel;
    Memo1: TMemo;
    P51: TPanel;
    EdReg: TEdit;
    SpeedButton1: TSpeedButton;
    R1: TAVSecure;
    R0: TAVSecure;
    EdFecha1: TDateTimePicker;
    EdFecha2: TDateTimePicker;
    Mod1: TCheckBox;
    Mod2: TCheckBox;
    Mod3: TCheckBox;
    Mod4: TCheckBox;
    Mod5: TCheckBox;
    Mod6: TCheckBox;
    Mod7: TCheckBox;
    Mod8: TCheckBox;
    EdCodApp: TEdit;
    RxLabel6: TLabel;
    EdDif: TEdit;
    Image1: TImage;
    Label1: TLabel;
    L1: TLabel;
    Label2: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    LRegis2: TLabel;
    LDatos1: TLabel;
    LDatos2: TLabel;
    LRegis1: TLabel;
    Label11: TLabel;
    LRegistrar: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label10: TLabel;
    Memo0: TMemo;
    procedure EdInsChange(Sender: TObject);
    procedure EdFecha1Change(Sender: TObject);
    procedure EdFecha2Change(Sender: TObject);
    procedure EdDifChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtnRClick(Sender: TObject);
    procedure BtnLClick(Sender: TObject);
    procedure BtnDatosClick(Sender: TObject);
    procedure RBOtraClick(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure RBProvClick(Sender: TObject);
    procedure EdCodAppKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
    procedure calcular;
    procedure mostrarP(n:integer);
  public
    { Public declarations }
  end;

const
  iniciado : boolean = False;
var
  Form1: TForm1;

implementation

{$R *.DFM}

function cerrar(k:integer):integer;
begin
  result:=0;
  while(k>0) do begin
    result:=result+k mod 10;
    k:=k div 10;
  end;
end;

function cierre(n:integer):integer;
var r:integer;
begin
  r:=n;
  while (r>9) do BEGIN
    r:=cerrar(r);
  END;
  result:=9-r;
end;

procedure TForm1.EdInsChange(Sender: TObject);
begin
  EdReg.Text:='';
end;

procedure TForm1.EdFecha1Change(Sender: TObject);
var dif:integer;
begin
  EdReg.Text:='';
  if EdFecha2.date<EdFecha1.date then EdFecha2.date:=EdFecha1.Date+30;
  dif:=trunc(EdFecha2.date - EdFecha1.date);
  if (dif>255) then begin
    dif:=255;
    EdFecha2.date:=EdFecha1.date+255;
  end;
  Eddif.text:=inttostr(dif);
end;

procedure TForm1.EdFecha2Change(Sender: TObject);
var dif:integer;
begin
  EdReg.Text:='';
  if (EdFecha2.date>0) and (EdFecha2.date<EdFecha1.date)
  then EdFecha1.date:=EdFecha2.Date-30;
  dif:=trunc(EdFecha2.date - EdFecha1.date);
  if (dif>255) then begin
    dif:=255;
    EdFecha1.date:=EdFecha2.date-255;
  end;
  Eddif.text:=inttostr(dif);
end;

procedure TForm1.EdDifChange(Sender: TObject);
var dif:integer;
begin
  dif:=strtoint(Eddif.text);
  if (dif>255) then dif:=255;
  EdFecha2.date:=EdFecha1.date+dif;
  Eddif.text:=inttostr(dif);
end;


procedure TForm1.mostrarP(n:integer);
var cod:integer;
begin
  if (EdCodApp.text='') then cod:=0 else cod:=strtoint(EdCodApp.text);
  if (n=0) then BTnL.hide else BTnL.show;
  if (n=5) then BtnR.caption:='Terminate' else BtnR.caption:='Next >>';
  if (n=6) then BTnR.hide else BTnR.show;

  P0.Align:=alNone;
  P1.Align:=alNone;
  P2.Align:=alNone;
  P3.Align:=alNone;
  P4.Align:=alNone;
  P5.Align:=alNone;
  P6.Align:=alNone;
  P0.hide;
  P1.hide;
  P2.hide;
  P3.hide;
  P4.hide;
  P5.hide;
  P6.hide;
  case n of
    0:P0.show;
    1:P1.show;
    2:P2.show;
    3:P3.show;
    4:P4.show;
    5:P5.show;
    6:P6.show;
  end;
  case n of
    0:P0.Align:=alClient;
    1:P1.Align:=alClient;
    2:P2.Align:=alClient;
    3:P3.Align:=alClient;
    4:P4.Align:=alClient;
    5:P5.Align:=alClient;
    6:P6.Align:=alClient;
  end;
  if (n=0) then EdCodApp.SetFocus;
  if (n=1) then begin
    R0.AppCode:=cod;
    R0.read;
    if not R0.Expired then begin
      mod1.checked := m1 in R0.Modules;
      mod2.checked := m2 in R0.Modules;
      mod3.checked := m3 in R0.Modules;
      mod4.checked := m4 in R0.Modules;
      mod5.checked := m5 in R0.Modules;
      mod6.checked := m6 in R0.Modules;
      mod7.checked := m7 in R0.Modules;
      mod8.checked := m8 in R0.Modules;
      RBDef.Checked := R0.Registered;
      if not RBDef.Checked then begin
        EdFecha1.date:=R0.begindate;
        EdDif.text :=inttostr(R0.Days);
      end;
    end;
  end;
  if (n=4) then EdIns.SetFocus;
end;

procedure TForm1.calcular;
begin
  R1.clear;
  R1.registered:=RBDef.checked;
  R1.instalcode:=EdIns.Text;
  if (EdCodApp.text='') then R1.AppCode:=0 else R1.AppCode:=strtoint(EdCodApp.text);
  R1.BeginDate:=EdFecha1.Date;
  R1.Days:=strtoint(EdDif.text);
  if mod1.checked then R1.Modules:=R1.Modules+[m1];
  if mod2.checked then R1.Modules:=R1.Modules+[m2];
  if mod3.checked then R1.Modules:=R1.Modules+[m3];
  if mod4.checked then R1.Modules:=R1.Modules+[m4];
  if mod5.checked then R1.Modules:=R1.Modules+[m5];
  if mod6.checked then R1.Modules:=R1.Modules+[m6];
  if mod7.checked then R1.Modules:=R1.Modules+[m7];
  if mod8.checked then R1.Modules:=R1.Modules+[m8];
  EdReg.text:=R1.Make;
end;


procedure TForm1.FormShow(Sender: TObject);
begin
  clientheight:=330;
  clientwidth:=440;

  R0.clear;
  R0.read;
  R1.read;
  mostrarP(0);
  iniciado:=True;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  iniciado:=False;
end;

function ufmt(cod:string):string;
var i:integer;
begin
  result:='';
  for i:=1 to length(cod) do
  if (cod[i]<>'-') then result:=result+cod[i];
end;


procedure TForm1.BtnRClick(Sender: TObject);
var n:integer;
begin
  n:=0;
  LRegistrar.hide;
  RBOtraclick(nil);
  if (P0.Visible or P6.visible) then n:=1;
  if P1.visible then n:=2;
  if P2.visible and (EdFEcha1.date<2) or (EdDif.text='') then begin
    EdFecha1.date:=Now;
    EdDif.text:='30';
  end;
  if P2.visible then if RBProv.Checked then n:=3
  else if RBOtra.Checked then n:=4 else n:=5;
  if P3.visible then if RBOtra.Checked then n:=4 else n:=5;
  if (n=5) then begin
    R1.read;
    EdIns.text:=R1.InstalCode;
    Calcular;
    R1.write(EdReg.text);
    LRegistrar.show;
    P51.hide;

  end;
  if P4.visible then begin
    n:=5;
    LRegistrar.hide;
    P51.show;
    Calcular;
  end;
  if P5.visible then begin
    Close;
  end;
  mostrarP(n);
end;

procedure TForm1.BtnLClick(Sender: TObject);
var n:integer;
begin
  n:=0;
  if P2.visible then n:=1;
  if P3.visible then n:=2;
  if P4.visible then if RBProv.Checked then n:=3 else n:=2;
  if P5.visible then if RBOtra.Checked then n:=4
  else if RBProv.Checked then n:=3 else n:=2;
  mostrarP(n);
end;


procedure TForm1.BtnDatosClick(Sender: TObject);
var s:string;
begin
  if (EdCodApp.text='') then R0.AppCode:=0 else R0.AppCode:=strtoint(EdCodApp.text);
  R0.read;
  Memo1.Clear;


  if R0.expired  then showmessage('Registration not found in this computer for application ID '+inttostr(R0.AppCode))
  else begin
  L1.caption:='Registration data for the aplication ID '+inttostr(R0.AppCode);
  LDatos1.Caption:='Registration data is hold in the Windows registry in :'+#13#10;
  LDatos2.Caption:='HKEY_LOCAL_MACHINE\Software\CLASSES\CLSID\'+#13#10+R0.ProgID+'\ProgID';

  Memo1.Lines.Add('Instal code         : '+R0.InstalCode);
  Memo1.Lines.Add('Registration code   : '+R0.Make);
  if R0.Registered then
    Memo1.Lines.Add('Registration kind   : Definitive')
  else begin
    Memo1.Lines.Add(#13#10+'Registration kind   : Temporal');
    Memo1.Lines.Add('From the date       : '+datetostr(R0.begindate));
    Memo1.Lines.Add('To the date         : '+datetostr(R0.begindate+R0.days));
    Memo1.Lines.Add('Number of days      : '+inttostr(R0.Days));
  end;
  s:='';
  if m1 in R0.Modules then s:=s+',1';
  if m2 in R0.Modules then s:=s+',2';
  if m3 in R0.Modules then s:=s+',3';
  if m4 in R0.Modules then s:=s+',4';
  if m5 in R0.Modules then s:=s+',5';
  if m6 in R0.Modules then s:=s+',6';
  if m7 in R0.Modules then s:=s+',7';
  if m8 in R0.Modules then s:=s+',8';
  if (s='') then s:='Nothing' else s:=copy(s,2,length(s));
  Memo1.Lines.Add(#13#10+'Authorized modules  : '+s);
  MostrarP(6);
  end;
end;

procedure TForm1.RBOtraClick(Sender: TObject);
begin
  if RBLocal.Checked then LRegis2.Show else LRegis2.hide;
end;

procedure TForm1.BtnCancelClick(Sender: TObject);
begin
  close;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  R0.Erasereg;
  R0.Clear;
  if (EdCodApp.text='') then R0.AppCode:=0 else R0.AppCode:=strtoint(EdCodApp.text);
  R0.read;
  if R0.expired
  then showmessage('Was deleted the registration for the application ID '+inttostr(R0.AppCode));
  BtnLClick(nil);
end;

procedure TForm1.RBProvClick(Sender: TObject);
begin
  if RBDef.Checked then LRegis1.Show else LRegis1.hide;
end;

procedure TForm1.EdCodAppKeyPress(Sender: TObject; var Key: Char);
begin
  if not (key in [#8,'0'..'9']) then key:=#0;
end;

end.
