unit frmMain_D5;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ComCtrls, FBrowse, ExtCtrls, StdCtrls,
  ZLIBArchive;

type
  TZLBArchiver1 = class(TForm)
    ZLB1: TZLBArchive;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    OpenArchive: TOpenDialog;
    Add1: TMenuItem;
    Delete1: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    Open1: TMenuItem;
    Close1: TMenuItem;
    New1: TMenuItem;
    AddUpdateArchive: TOpenDialog;
    CreateDialog: TSaveDialog;
    N3: TMenuItem;
    Extract1: TMenuItem;
    ExtractDialog: TFolderBrowse;
    Panel1: TPanel;
    Splitter1: TSplitter;
    Memo1: TMemo;
    MELV1: TListView;
    Panel2: TPanel;
    ProgressBar1: TProgressBar;
    FileCountPnl: TStaticText;
    MsgPnl: TStaticText;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Options1: TMenuItem;
    RecursePaths1: TMenuItem;
    SavePaths1: TMenuItem;
    N4: TMenuItem;
    CompressonLevel1: TMenuItem;
    None1: TMenuItem;
    Fastest1: TMenuItem;
    Normal1: TMenuItem;
    Maximum1: TMenuItem;
    N5: TMenuItem;
    VerifyCRC1: TMenuItem;
    ExtractPaths1: TMenuItem;
    N6: TMenuItem;
    AddFiles1: TMenuItem;
    UpdateFiles1: TMenuItem;
    Ver111: TMenuItem;
    Rename1: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure ZLB1ArchiveOpened(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure Extract1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure ZLB1ErrorLogged(Msg: String);
    procedure ZLB1Progress(Msg: String; Percentage: Integer);
    procedure RecursePaths1Click(Sender: TObject);
    procedure SavePaths1Click(Sender: TObject);
    procedure None1Click(Sender: TObject);
    procedure Fastest1Click(Sender: TObject);
    procedure Normal1Click(Sender: TObject);
    procedure Maximum1Click(Sender: TObject);
    procedure VerifyCRC1Click(Sender: TObject);
    procedure ExtractPaths1Click(Sender: TObject);
    procedure AddFiles1Click(Sender: TObject);
    procedure UpdateFiles1Click(Sender: TObject);
    procedure Rename1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ZLBArchiver1: TZLBArchiver1;

implementation

{$R *.DFM}

procedure TZLBArchiver1.Exit1Click(Sender: TObject);
begin
     Close;
end;

procedure TZLBArchiver1.Open1Click(Sender: TObject);
begin
     if OpenArchive.Execute then
        ZLB1.OpenArchive(OpenArchive.filename);
end;

procedure TZLBArchiver1.ZLB1ArchiveOpened(Sender: TObject);
const
     FileStatusStr : array[TFileStatus] of string = ('Compressed','Stored');
     FileCompStr : array[TFileCompressionLevel] of String = ('None','Fastest','Normal','Maximum');
var
   loop : integer;
   lvItem : TListItem;
begin
     FileCountPnl.Caption := inttostr(ZLB1.FileCount) + ' File(s)';
     MsgPnl.Caption := ZLB1.ArchiveName;

     MELV1.Items.BeginUpdate;
     try
        MELV1.Items.Clear;
        loop := 0;
        while loop < ZLB1.FileCount do
        begin
             lvItem := MELV1.Items.Add;
             with lvItem do
             begin
                  caption := ZLB1.Files[loop].name;
                  subitems.Add(inttostr(ZLB1.Files[loop].osize));
                  subitems.Add(inttostr(ZLB1.Files[loop].csize));
                  subitems.Add(FileStatusStr[ZLB1.Files[loop].status]);
                  subitems.Add(FileCompStr[ZLB1.Files[loop].CompressionLevel]);
                  subitems.Add(inttohex(ZLB1.Files[loop].CRC,8));
                  subitems.add(inttostr(ZLB1.Files[loop].start));
                  subitems.Add(ZLB1.Files[loop].path);
             end;
             inc(loop);
        end;
     finally
        MELV1.Items.EndUpdate;
     end;
end;

procedure TZLBArchiver1.New1Click(Sender: TObject);
var
   ext : string;
begin
     if createdialog.execute then
     begin
          if pos('.zlb',lowercase(extractfilename(createdialog.filename))) = 0 then
             ext := '.zlb'
          else
             ext := '';
          ZLB1.CreateArchive(createdialog.filename+ext);
     end;
end;

procedure TZLBArchiver1.Close1Click(Sender: TObject);
begin
     MELV1.Items.Clear;
     ZLB1.CloseArchive;
end;

procedure TZLBArchiver1.Extract1Click(Sender: TObject);
var
   loop : integer;
begin
     if MELV1.SelCount = 0 then exit;
     if ExtractDialog.Execute(self) then
     begin
          loop := 0;
          while loop < MELV1.Items.Count do
          begin
               if MELV1.Items[loop].selected then
                  ZLB1.ExtractFileByName(ExtractDialog.Directory,MELV1.Items[loop].SubItems.Strings[6]+MELV1.Items[loop].Caption);
               inc(loop);
          end;
     end;
end;

procedure TZLBArchiver1.Delete1Click(Sender: TObject);
var
   filelist : tstringlist;
   loop : integer;
begin
     if MELV1.SelCount = 0 then exit;
     if messagedlg('Delete selected files from archive?',mtConfirmation,mbOKCancel,0) = idok then
     begin
          filelist := tstringlist.create;
          try
             loop := 0;
             while loop < MELV1.items.count do
             begin
                  if MELV1.items[loop].selected then filelist.Add(MELV1.items[loop].SubItems[6]+MELV1.items[loop].caption);
                  inc(loop);
             end;
             ZLB1.DeleteFiles(filelist);
          finally
             filelist.free;
          end;
     end;
end;

procedure TZLBArchiver1.ZLB1ErrorLogged(Msg: String);
begin
     Memo1.Lines.Add(msg);
end;

procedure TZLBArchiver1.ZLB1Progress(Msg: String; Percentage: Integer);
begin
     msgpnl.Caption := msg;
     msgpnl.Refresh;
     ProgressBar1.Position := Percentage;
end;

procedure TZLBArchiver1.RecursePaths1Click(Sender: TObject);
begin
     zlb1.RecursePaths := not zlb1.RecursePaths;
     RecursePaths1.Checked := zlb1.RecursePaths;
end;

procedure TZLBArchiver1.SavePaths1Click(Sender: TObject);
begin
     zlb1.SavePaths := not zlb1.SavePaths;
     SavePaths1.Checked := zlb1.SavePaths;
end;

procedure TZLBArchiver1.None1Click(Sender: TObject);
begin
     ZLB1.CompressionLevel := fcNone;
     None1.Checked := true;
     Fastest1.Checked := false;
     Normal1.Checked := false;
     Maximum1.Checked := false;
end;

procedure TZLBArchiver1.Fastest1Click(Sender: TObject);
begin
     ZLB1.CompressionLevel := fcFastest;
     None1.Checked := false;
     Fastest1.Checked := true;
     Normal1.Checked := false;
     Maximum1.Checked := false;
end;

procedure TZLBArchiver1.Normal1Click(Sender: TObject);
begin
     ZLB1.CompressionLevel := fcDefault;
     None1.Checked := false;
     Fastest1.Checked := false;
     Normal1.Checked := true;
     Maximum1.Checked := false;
end;

procedure TZLBArchiver1.Maximum1Click(Sender: TObject);
begin
     ZLB1.CompressionLevel := fcMaximum;
     None1.Checked := false;
     Fastest1.Checked := false;
     Normal1.Checked := false;
     Maximum1.Checked := true;
end;

procedure TZLBArchiver1.VerifyCRC1Click(Sender: TObject);
begin
     ZLB1.CheckCRC := not ZLB1.CheckCRC;
     VerifyCRC1.Checked := ZLB1.CheckCRC;
end;

procedure TZLBArchiver1.ExtractPaths1Click(Sender: TObject);
begin
     ZLB1.ExtractWithPath := not ZLB1.ExtractWithPath;
     ExtractPaths1.Checked := ZLB1.ExtractWithPath;      
end;

procedure TZLBArchiver1.AddFiles1Click(Sender: TObject);
begin
     AddUpdateArchive.Title := 'Add File(s) to '+extractfilename(zlb1.archivename);
     if AddUpdateArchive.Execute then
        ZLB1.AddFiles(AddUpdateArchive.files);
end;

procedure TZLBArchiver1.UpdateFiles1Click(Sender: TObject);
begin
     AddUpdateArchive.Title := 'Update File(s) in '+extractfilename(zlb1.archivename);
     if AddUpdateArchive.Execute then
        ZLB1.UpdateFiles(AddUpdateArchive.files);
end;

procedure TZLBArchiver1.Rename1Click(Sender: TObject);
var
   name : string;
begin
     if MELV1.SelCount = 0 then exit;
     if Melv1.SelCount > 1 then
     begin
        messagedlg('You can only rename one file at a time',mtinformation,[mbok],0);
     end
     else
     begin
          name := melv1.Selected.Caption;
          if InputQuery('Rename File', 'Please enter a new name:', name) then
          begin
               if (name <> '') and (ansilowercase(name) <> ansilowercase(melv1.Selected.Caption)) then
                  zlb1.RenameFileByName(melv1.Selected.SubItems[6]+melv1.Selected.Caption,melv1.Selected.SubItems[6]+name);
          end;
     end;
end;

end.
