{********************************************************}
{                                                        }
{                 Zeos Database Objects                  }
{            Database resources and constants            }
{                                                        }
{       Copyright (c) 1999-2001 Sergey Seroukhov         }
{    Copyright (c) 1999-2001 Zeos Development Group      }
{                                                        }
{********************************************************}

unit ZDBaseConst;

interface

{$IFNDEF LINUX}
{$INCLUDE ..\Zeos.inc}
{$ELSE}
{$INCLUDE ../Zeos.inc}
{$ENDIF}

resourcestring

{$IFNDEF RUSSIAN} {$IFNDEF GERMAN} {$IFNDEF PORTUGUESE}
{$IFNDEF FRENCH} {$IFNDEF POLISH} {$IFNDEF CZECH}
{$IFNDEF ITALIAN} {$IFNDEF DUTCH} {$IFNDEF SPANISH}
{$IFNDEF CROATIAN} {$IFNDEF HUNGARY}

  SLibraryNotFound      = 'Dynamic library %s not found';
  SConnectError         = 'Server connection error';
  SConnectTransactError = 'Error while activate transaction';
  SDbCreateError        = 'Database creating error';
  SNotConnected         = 'Not connected yet';
  SFieldNumberError     = 'Incorrect field number';
  SFieldNameError       = 'Incorrect field name';
  SFieldAliasError      = 'Incorrect field alias';
  SFieldValuesError     = 'TFieldValues internal error';
  SQueryExecError       = 'Query execution error';
  SConnectNotDefined    = 'Database component not defined';
  SUnknownType          = 'Unknown type: ';
  SBookmarkNotFound     = 'Bookmark not found';
  SNoMoreRec            = 'No more records';
  SIncorrectField       = 'Incorrect field name "%s"';
  SIntFuncError         = 'Internal error in function %s';
  SIncorrectArgs        = 'Incorrect arguments number';
  SRefreshError         = 'Refreshing query error';
  STransactNotDefined   = 'Transaction component not defined';
  SAllocError           = 'Memory allocation error';
  SNotInsertMode        = 'Not in Insert or Edit mode';
  SIntBufferError       = 'Internal buffer structure error';
  SROCmdError           = 'Incorrect command in "Read Only" mode';
  SIncorrectLinks       = 'Incorrect links was defined';
  SCyclicLinkError      = 'Cyclic link in Dataset';
  SDetailQueryError     = 'Error in detail query';
  SUnableListProp       = 'Unable to list this property';
  SReadBlobError        = 'Can''t read the blob';
  SCreateBlobError      = 'Can''t create the blob';
  SDropBlobError        = 'Can''t remove the blob';
  SDatasetNotDefined    = 'Dataset component not defined';
  SUpdateSqlIsEmpty 	= 'UpdateSql query is empty';
  SFailAddNull          = 'Fail to add null value in not null field "%s"';
  SPostError            = 'Error while posting updates';
  SNotifyRegister       = 'Error registering/unregistering Notify to %s';
  SEventLength          = 'Event length (%d) is greater then the maximum allowed (%d)';
  SConstraintFailed     = 'Record or field constraint failed  : %s';

{$ENDIF} {$ENDIF}
{$ENDIF} {$ENDIF} {$ENDIF}
{$ENDIF} {$ENDIF} {$ENDIF}
{$ENDIF} {$ENDIF} {$ENDIF}

{$IFDEF RUSSIAN}

  SLibraryNotFound      = '  %s  ';
  SConnectError         = '   ';
  SConnectTransactError = '  ';
  SDbCreateError        = '   ';
  SNotConnected         = '  ';
  SFieldNumberError     = '  ';
  SFieldNameError       = '  ';
  SFieldAliasError      = '  ';
  SFieldValuesError     = '  TFieldValues';
  SQueryExecError       = '  ';
  SConnectNotDefined    = ' Database ';
  SUnknownType          = ' : ';
  SBookmarkNotFound     = '  ';
  SNoMoreRec            = '  ';
  SIncorrectField       = '   "%s"';
  SIntFuncError         = '    "%s"';
  SIncorrectArgs        = '  ';
  SRefreshError         = '  ';
  STransactNotDefined   = ' Transaction ';
  SAllocError           = '  ';
  SNotInsertMode        = '     ';
  SIntBufferError       = '   ';
  SROCmdError           = '    "  "';
  SIncorrectLinks       = '  ';
  SCyclicLinkError      = '   Dataset';
  SDetailQueryError     = '   ';
  SUnableListProp       = '   ';
  SReadBlobError        = '  ';
  SCreateBlobError      = '  ';
  SDropBlobError        = '  ';
  SDatasetNotDefined    = ' Dataset ';
  SUpdateSqlIsEmpty 	= ' UpdateSql ';
  SFailAddNull          = '        "%s"';
  SPostError            = '   ';
  SNotifyRegister       = ' /   %s';
  SEventLength          = '  (%d)     (%d)';
  SConstraintFailed     = '    : %s';

{$ENDIF}

{$IFDEF GERMAN}

  SLibraryNotFound      = 'Dynamische Bibliothek %s nicht gefunden';
  SConnectError         = 'Fehler bei Server-Verbindung';
  SConnectTransactError = 'Error while activate transaction';
  SDbCreateError        = 'Fehler beim Anlegen der Datenbank';
  SNotConnected         = 'Noch nicht verbunden';
  SFieldNumberError     = 'Falsche Feldnummer';
  SFieldNameError       = 'Falscher Feldname';
  SFieldAliasError      = 'Falsches Feld-Alias';
  SFieldValuesError     = 'TFieldValues interner Fehler';
  SQueryExecError       = 'Fehler bei Abfrage-Ausfhrung';
  SConnectNotDefined    = 'Database-Komponente nicht definiert';
  SUnknownType          = 'Unbekannter Typ: ';
  SBookmarkNotFound     = 'Lesezeichen nicht gefunden';
  SNoMoreRec            = 'Keine weiteren Datenstze';
  SIncorrectField       = 'Falscher Feldname "%s"';
  SIntFuncError         = 'Interner Fehler in Funktion %s';
  SIncorrectArgs        = 'Falsche Anzahl Argumente';
  SRefreshError         = 'Fehler bei der Abfrage-Aktualisierung';
  STransactNotDefined   = 'Transaction-Komponente nicht definiert';
  SAllocError           = 'Fehler bei Speicherbelegung';
  SNotInsertMode        = 'Nicht im Einfge- oder Bearbeitungsmodus';
  SIntBufferError       = 'Interner Fehler in Puffer-Strukur';
  SROCmdError           = 'Falscher Befehl im "Read Only"-Modus';
  SIncorrectLinks       = 'Falsche Verknpfung';
  SCyclicLinkError      = 'Zyklische Verknpfung in Dataset';
  SDetailQueryError     = 'Fehler in Detail-Query';
  SUnableListProp       = 'Kann Eigenschaft nicht auflisten';
  SReadBlobError        = 'Kann blob nicht lesen';
  SCreateBlobError      = 'Kann blob nicht anlegen';
  SDropBlobError        = 'Kann blob nicht lschen';
  SDatasetNotDefined    = 'Dataset-Komponente nicht definiert';
  SUpdateSqlIsEmpty 	= 'UpdateSql-Abfrage ist leer';
  SFailAddNull          = 'Kann NULL-Wert nicht im NOT NULL-Feld "%s" speichern';
  SPostError            = 'Fehler beim Speichern der nderungen';
  SNotifyRegister       = 'Error registering/unregistering Notify to %s';
  SEventLength          = 'Event length (%d) is greater then the maximum allowed (%d)';
  SConstraintFailed     = 'Record or field constraint failed  : %s';

{$ENDIF}

{$IFDEF PORTUGUESE}

  SLibraryNotFound      = 'Biblioteca dinmica %s no encontrada';
  SConnectError         = 'Erro na conexo com o servidor';
  SConnectTransactError = 'Erro na ativao da transao';
  SDbCreateError        = 'Erro na criao do banco de dados';
  SNotConnected         = 'No conectado ainda';
  SFieldNumberError     = 'Nmero de campo incorreto';
  SFieldNameError       = 'Nome de campo incorreto';
  SFieldAliasError      = 'Alias de campo incorreto';
  SFieldValuesError     = 'Erro interno de TFieldValues';
  SQueryExecError       = 'Erro na execuo da "query"';
  SConnectNotDefined    = 'Componente de banco de dados no definido';
  SUnknownType          = 'Tipo desconhecido: ';
  SBookmarkNotFound     = '"Bookmark" no encontrado';
  SNoMoreRec            = 'Sem mais registros';
  SIncorrectField       = 'Nome de campo "%s" incorreto';
  SIntFuncError         = 'Erro interno na funo %s';
  SIncorrectArgs        = 'Nmero incorreto de argumentos';
  SRefreshError         = 'Erro no "refresh" da "query"';
  STransactNotDefined   = 'Componente de transao no definido';
  SAllocError           = 'Erro de alocao de memria';
  SNotInsertMode        = 'No est em modo de Insero ou de Edio';
  SIntBufferError       = 'Erro na estrutura do buffer interno';
  SROCmdError           = 'Comando incorreto no modo "somente leitura"';
  SIncorrectLinks       = 'Foi definido link incorreto';
  SCyclicLinkError      = 'Link cclico no "dataset"';
  SDetailQueryError     = 'Erro na "query" de detalhe';
  SUnableListProp       = 'No pode listar esta propriedade';
  SReadBlobError        = 'No pode ler o "blob"';
  SCreateBlobError      = 'No pode criar o "blob"';
  SDropBlobError        = 'No pode excluir o "blob"';
  SDatasetNotDefined    = 'Componente "dataset" no definido';
  SUpdateSqlIsEmpty 	= '"Query" de "UpdateSql" est vazia';
  SFailAddNull          = 'Falha ao adicionar valor nulo em campo "%s" no nulo';
  SPostError            = 'Erro na gravao de atualizaes';
  SNotifyRegister       = 'Erro registrando/desregistrando "Notify" para %s';
  SEventLength          = 'Comprimento do evento (%d)  maior que o mximo (%d) permitido';
  SConstraintFailed     = 'Falha na restrio de registro ou de campo : %s';

{$ENDIF}

{$IFDEF FRENCH}

  SLibraryNotFound      = 'Bibliothque dynamique %s non trouve';
  SConnectError         = 'La connexion au Serveur a chou';
  SConnectTransactError = 'Erreur pendant l''activation de la transaction';
  SDbCreateError        = 'Erreur de cration de la base de donnes';
  SNotConnected         = 'N''est plus connect';
  SFieldNumberError     = 'Nombre de champs incorrect';
  SFieldNameError       = 'Nom du champ incorrect';
  SFieldAliasError      = 'Alias du champ incorrect';
  SFieldValuesError     = 'Erreur interne du TFieldValues';
  SQueryExecError       = 'Erreur d''excution de la requte';
  SConnectNotDefined    = 'Composant base de donnes non dfini';
  SUnknownType          = 'Type inconnu : ';
  SBookmarkNotFound     = 'Signet non trouv';
  SNoMoreRec            = 'Plus d''enregistrement';
  SIncorrectField       = 'Nom du champ incorrect "%s"';
  SIntFuncError         = 'Erreur interne dans la fonction %s';
  SIncorrectArgs        = 'Nombre d''arguments incorrects';
  SRefreshError         = 'Erreur de rafrachissement de la requte';
  STransactNotDefined   = 'Composant Transaction non dfinie';
  SAllocError           = 'Erreur d''allocation de mmoire';
  SNotInsertMode        = 'N''est pas en mode d''insertion ou de mise  jour';
  SIntBufferError       = 'Structure du tampon interne erron';
  SROCmdError           = 'Commande incorrecte dans le mode "lecture-seul"';
  SIncorrectLinks       = 'Lien dfini incorrect';
  SCyclicLinkError      = 'Lien cyclique dans le Dataset';
  SDetailQueryError     = 'Erreur en dtail de la requte';
  SUnableListProp       = 'Incapable de lister cette proprit';
  SReadBlobError        = 'On ne peut pas lire le blob';
  SCreateBlobError      = 'On ne peut pas crer le blob';
  SDropBlobError        = 'On ne peut pas enlever le blob';
  SDatasetNotDefined    = 'Composant Dataset non dfini';
  SUpdateSqlIsEmpty 	= 'La requte du UpdateSql est vide';
  SFailAddNull          = 'Echec d''ajouter une valeur nul dans champ non nul "%s"';
  SPostError            = 'Erreur pendant la mise  jour';
  SNotifyRegister       = 'Erreur d''enregistrement/de-enregistrement de l''avertisseur au %s';
  SEventLength          = 'Longueur de l''vnement (%d) est plus grand le maximum permis (%d)';
  SConstraintFailed     = 'Echec de contrainte sur la table ou le champ  : %s';

{$ENDIF}

{$IFDEF POLISH}

  SLibraryNotFound      = 'Nie znaleziono biblioteki %s';
  SConnectError         = 'Bd poczenia z serwerem';
  SConnectTransactError = 'Error while activate transaction';
  SDbCreateError        = 'Bd tworzenia bazy danych';
  SNotConnected         = 'Jeszcze nie poczony';
  SFieldNumberError     = 'Bdny numer pola';
  SFieldNameError       = 'Bdna nazwa pola';
  SFieldAliasError      = 'Bdny alias pola';
  SFieldValuesError     = 'Bd wewntrzny TFieldValues';
  SQueryExecError       = 'Bd wykonania kwerendy';
  SConnectNotDefined    = 'Nie zdefiniowano komponentu Database';
  SUnknownType          = 'Nieznany typ: ';
  SBookmarkNotFound     = 'Nie znaleziono zakadki';
  SNoMoreRec            = 'Nie ma wicej rekordw';
  SIncorrectField       = 'Bdna nazwa pola "%s"';
  SIntFuncError         = 'Bd wewntrzny funkcji %s';
  SIncorrectArgs        = 'Bdny parametr';
  SRefreshError         = 'Bd odwie+ania kwerendy';
  STransactNotDefined   = 'Nie zdefiniowano komponentu Transaction';
  SAllocError           = 'Bd alokacji pamici';
  SNotInsertMode        = 'Brak trybu Edycji lub Wstawiania';
  SIntBufferError       = 'Bd wewntrzny struktury bufora';
  SROCmdError           = 'Bdne polecenie dla trybu "Read Only"';
  SIncorrectLinks       = 'le zdefinowane linki';
  SCyclicLinkError      = 'Cykliczny wskanik dla zbioru danych';
  SDetailQueryError     = 'Bd postaci kwerendy';
  SUnableListProp       = 'Bd listowania waciwoci';
  SReadBlobError        = 'Nie mo+na odczyta pola typu BLOB';
  SCreateBlobError      = 'Nie mo+na stworzy pola typu BLOB';
  SDropBlobError        = 'Nie mo+na usun pola typu BLOB';
  SDatasetNotDefined    = 'Nie zdefiniowano komponentu Dataset';
  SUpdateSqlIsEmpty 	= 'Kwerenda UpdateSql jest pusta';
  SFailAddNull          = 'Bld dodawania pustej wartoci do pola "%s" (NOT NULL)';
  SPostError            = 'Bld podczas aktualizacji danych';
  SNotifyRegister       = 'Error registering/unregistering Notify to %s';
  SEventLength          = 'Event length (%d) is greater then the maximum allowed (%d)';
  SConstraintFailed     = 'Record or field constraint failed  : %s';

{$ENDIF}

{$IFDEF CZECH}

  SLibraryNotFound      = 'Dynamic library %s not found';
  SConnectError         = 'Server connection error';
  SConnectTransactError = 'Error while activate transaction';
  SDbCreateError        = 'Database creating error';
  SNotConnected         = 'Not connected yet';
  SFieldNumberError     = 'Incorrect field number';
  SFieldNameError       = 'Incorrect field name';
  SFieldAliasError      = 'Incorrect field alias';
  SFieldValuesError     = 'TFieldValues internal error';
  SQueryExecError       = 'Query execution error';
  SConnectNotDefined    = 'Database component not defined';
  SUnknownType          = 'Unknown type: ';
  SBookmarkNotFound     = 'Bookmark not found';
  SNoMoreRec            = 'No more records';
  SIncorrectField       = 'Incorrect field name "%s"';
  SIntFuncError         = 'Internal error in function %s';
  SIncorrectArgs        = 'Incorrect arguments number';
  SRefreshError         = 'Refreshing query error';
  STransactNotDefined   = 'Transaction component not defined';
  SAllocError           = 'Memory allocation error';
  SNotInsertMode        = 'Not in Insert or Edit mode';
  SIntBufferError       = 'Internal buffer structure error';
  SROCmdError           = 'Incorrect command in "Read Only" mode';
  SIncorrectLinks       = 'Incorrect links was defined';
  SCyclicLinkError      = 'Cyclic link in Dataset';
  SDetailQueryError     = 'Error in detail query';
  SUnableListProp       = 'Unable to list this property';
  SReadBlobError        = 'Can''t read the blob';
  SCreateBlobError      = 'Can''t create the blob';
  SDropBlobError        = 'Can''t remove the blob';
  SDatasetNotDefined    = 'Dataset component not defined';
  SUpdateSqlIsEmpty 	= 'UpdateSql query is empty';
  SFailAddNull          = 'Fail to add null value in not null field "%s"';
  SPostError            = 'Error while posting updates';
  SNotifyRegister       = 'Error registering/unregistering Notify to %s';
  SEventLength          = 'Event length (%d) is greater then the maximum allowed (%d)';
  SConstraintFailed     = 'Record or field constraint failed  : %s';

{$ENDIF}

{$IFDEF ITALIAN}

  SLibraryNotFound      = 'Libreria dinamica %s non trovata';
  SConnectError         = 'Errore di connessione con il Server';
  SConnectTransactError = 'Error while activate transaction';
  SDbCreateError        = 'Errore nella creazione del Database';
  SNotConnected         = 'Nessuna connessione stabilita';
  SFieldNumberError     = 'Numero di campo incorretto';
  SFieldNameError       = 'Nome di campo incorretto';
  SFieldAliasError      = 'Alias di campo incorretto';
  SFieldValuesError     = 'Errore interno in TFieldValues';
  SQueryExecError       = 'Errore nell''esecuzione della Query';
  SConnectNotDefined    = 'Componente Database non definito';
  SUnknownType          = 'Tipo sconosciuto: ';
  SBookmarkNotFound     = 'Bookmark non trovato';
  SNoMoreRec            = 'Nessuna registrazione';
  SIncorrectField       = 'Nome campo errato "%s"';
  SIntFuncError         = 'Errore interna nella funzione %s';
  SIncorrectArgs        = 'Numero argomenti errato';
  SRefreshError         = 'Errore nel refresh della query';
  STransactNotDefined   = 'Componente Transaction non definito';
  SAllocError           = 'Errore nell''allocazione della memoria';
  SNotInsertMode        = 'Non  in modalit di Inserimento o Modifica';
  SIntBufferError       = 'Errore nell''Internal buffer structure';
  SROCmdError           = 'Errato comando in modalit "Read Only"';
  SIncorrectLinks       = 'Definiti links errati';
  SCyclicLinkError      = 'Dataset con Link ciclico';
  SDetailQueryError     = 'Errore nella query di dettaglio';
  SUnableListProp       = 'Impossibile elencare questa propriet';
  SReadBlobError        = 'Impossibile leggere il campo blob';
  SCreateBlobError      = 'Impossibile creare il campo blob';
  SDropBlobError        = 'Impossibile eliminare il campo blob';
  SDatasetNotDefined    = 'Componente Dataset non definito';
  SUpdateSqlIsEmpty 	= 'UpdateSql query  vuota';
  SFailAddNull          = 'Errore nell''inserire un valore nullo in un campo non nullo "%s"';
  SPostError            = 'Error while posting updates';
  SNotifyRegister       = 'Error registering/unregistering Notify to %s';
  SEventLength          = 'Event length (%d) is greater then the maximum allowed (%d)';
  SConstraintFailed     = 'Record or field constraint failed  : %s';

{$ENDIF}

{$IFDEF DUTCH}

  SLibraryNotFound      = 'Dynamische library %s niet gevonden';
  SConnectError         = 'Server connectiefout';
  SConnectTransactError = 'Error while activate transaction';
  SDbCreateError        = 'Database creatiefout';
  SNotConnected         = 'Nog niet geconnecteerd ';
  SFieldNumberError     = 'Incorrect veldnummer';
  SFieldNameError       = 'Incorrecte veldnaam';
  SFieldAliasError      = 'Incorrecte veld alias';
  SFieldValuesError     = 'TFieldValues interne fout';
  SQueryExecError       = 'Fout tijdens uitvoeren Query';
  SConnectNotDefined    = 'Database component is niet gedefinieerd';
  SUnknownType          = 'Ongekend type: ';
  SBookmarkNotFound     = 'Bookmark is niet gevonden';
  SNoMoreRec            = 'Geen records meer';
  SIncorrectField       = 'Incorrecte veldnaam "%s"';
  SIntFuncError         = 'Interne fout in functie %s';
  SIncorrectArgs        = 'Incorrect aantal argumenten';
  SRefreshError         = 'Fout tijdens vernieuw query';
  STransactNotDefined   = 'Transactiecomponent niet gedefinieerd';
  SAllocError           = 'Fout tijdens toewijzen geheugen';
  SNotInsertMode        = 'Niet in Toevoeg of Wijzig mode';
  SIntBufferError       = 'Interne bufferstructuur fout';
  SROCmdError           = 'Incorrect commando in "Read Only" mode';
  SIncorrectLinks       = 'Incorrecte links was gedefinieerd';
  SCyclicLinkError      = 'Cyclische link in Dataset';
  SDetailQueryError     = 'Fout in detail query';
  SUnableListProp       = 'Kan deze property niet tonen';
  SReadBlobError        = 'Kan de BLOB niet lezen';
  SCreateBlobError      = 'Kan de BLOB niet aanmaken';
  SDropBlobError        = 'Kan de BLOB niet verwijderen';
  SDatasetNotDefined    = 'Dataset component is niet gedefinieerd';
  SUpdateSqlIsEmpty 	= 'UpdateSql query is leeg';
  SFailAddNull          = 'Gefaald om een NULL waarde toe te voegen in een NOT NULL veld "%s"';
  SPostError            = 'Fout tijdens posten updates';
  SNotifyRegister       = 'Error registering/unregistering Notify to %s';
  SEventLength          = 'Event length (%d) is greater then the maximum allowed (%d)';
  SConstraintFailed     = 'Record or field constraint failed  : %s';

{$ENDIF}

{$IFDEF SPANISH}

  SLibraryNotFound      = 'Libreria Dinamica %s no existe';
  SConnectError         = 'Error en la Conexion al Servidor';
  SConnectTransactError = 'Error while activate transaction';
  SDbCreateError        = 'Error Creando BaseDatos';
  SNotConnected         = 'Sin conexion todavia';
  SFieldNumberError     = 'Numero de Campos Erroneo';
  SFieldNameError       = 'Nombre de Campo Erroeneo';
  SFieldAliasError      = 'Alias de Campo Erroneo';
  SFieldValuesError     = 'Error Interno de TFieldValues';
  SQueryExecError       = 'Error en la ejecucion de una Consulta';
  SConnectNotDefined    = 'Componente DataBase no definido';
  SUnknownType          = 'Tipo desconocido: ';
  SBookmarkNotFound     = 'Bookmark no encontrado';
  SNoMoreRec            = 'No hay mas registros';
  SIncorrectField       = 'Nombre de campo incorrecto "%s"';
  SIntFuncError         = 'Error interno en la fucnion %s';
  SIncorrectArgs        = 'Numero de argumentos erroneo';
  SRefreshError         = 'Error de refresco de consulta';
  STransactNotDefined   = 'Camponente de Transaccion no definido';
  SAllocError           = 'Error de memoria';
  SNotInsertMode        = 'No esta en modo de edicion o insercion';
  SIntBufferError       = 'Error interno de estructura de buffer';
  SROCmdError           = 'Comando errorneo en modo "Read Only"';
  SIncorrectLinks       = 'Se han definido enlaces erroneos';
  SCyclicLinkError      = 'Enlacde con Dataset cicular';
  SDetailQueryError     = 'Error en el detalle de la consulta';
  SUnableListProp       = 'No se puede visualizar esta propiedad';
  SReadBlobError        = 'No se puede leer el blob';
  SCreateBlobError      = 'No se puede crear el blob';
  SDropBlobError        = 'No se puede borrar el blob';
  SDatasetNotDefined    = 'Componente Dataset no definido';
  SUpdateSqlIsEmpty 	= 'Consulta UpdateSql vacia';
  SFailAddNull          = 'Fallo para adir null valor en not null campo "%s"';
  SPostError            = 'Error mientras gardaba cambios';
  SNotifyRegister       = 'Error registering/unregistering Notify to %s';
  SEventLength          = 'Event length (%d) is greater then the maximum allowed (%d)';
  SConstraintFailed     = 'Record or field constraint failed  : %s';

{$ENDIF}

{$IFDEF CROATIAN}

  SLibraryNotFound      = 'Dinamika biblioteka %s nije pronaena';
  SConnectError         = 'Greka pri spajanju na server';
  SConnectTransactError = 'Error while activate transaction';
  SDbCreateError        = 'Greka pri kreiranju baze';
  SNotConnected         = 'Server jo nije spojen';
  SFieldNumberError     = 'Krivi broj polja';
  SFieldNameError       = 'Krivo ime polja';
  SFieldAliasError      = 'Krivi alias polja';
  SFieldValuesError     = 'TFieldValues interna greka';
  SQueryExecError       = 'Greka pri izvrenju upita';
  SConnectNotDefined    = 'Komponenta baze podataka nije postavljena';
  SUnknownType          = 'Nepoznat tip: ';
  SBookmarkNotFound     = 'Oznaka nije pronaen';
  SNoMoreRec            = 'Nema vie zapisa';
  SIncorrectField       = 'Krivo ime polja "%s"';
  SIntFuncError         = 'Interna greka u funkciji %s';
  SIncorrectArgs        = 'Krivi broj argumenata';
  SRefreshError         = 'Greka pri osvjeavanju upita';
  STransactNotDefined   = 'Transakcijska komponenta nije postavljena';
  SAllocError           = 'Greka pri alokaciji memorije';
  SNotInsertMode        = 'Nije u Insert ili Edit modu rada';
  SIntBufferError       = 'Interna greka u meumemorijskoj strukturi';
  SROCmdError           = 'Kriva naredba u "Read Only" modu rada';
  SIncorrectLinks       = 'Postavljena kriva veza';
  SCyclicLinkError      = 'Kruna veza u podacima';
  SDetailQueryError     = 'Greka u upitu s detaljnim podacima';
  SUnableListProp       = 'Nedostupna osobina';
  SReadBlobError        = 'Ne mogu proitati Blob';
  SCreateBlobError      = 'Ne mogu napraviti Blob';
  SDropBlobError        = 'Ne mogu obrisati Blob';
  SDatasetNotDefined    = 'Komponenta baze podataka nije postavljena';
  SUpdateSqlIsEmpty 	= 'UpdateSql upit je prazan';
  SFailAddNull          = 'Ne mogu pridodati NULL vrijednost u NOT NULL polje "%s"';
  SPostError            = 'Greka pri snimanju izmjena';
  SNotifyRegister       = 'Error registering/unregistering Notify to %s';
  SEventLength          = 'Event length (%d) is greater then the maximum allowed (%d)';
  SConstraintFailed     = 'Record or field constraint failed  : %s';

{$ENDIF}

{$IFDEF HUNGARY}

  SLibraryNotFound      = 'A %s dinamikus knyvtr nem tallhat';
  SConnectError         = 'Szerver kapcsoldsi hiba';
  SConnectTransactError = 'Error while activate transaction';
  SDbCreateError        = 'Adatbzis ltrehozsi hiba';
  SNotConnected         = 'Mg nem kapcsoldott';
  SFieldNumberError     = 'Hibs mezszm';
  SFieldNameError       = 'Hibs meznv';
  SFieldAliasError      = 'Hibs mezlnv';
  SFieldValuesError     = 'TFieldValues bels hiba';
  SQueryExecError       = 'Query futsi hiba';
  SConnectNotDefined    = 'Adatbzis komponens nem definilt';
  SUnknownType          = 'Ismeretlen tpus: ';
  SBookmarkNotFound     = 'Knyvjelz nem tallhat';
  SNoMoreRec            = 'Nincs tbb rekord';
  SIncorrectField       = 'Hibs "%s" mez nv';
  SIntFuncError         = 'Bels hiba a %s fggvnyben';
  SIncorrectArgs        = 'Helytelen paramterszm';
  SRefreshError         = 'Query frisstsi hiba';
  STransactNotDefined   = 'Tranzakcis komponens nem definilt';
  SAllocError           = 'Memria-allokcis hiba';
  SNotInsertMode        = 'Nincs Insert vagy Edit mdban';
  SIntBufferError       = 'Bels buffer struktra hiba';
  SROCmdError           = 'rvnytelen parancs "Csak olvashat" mdban';
  SIncorrectLinks       = 'rvnytelen link lett meghatrozva';
  SCyclicLinkError      = 'Ciklikus hivatkozs a Dataset-ben';
  SDetailQueryError     = 'Hiba a rszletes lekrdezsben';
  SUnableListProp       = 'Nem tudom listzni ezt a tulajdonsgot';
  SReadBlobError        = 'Nem lehet olvasni a BLOB-ot';
  SCreateBlobError      = 'Nem lehet ltrehozni a BLOB-ot';
  SDropBlobError        = 'Nem lehet eltvoltani a BLOB-ot';
  SDatasetNotDefined    = 'Dataset komponens nincs definilva';
  SUpdateSqlIsEmpty 	= 'UpdateSql lekrdezs res';
  SFailAddNull          = 'Nem lehet null rtket adni a "%s" nem null meznek';
  SPostError            = 'Hiba a mdostsok rgztsekor';
  SNotifyRegister       = 'Error registering/unregistering Notify to %s';
  SEventLength          = 'Event length (%d) is greater then the maximum allowed (%d)';
  SConstraintFailed     = 'Record or field constraint failed  : %s';

{$ENDIF}

implementation

end.
